/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBWHandlerConfiguration {
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";
    @NotNull
    private final DBWHandlerDescriptor descriptor;
    private DBPDataSourceContainer dataSource;
    private boolean enabled;
    private String userName;
    private String password;
    private boolean savePassword = true;
    private final Map<String, Object> properties;

    public DBWHandlerConfiguration(@NotNull DBWHandlerDescriptor descriptor, DBPDataSourceContainer dataSource) {
        this.descriptor = descriptor;
        this.dataSource = dataSource;
        this.properties = new HashMap<String, Object>();
    }

    public DBWHandlerConfiguration(@NotNull DBWHandlerConfiguration configuration) {
        this.descriptor = configuration.descriptor;
        this.dataSource = configuration.dataSource;
        this.enabled = configuration.enabled;
        this.userName = configuration.userName;
        this.password = configuration.password;
        this.savePassword = configuration.savePassword;
        this.properties = new HashMap<String, Object>(configuration.properties);
    }

    @NotNull
    public DBWHandlerDescriptor getHandlerDescriptor() {
        return this.descriptor;
    }

    public <T extends DBWNetworkHandler> T createHandler(Class<T> type) throws DBException {
        try {
            return this.descriptor.createHandler(type);
        }
        catch (Exception e) {
            throw new DBException("Cannot create tunnel '" + this.descriptor.getLabel() + "'", e);
        }
    }

    public DBPDriver getDriver() {
        return this.dataSource == null ? null : this.dataSource.getDriver();
    }

    public DBPDataSourceContainer getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DBPDataSourceContainer dataSource) {
        this.dataSource = dataSource;
    }

    public DBWHandlerType getType() {
        return this.descriptor.getType();
    }

    public boolean isSecured() {
        return this.descriptor.isSecured();
    }

    @NotNull
    public String getId() {
        return this.descriptor.getId();
    }

    public String getTitle() {
        return this.descriptor.getLabel();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    @Nullable
    public Object getProperty(@NotNull String name) {
        return this.properties.get(name);
    }

    @Nullable
    public String getStringProperty(@NotNull String name) {
        return CommonUtils.toString((Object)this.properties.get(name), null);
    }

    public int getIntProperty(@NotNull String name) {
        return CommonUtils.toInt((Object)this.properties.get(name));
    }

    public boolean getBooleanProperty(@NotNull String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(@NotNull String name, boolean defValue) {
        return CommonUtils.getBoolean((Object)this.properties.get(name), (boolean)defValue);
    }

    public void setProperty(@NotNull String name, @Nullable Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(@NotNull Map<String, Object> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBWHandlerConfiguration)) {
            return false;
        }
        DBWHandlerConfiguration source = (DBWHandlerConfiguration)obj;
        return CommonUtils.equalObjects((Object)this.descriptor, (Object)source.descriptor) && CommonUtils.equalObjects((Object)this.dataSource, (Object)source.dataSource) && this.enabled == source.enabled && CommonUtils.equalObjects((Object)this.userName, (Object)source.userName) && CommonUtils.equalObjects((Object)this.password, (Object)source.password) && this.savePassword == source.savePassword && CommonUtils.equalObjects(this.properties, source.properties);
    }

    public void resolveDynamicVariables(IVariableResolver variableResolver) {
        this.userName = GeneralUtils.replaceVariables(this.userName, variableResolver);
        this.password = GeneralUtils.replaceVariables(this.password, variableResolver);
        for (String prop : this.properties.keySet()) {
            Object value = this.properties.get(prop);
            if (!(value instanceof String) || CommonUtils.isEmpty((String)((String)value))) continue;
            this.properties.put(prop, GeneralUtils.replaceVariables((String)value, variableResolver));
        }
    }

    public boolean hasValuableInfo() {
        return !CommonUtils.isEmpty((String)this.userName) || !CommonUtils.isEmpty((String)this.password) || !CommonUtils.isEmpty(this.properties);
    }

    public String toString() {
        return this.descriptor.toString();
    }
}

