/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;

public class NavigatorHandlerSetDefaultObject
extends NavigatorHandlerObjectBase
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structSelection;
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (element = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof DBNDatabaseNode) {
            this.markObjectAsActive((DBNDatabaseNode)element, activeEditor);
        }
        return null;
    }

    private void markObjectAsActive(DBNDatabaseNode databaseNode, IEditorPart activeEditor) {
        DBNNode parentNode = databaseNode.getParentNode();
        if (parentNode instanceof DBNDatabaseItem) {
            this.markObjectAsActive((DBNDatabaseNode)((DBNDatabaseItem)parentNode), activeEditor);
        }
        DBSObject object = databaseNode.getObject();
        DBPDataSource dataSource = object.getDataSource();
        DBCExecutionContext editorContext = activeEditor instanceof DBPContextProvider ? ((DBPContextProvider)activeEditor).getExecutionContext() : null;
        TasksJob.runTask((String)"Change default object", monitor -> {
            try {
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)dataSource, param -> {
                    try {
                        DBCExecutionContext defaultContext = dataSource.getDefaultInstance().getDefaultContext(monitor, false);
                        DBCExecutionContext[] contextsToChange = editorContext != null && editorContext != defaultContext && editorContext.getDataSource() == defaultContext.getDataSource() ? new DBCExecutionContext[]{defaultContext, editorContext} : new DBCExecutionContext[]{defaultContext};
                        DBCExecutionContext[] dBCExecutionContextArray = contextsToChange;
                        int n = contextsToChange.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DBCExecutionContext executionContext = dBCExecutionContextArray[n2];
                            DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
                            if (contextDefaults != null) {
                                if (object instanceof DBSCatalog && contextDefaults.supportsCatalogChange()) {
                                    contextDefaults.setDefaultCatalog(monitor, (DBSCatalog)object, null);
                                } else if (object instanceof DBSSchema && contextDefaults.supportsSchemaChange()) {
                                    contextDefaults.setDefaultSchema(monitor, (DBSSchema)object);
                                } else {
                                    throw new DBCException("Internal error: active object change not supported");
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        });
    }

    public void updateElement(UIElement element, Map parameters) {
        if (!updateUI) {
            return;
        }
    }
}

