/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleExecutionContext;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class OracleStructureAssistant
implements DBSStructureAssistant<OracleExecutionContext> {
    private static final Log log = Log.getLog(OracleStructureAssistant.class);
    private final OracleDataSource dataSource;

    public OracleStructureAssistant(OracleDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.PACKAGE, OracleObjectType.CONSTRAINT, OracleObjectType.FOREIGN_KEY, OracleObjectType.INDEX, OracleObjectType.PROCEDURE, OracleObjectType.SEQUENCE, OracleObjectType.TRIGGER};
    }

    public DBSObjectType[] getSearchObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.VIEW, OracleObjectType.MATERIALIZED_VIEW, OracleObjectType.PACKAGE, OracleObjectType.INDEX, OracleObjectType.PROCEDURE, OracleObjectType.SEQUENCE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.PACKAGE, OracleObjectType.PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{OracleObjectType.TABLE, OracleObjectType.PACKAGE, OracleObjectType.PROCEDURE};
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull OracleExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        OracleSchema schema = params.getParentObject() instanceof OracleSchema ? (OracleSchema)params.getParentObject() : null;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find objects by name");){
                ArrayList<DBSObjectReference> objects = new ArrayList<DBSObjectReference>();
                if (ArrayUtils.contains((Object[])params.getObjectTypes(), (Object[])new DBSObjectType[]{OracleObjectType.CONSTRAINT, OracleObjectType.FOREIGN_KEY})) {
                    this.findConstraintsByMask(session, schema, params, objects);
                    if (!this.containsOnlyConstraintOrFK(params.getObjectTypes())) {
                        this.searchAllObjects(session, schema, params, objects);
                    }
                } else {
                    this.searchAllObjects(session, schema, params, objects);
                }
                if (params.isSearchInComments()) {
                    this.searchInTableComments(session, schema, params, objects);
                }
                OracleSchema activeSchema = executionContext.getContextDefaults().getDefaultSchema();
                objects.sort((o1, o2) -> {
                    if (CommonUtils.equalObjects((Object)o1.getContainer(), (Object)o2.getContainer())) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    if (o1.getContainer() == null || o1.getContainer() == activeSchema) {
                        return -1;
                    }
                    if (o2.getContainer() == null || o2.getContainer() == activeSchema) {
                        return 1;
                    }
                    return o1.getContainer().getName().compareTo(o2.getContainer().getName());
                });
                return objects;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, (DBPDataSource)this.dataSource);
        }
    }

    private void findConstraintsByMask(JDBCSession session, final OracleSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        List<DBSObjectType> objectTypesList = Arrays.asList(params.getObjectTypes());
        final boolean hasFK = objectTypesList.contains((Object)OracleObjectType.FOREIGN_KEY);
        final boolean hasConstraints = objectTypesList.contains((Object)OracleObjectType.CONSTRAINT);
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint((OracleDataSource)session.getDataSource()) + " OWNER, TABLE_NAME, CONSTRAINT_NAME, CONSTRAINT_TYPE\n" + "FROM " + OracleUtils.getAdminAllViewPrefix(monitor, (OracleDataSource)session.getDataSource(), "CONSTRAINTS") + "\n" + "WHERE CONSTRAINT_NAME like ?" + (!hasFK ? " AND CONSTRAINT_TYPE<>'R'" : "") + (schema != null ? " AND OWNER=?" : ""));){
            dbStat.setString(1, params.getMask().toUpperCase());
            if (schema != null) {
                dbStat.setString(2, schema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next() && objects.size() < params.getMaxResults()) {
                    final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    final String constrName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
                    String constrType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
                    final DBSEntityConstraintType type = OracleTableConstraint.getConstraintType(constrType);
                    objects.add((DBSObjectReference)new AbstractObjectReference(constrName, this.dataSource.getSchema(session.getProgressMonitor(), schemaName), null, type == DBSEntityConstraintType.FOREIGN_KEY ? OracleTableForeignKey.class : OracleTableConstraint.class, type == DBSEntityConstraintType.FOREIGN_KEY ? OracleObjectType.FOREIGN_KEY : OracleObjectType.CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            OracleSchema tableSchema;
                            OracleSchema oracleSchema = tableSchema = schema != null ? schema : OracleStructureAssistant.this.dataSource.getSchema(monitor, schemaName);
                            if (tableSchema == null) {
                                throw new DBException("Constraint schema '" + schemaName + "' not found");
                            }
                            OracleTable table = tableSchema.getTable(monitor, tableName);
                            if (table == null) {
                                throw new DBException("Constraint table '" + tableName + "' not found in catalog '" + tableSchema.getName() + "'");
                            }
                            Object constraint = null;
                            if (hasFK && type == DBSEntityConstraintType.FOREIGN_KEY) {
                                constraint = table.getForeignKey(monitor, constrName);
                            }
                            if (hasConstraints && type != DBSEntityConstraintType.FOREIGN_KEY) {
                                constraint = table.getConstraint(monitor, constrName);
                            }
                            if (constraint == null) {
                                throw new DBException("Constraint '" + constrName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void searchAllObjects(JDBCSession session, OracleSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException, DBException {
        ArrayList<OracleObjectType> oracleObjectTypes = new ArrayList<OracleObjectType>(params.getObjectTypes().length + 2);
        Object object = params.getObjectTypes();
        int n = ((DBSObjectType[])object).length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType objectType = object[n2];
            if (objectType instanceof OracleObjectType) {
                oracleObjectTypes.add((OracleObjectType)objectType);
                if (objectType == OracleObjectType.PROCEDURE) {
                    oracleObjectTypes.add(OracleObjectType.FUNCTION);
                }
            } else if (DBSProcedure.class.isAssignableFrom(objectType.getTypeClass())) {
                oracleObjectTypes.add(OracleObjectType.FUNCTION);
                oracleObjectTypes.add(OracleObjectType.PROCEDURE);
            }
            ++n2;
        }
        StringJoiner objectTypeClause = new StringJoiner(",");
        for (OracleObjectType objectType : oracleObjectTypes) {
            objectTypeClause.add("'" + objectType.getTypeName() + "'");
        }
        if (objectTypeClause.length() == 0) {
            return;
        }
        OracleDataSource dataSource = (OracleDataSource)session.getDataSource();
        String objectNameMask = params.getMask();
        object = null;
        Object var10_14 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint(dataSource) + " DISTINCT OWNER,OBJECT_NAME,OBJECT_TYPE FROM " + "   (SELECT OWNER,OBJECT_NAME,OBJECT_TYPE FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "OBJECTS") + " WHERE " + "OBJECT_TYPE IN (" + objectTypeClause + ") AND " + (!params.isCaseSensitive() ? "UPPER(OBJECT_NAME)" : "OBJECT_NAME") + " LIKE ? " + (schema == null ? "" : " AND OWNER=?") + "UNION ALL\n" + "SELECT " + OracleUtils.getSysCatalogHint(dataSource) + " O.OWNER,O.OBJECT_NAME,O.OBJECT_TYPE\n" + "FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "SYNONYMS") + " S," + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), dataSource, "OBJECTS") + " O\n" + "WHERE O.OWNER=S.TABLE_OWNER AND O.OBJECT_NAME=S.TABLE_NAME AND O.OBJECT_TYPE<>'JAVA CLASS' AND " + (!params.isCaseSensitive() ? "UPPER(S.SYNONYM_NAME)" : "S.SYNONYM_NAME") + "  LIKE ?)" + "\nORDER BY OBJECT_NAME");){
            if (!params.isCaseSensitive()) {
                objectNameMask = objectNameMask.toUpperCase();
            }
            dbStat.setString(1, objectNameMask);
            if (schema != null) {
                dbStat.setString(2, schema.getName());
            }
            dbStat.setString(schema != null ? 3 : 2, objectNameMask);
            dbStat.setFetchSize(1000);
            Throwable throwable = null;
            Object var13_19 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!session.getProgressMonitor().isCanceled() && objects.size() < params.getMaxResults() && dbResult.next()) {
                    String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
                    String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME");
                    String objectTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_TYPE");
                    OracleObjectType objectType = OracleObjectType.getByType(objectTypeName);
                    if (objectType == null || !objectType.isBrowsable() || !oracleObjectTypes.contains((Object)objectType)) continue;
                    OracleSchema objectSchema = this.dataSource.getSchema(session.getProgressMonitor(), schemaName);
                    if (objectSchema == null) {
                        log.debug((Object)("Schema '" + schemaName + "' not found. Probably was filtered"));
                        continue;
                    }
                    this.addObjectReference(objects, objectName, objectSchema, objectType, objectTypeName, schemaName, session);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private void addObjectReference(@NotNull Collection<DBSObjectReference> references, final String objectName, @NotNull DBSObject objectSchema, final @NotNull OracleObjectType objectType, final String objectTypeName, final String schemaName, final @NotNull JDBCSession session) {
        references.add((DBSObjectReference)new AbstractObjectReference(objectName, objectSchema, null, objectType.getTypeClass(), objectType){

            public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                OracleSchema tableSchema = (OracleSchema)this.getContainer();
                DBSObject object = objectType.findObject(session.getProgressMonitor(), tableSchema, objectName);
                if (object == null) {
                    throw new DBException(String.valueOf(objectTypeName) + " '" + objectName + "' not found in schema '" + tableSchema.getName() + "'");
                }
                return object;
            }

            @NotNull
            public String getFullyQualifiedName(DBPEvaluationContext context) {
                if (objectType == OracleObjectType.SYNONYM && "PUBLIC".equals(schemaName)) {
                    return DBUtils.getQuotedIdentifier((DBPDataSource)OracleStructureAssistant.this.dataSource, (String)objectName);
                }
                return super.getFullyQualifiedName(context);
            }
        });
    }

    private void searchInTableComments(@NotNull JDBCSession session, @Nullable OracleSchema schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> objects) throws SQLException, DBException {
        if (objects.size() >= params.getMaxResults() || !ArrayUtils.contains((Object[])params.getObjectTypes(), (Object)((Object)OracleObjectType.TABLE))) {
            return;
        }
        StringBuilder sql = new StringBuilder("SELECT atc.OWNER, atc.TABLE_NAME, atc.TABLE_TYPE FROM ALL_TAB_COMMENTS atc WHERE ");
        String mask = params.getMask();
        if (params.isCaseSensitive()) {
            sql.append("atc.COMMENTS ");
        } else {
            sql.append("UPPER(atc.COMMENTS) ");
            mask = mask.toUpperCase();
        }
        sql.append("LIKE ? ");
        if (schema != null) {
            sql.append("AND atc.OWNER = ? ");
        }
        sql.append("ORDER BY atc.TABLE_NAME");
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCPreparedStatement preparedStatement = session.prepareStatement(sql.toString());){
            preparedStatement.setString(1, mask);
            if (schema != null) {
                preparedStatement.setString(2, schema.getName());
            }
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet resultSet = preparedStatement.executeQuery();){
                while (!session.getProgressMonitor().isCanceled() && objects.size() < params.getMaxResults() && resultSet.next()) {
                    String owner = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OWNER");
                    String tableName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_NAME");
                    String tableType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_TYPE");
                    OracleObjectType oracleObjectType = OracleObjectType.getByType(tableType);
                    if (oracleObjectType == null || !oracleObjectType.isBrowsable() || tableName == null) continue;
                    OracleSchema objectSchema = this.dataSource.getSchema(session.getProgressMonitor(), owner);
                    if (objectSchema == null) {
                        log.debug((Object)("Schema '" + owner + "' not found. Probably was filtered"));
                        continue;
                    }
                    this.addObjectReference(objects, tableName, objectSchema, oracleObjectType, tableType, owner, session);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private boolean containsOnlyConstraintOrFK(DBSObjectType[] objectTypes) {
        DBSObjectType[] dBSObjectTypeArray = objectTypes;
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType objectType = dBSObjectTypeArray[n2];
            if (objectType != OracleObjectType.CONSTRAINT && objectType != OracleObjectType.FOREIGN_KEY) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

