/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaColumn;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class GenericUtils {
    public static Object getColumn(GenericDataSource dataSource, String objectType, String columnId) {
        GenericMetaObject object = dataSource.getMetaObject(objectType);
        if (object == null) {
            return columnId;
        }
        GenericMetaColumn column = object.getColumn(columnId);
        if (column == null || !column.isSupported()) {
            return columnId;
        }
        return column.getColumnIdentifier();
    }

    public static Object getColumn(GenericMetaObject object, String columnId) {
        GenericMetaColumn column;
        GenericMetaColumn genericMetaColumn = column = object == null ? null : object.getColumn(columnId);
        if (column == null || !column.isSupported()) {
            return columnId;
        }
        return column.getColumnIdentifier();
    }

    public static String safeGetString(GenericMetaObject object, ResultSet dbResult, String columnId) {
        Object column = GenericUtils.getColumn(object, columnId);
        if (column instanceof Number) {
            return JDBCUtils.safeGetString((ResultSet)dbResult, (int)((Number)column).intValue());
        }
        return JDBCUtils.safeGetString((ResultSet)dbResult, (String)column.toString());
    }

    public static String safeGetStringTrimmed(GenericMetaObject object, ResultSet dbResult, String columnId) {
        Object column = GenericUtils.getColumn(object, columnId);
        if (column instanceof Number) {
            return JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (int)((Number)column).intValue());
        }
        return JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)column.toString());
    }

    public static int safeGetInt(GenericMetaObject object, ResultSet dbResult, String columnId) {
        Object column = GenericUtils.getColumn(object, columnId);
        if (column instanceof Number) {
            return JDBCUtils.safeGetInt((ResultSet)dbResult, (int)((Number)column).intValue());
        }
        return JDBCUtils.safeGetInt((ResultSet)dbResult, (String)column.toString());
    }

    public static Integer safeGetInteger(GenericMetaObject object, ResultSet dbResult, String columnId) {
        Object column = GenericUtils.getColumn(object, columnId);
        if (column instanceof Number) {
            return JDBCUtils.safeGetInteger((ResultSet)dbResult, (int)((Number)column).intValue());
        }
        return JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)column.toString());
    }

    public static long safeGetLong(GenericMetaObject object, ResultSet dbResult, String columnId) {
        Object column = GenericUtils.getColumn(object, columnId);
        if (column instanceof Number) {
            return JDBCUtils.safeGetLong((ResultSet)dbResult, (int)((Number)column).intValue());
        }
        return JDBCUtils.safeGetLong((ResultSet)dbResult, (String)column.toString());
    }

    public static double safeGetDouble(GenericMetaObject object, ResultSet dbResult, String columnId) {
        Object column = GenericUtils.getColumn(object, columnId);
        if (column instanceof Number) {
            return JDBCUtils.safeGetDouble((ResultSet)dbResult, (int)((Number)column).intValue());
        }
        return JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)column.toString());
    }

    public static BigDecimal safeGetBigDecimal(GenericMetaObject object, ResultSet dbResult, String columnId) {
        Object column = GenericUtils.getColumn(object, columnId);
        if (column instanceof Number) {
            return JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (int)((Number)column).intValue());
        }
        return JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)column.toString());
    }

    public static boolean safeGetBoolean(GenericMetaObject object, ResultSet dbResult, String columnId) {
        Object column = GenericUtils.getColumn(object, columnId);
        if (column instanceof Number) {
            return JDBCUtils.safeGetBoolean((ResultSet)dbResult, (int)((Number)column).intValue());
        }
        return JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)column.toString());
    }

    public static Object safeGetObject(GenericMetaObject object, ResultSet dbResult, String columnId) {
        Object column = GenericUtils.getColumn(object, columnId);
        if (column instanceof Number) {
            return JDBCUtils.safeGetObject((ResultSet)dbResult, (int)((Number)column).intValue());
        }
        return JDBCUtils.safeGetObject((ResultSet)dbResult, (String)column.toString());
    }

    public static boolean isLegacySQLDialect(DBSObject owner) {
        SQLDialect dialect = SQLUtils.getDialectFromObject((DBPObject)owner);
        return dialect instanceof GenericSQLDialect && ((GenericSQLDialect)dialect).isLegacySQLDialect();
    }

    public static String normalizeProcedureName(String procedureName) {
        int divPos = procedureName.lastIndexOf(59);
        if (divPos != -1) {
            procedureName = procedureName.substring(0, divPos);
        }
        return procedureName;
    }
}

