/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ViewportLayout
extends AbstractHintLayout {
    protected Dimension calculateMinimumSize(IFigure figure, int wHint, int hHint) {
        Viewport viewport = (Viewport)figure;
        Dimension min = new Dimension();
        Insets insets = viewport.getInsets();
        return min.getExpanded(insets.getWidth(), insets.getHeight());
    }

    protected Dimension calculatePreferredSize(IFigure parent, int wHint, int hHint) {
        Viewport viewport = (Viewport)parent;
        Insets insets = viewport.getInsets();
        IFigure contents = viewport.getContents();
        wHint = viewport.getContentsTracksWidth() && wHint > -1 ? Math.max(0, wHint - insets.getWidth()) : -1;
        hHint = viewport.getContentsTracksHeight() && hHint > -1 ? Math.max(0, hHint - insets.getHeight()) : -1;
        if (contents == null) {
            return new Dimension(insets.getWidth(), insets.getHeight());
        }
        Dimension minSize = contents.getMinimumSize(wHint, hHint);
        if (wHint > -1) {
            wHint = Math.max(wHint, minSize.width);
        }
        if (hHint > -1) {
            hHint = Math.max(hHint, minSize.height);
        }
        return contents.getPreferredSize(wHint, hHint).getExpanded(insets.getWidth(), insets.getHeight());
    }

    protected boolean isSensitiveHorizontally(IFigure parent) {
        return ((Viewport)parent).getContentsTracksWidth();
    }

    protected boolean isSensitiveVertically(IFigure parent) {
        return ((Viewport)parent).getContentsTracksHeight();
    }

    public void layout(IFigure figure) {
        Viewport viewport = (Viewport)figure;
        IFigure contents = viewport.getContents();
        if (contents == null) {
            return;
        }
        Point p = viewport.getClientArea().getLocation();
        p.translate(viewport.getViewLocation().getNegated());
        Rectangle hints = viewport.getClientArea();
        int wHint = viewport.getContentsTracksWidth() ? hints.width : -1;
        int hHint = viewport.getContentsTracksHeight() ? hints.height : -1;
        Dimension newSize = viewport.getClientArea().getSize();
        Dimension min = contents.getMinimumSize(wHint, hHint);
        Dimension pref = contents.getPreferredSize(wHint, hHint);
        newSize.height = viewport.getContentsTracksHeight() ? Math.max(newSize.height, min.height) : Math.max(newSize.height, pref.height);
        newSize.width = viewport.getContentsTracksWidth() ? Math.max(newSize.width, min.width) : Math.max(newSize.width, pref.width);
        contents.setBounds(new Rectangle(p, newSize));
    }
}

