/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEStructEditor;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;

public abstract class NavigatorHandlerCreateColumnObjectBase
extends NavigatorHandlerObjectBase {
    private static final Log log = Log.getLog(NavigatorHandlerCreateColumnObjectBase.class);

    static Object createColumnObject(@NotNull ExecutionEvent event, @NotNull Class<?> columnObjectSuperType) {
        DBNNode node = NavigatorUtils.getSelectedNode(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (!(node instanceof DBNDatabaseItem)) {
            log.error((Object)"Selected node is not a database item");
            return null;
        }
        DBNNode containerNode = node.getParentNode();
        if (containerNode == null) {
            log.error((Object)"Selected node has no parent");
            return null;
        }
        DBSObject attributeObject = ((DBNDatabaseItem)node).getObject();
        if (!(attributeObject instanceof DBSEntityAttribute)) {
            log.error((Object)"Selected node's object is not an attribute");
            return null;
        }
        DBSObject entityObject = attributeObject.getParentObject();
        if (!(entityObject instanceof DBSEntity)) {
            log.error((Object)"Selected node's attribute has no parent");
            return null;
        }
        DBEStructEditor structEditor = (DBEStructEditor)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(entityObject.getClass(), DBEStructEditor.class);
        if (structEditor == null) {
            log.error((Object)"No struct editor exists for entity");
            return null;
        }
        DBEObjectMaker maker = null;
        Class columnObjectConcreteType = null;
        Class[] classArray = structEditor.getChildTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class childType = classArray[n2];
            maker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(childType, DBEObjectMaker.class);
            if (maker != null && maker.canCreateObject((Object)entityObject) && columnObjectSuperType.isAssignableFrom(childType)) {
                columnObjectConcreteType = childType;
                break;
            }
            ++n2;
        }
        if (columnObjectConcreteType == null) {
            log.error((Object)"Unable to find appropriate child type and it's maker");
            return null;
        }
        try {
            DBECommandContext commandContext = NavigatorHandlerCreateColumnObjectBase.getCommandTarget(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), containerNode, columnObjectConcreteType, false).getContext();
            NavigatorHandlerCreateColumnObjectBase.createNewObject(maker, commandContext, entityObject);
        }
        catch (DBException e) {
            log.warn((Object)("Unable to create object of type " + columnObjectConcreteType.getName()), (Throwable)e);
        }
        return null;
    }

    static void createNewObject(@NotNull DBEObjectMaker<?, ?> maker, DBECommandContext commandContext, DBSObject entityObject) throws DBException {
        DBException[] dbExceptions = new DBException[1];
        try {
            UIUtils.getDefaultRunnableContext().run(false, false, monitor -> {
                try {
                    maker.createNewObject(monitor, commandContext, (Object)entityObject, null, Collections.emptyMap());
                }
                catch (DBException e) {
                    dBExceptionArray[0] = e;
                }
            });
        }
        catch (InvocationTargetException e) {
            log.warn((Object)"Unexpected invocation target exception while creating new object", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        if (dbExceptions[0] != null) {
            throw dbExceptions[0];
        }
    }
}

