/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttributeIdentity;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionAtomic;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreTableColumnManager
extends SQLTableColumnManager<PostgreTableColumn, PostgreTableBase>
implements DBEObjectRenamer<PostgreTableColumn>,
DBPScriptObjectExt2 {
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreDataTypeModifier = (monitor, column, sql, command) -> {
        sql.append(' ');
        PostgreDataType dataType = column.getDataType();
        PostgreDataType rawType = null;
        if (rawType != null) {
            sql.append(rawType.getFullyQualifiedName(DBPEvaluationContext.DDL));
        } else if (dataType != null) {
            sql.append(dataType.getFullyQualifiedName(DBPEvaluationContext.DDL));
        } else {
            sql.append(column.getFullTypeName());
        }
        PostgreTableColumnManager.getColumnDataTypeModifiers(monitor, (DBSTypedObject)column, sql);
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreDefaultModifier = (monitor, column, sql, command) -> {
        String defaultValue = column.getDefaultValue();
        if (!CommonUtils.isEmpty((String)defaultValue) && defaultValue.startsWith("nextval") && PostgreConstants.SERIAL_TYPES.containsKey(column.getDataType().getName())) {
            return;
        }
        this.DefaultModifier.appendModifier(monitor, column, sql, command);
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreIdentityModifier = (monitor, column, sql, command) -> {
        PostgreAttributeIdentity identity = column.getIdentity();
        if (identity != null) {
            sql.append(" ").append(identity.getDefinitionClause());
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreCollateModifier = (monitor, column, sql, command) -> {
        try {
            PostgreCollation collation = column.getCollation(monitor);
            if (collation != null && !"default".equals(collation.getName())) {
                sql.append(" COLLATE \"").append(collation.getName()).append("\"");
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreCommentModifier = (monitor, column, sql, command) -> {
        String comment = column.getDescription();
        if (!CommonUtils.isEmpty((String)comment)) {
            sql.append(" -- ").append(CommonUtils.getSingleLineString((String)comment));
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<PostgreTableColumn> PostgreGeneratedModifier = (monitor, column, sql, command) -> {
        String generatedValue = column.getGeneratedValue();
        if (!CommonUtils.isEmpty((String)generatedValue)) {
            sql.append(" GENERATED ALWAYS AS (").append(generatedValue).append(") STORED");
        }
    };

    public static StringBuilder getColumnDataTypeModifiers(DBRProgressMonitor monitor, DBSTypedObject column, StringBuilder sql) {
        if (column instanceof PostgreTableColumn) {
            String[] foreignTableColumnOptions;
            PostgreTableColumn postgreColumn = (PostgreTableColumn)column;
            Object rawType = null;
            switch (postgreColumn.getDataKind()) {
                case STRING: {
                    long length = postgreColumn.getMaxLength();
                    if (length <= 0L || length >= Integer.MAX_VALUE) break;
                    sql.append('(').append(length).append(')');
                    break;
                }
                case NUMERIC: {
                    if (column.getTypeID() != 2) break;
                    int precision = CommonUtils.toInt((Object)postgreColumn.getPrecision());
                    int scale = CommonUtils.toInt((Object)postgreColumn.getScale());
                    if (scale <= 0 && precision <= 0) break;
                    sql.append('(');
                    if (precision > 0) {
                        sql.append(precision);
                    }
                    if (scale > 0) {
                        if (precision > 0) {
                            sql.append(',');
                        }
                        sql.append(scale);
                    }
                    sql.append(')');
                    break;
                }
                case DATETIME: {
                    int scale = CommonUtils.toInt((Object)postgreColumn.getScale());
                    String typeName = column.getTypeName();
                    if ((typeName.startsWith("timestamp") || typeName.equals("time")) && scale < 6) {
                        sql.append('(').append(scale).append(')');
                    }
                    if (!typeName.equals("interval")) break;
                    String precision = postgreColumn.getIntervalTypeField();
                    if (!CommonUtils.isEmpty((String)precision)) {
                        sql.append(' ').append(precision);
                    }
                    if (scale < 0 || scale >= 7) break;
                    sql.append('(').append(scale).append(')');
                }
            }
            if (PostgreUtils.isGISDataType(postgreColumn.getTypeName())) {
                try {
                    String geometryType = postgreColumn.getAttributeGeometryType(monitor);
                    int geometrySRID = postgreColumn.getAttributeGeometrySRID(monitor);
                    if (geometryType != null && !"geometry".equalsIgnoreCase(geometryType) && !"geography".equalsIgnoreCase(geometryType)) {
                        sql.append("(").append(geometryType);
                        if (geometrySRID > 0) {
                            sql.append(", ").append(geometrySRID);
                        }
                        sql.append(")");
                    }
                }
                catch (DBCException e) {
                    log.debug((Object)e);
                }
            }
            if (postgreColumn.getTable() instanceof PostgreTableForeign && (foreignTableColumnOptions = postgreColumn.getForeignTableColumnOptions()) != null && foreignTableColumnOptions.length != 0) {
                sql.append(" OPTIONS(").append(String.join((CharSequence)",", Arrays.asList(foreignTableColumnOptions))).append(")");
            }
            if (rawType != null) {
                sql.append("[]");
            }
            return sql;
        }
        return sql;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreTableColumn> getObjectsCache(PostgreTableColumn object) {
        return ((PostgreTableContainer)((PostgreTableBase)object.getParentObject()).getContainer()).getSchema().getTableCache().getChildrenCache((PostgreTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(PostgreTableColumn column, Map<String, Object> options) {
        Object[] modifiers = new SQLTableColumnManager.ColumnModifier[]{this.PostgreDataTypeModifier, this.NullNotNullModifier, this.PostgreDefaultModifier, this.PostgreIdentityModifier, this.PostgreCollateModifier, this.PostgreGeneratedModifier};
        if (CommonUtils.getOption(options, (String)"ddl.includeComments")) {
            modifiers = (SQLTableColumnManager.ColumnModifier[])ArrayUtils.add(SQLTableColumnManager.ColumnModifier.class, (Object[])modifiers, this.PostgreCommentModifier);
        }
        return modifiers;
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, PostgreTableBase owner, DBECommandAbstract<PostgreTableColumn> command, Map<String, Object> options) {
        StringBuilder decl = super.getNestedDeclaration(monitor, (DBSEntity)owner, command, options);
        PostgreAttribute cfr_ignored_0 = (PostgreAttribute)command.getObject();
        return decl;
    }

    protected PostgreTableColumn createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        PostgreTableColumn column;
        PostgreTableBase table = (PostgreTableBase)container;
        if (copyFrom instanceof PostgreTableColumn) {
            column = new PostgreTableColumn(monitor, table, (PostgreTableColumn)copyFrom);
        } else {
            column = new PostgreTableColumn(table);
            column.setName(this.getNewColumnName(monitor, context, table));
            PostgreDataType dataType = table.getDatabase().getDataType(monitor, 1043L);
            column.setDataType(dataType);
            column.setOrdinalPosition(-1);
        }
        return column;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        if (!CommonUtils.isEmpty((String)((PostgreTableColumn)command.getObject()).getDescription())) {
            PostgreTableColumnManager.addColumnCommentAction(actions, (PostgreAttribute)command.getObject());
        }
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        PostgreAttribute column = (PostgreAttribute)command.getObject();
        boolean isAtomic = column.getDataSource().getServerType().isAlterTableAtomic();
        String prefix = "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)column) + " ";
        String typeClause = column.getFullTypeName();
        if (column.getDataSource().isServerVersionAtLeast(8, 0) && column.getDataType() != null) {
            typeClause = String.valueOf(typeClause) + " USING " + DBUtils.getQuotedIdentifier((DBSObject)column) + "::" + column.getDataType().getName();
        }
        if (command.hasProperty((Object)"dataType") || command.hasProperty((Object)"maxLength") || command.hasProperty((Object)"precision") || command.hasProperty((Object)"scale")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Set column type", String.valueOf(prefix) + "TYPE " + typeClause, isAtomic));
        }
        if (command.hasProperty((Object)"required")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Set column nullability", String.valueOf(prefix) + (column.isRequired() ? "SET" : "DROP") + " NOT NULL", isAtomic));
        }
        if (command.hasProperty((Object)"defaultValue")) {
            if (CommonUtils.isEmpty((String)column.getDefaultValue())) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Drop column default", String.valueOf(prefix) + "DROP DEFAULT", isAtomic));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistActionAtomic("Set column default", String.valueOf(prefix) + "SET DEFAULT " + column.getDefaultValue(), isAtomic));
            }
        }
        if (command.getProperty((Object)"description") != null) {
            PostgreTableColumnManager.addColumnCommentAction(actionList, column);
        }
    }

    public static void addColumnCommentAction(List<DBEPersistAction> actionList, PostgreAttribute column) {
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column comment", "COMMENT ON COLUMN " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription()))));
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
        PostgreTableBase table = (PostgreTableBase)object.getTable();
        if (table.isPersisted() && table instanceof PostgreViewBase) {
            table.setObjectDefinitionText(null);
            commandContext.addCommand((DBECommand)new SQLObjectEditor.EmptyCommand((DBPObject)table), (DBECommandReflector)new SQLObjectEditor.RefreshObjectReflector(), true);
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreAttribute column = (PostgreAttribute)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return "ddl.includeComments".equals(option);
    }
}

