/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.completion;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.SQLTableAliasInsertMode;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionProposalBase;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.text.TextUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionAnalyzer
implements DBRRunnableParametrized<DBRProgressMonitor> {
    private static final Log log = Log.getLog(SQLCompletionAnalyzer.class);
    private static final String ALL_COLUMNS_PATTERN = "*";
    private static final String MATCH_ANY_PATTERN = "%";
    public static final int MAX_ATTRIBUTE_VALUE_PROPOSALS = 50;
    public static final int MAX_STRUCT_PROPOSALS = 100;
    private final SQLCompletionRequest request;
    private DBRProgressMonitor monitor;
    private final List<SQLCompletionProposalBase> proposals = new ArrayList<SQLCompletionProposalBase>();
    private boolean searchFinished = false;

    public SQLCompletionAnalyzer(SQLCompletionRequest request) {
        this.request = request;
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
        try {
            this.runAnalyzer(monitor);
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
    }

    public List<SQLCompletionProposalBase> getProposals() {
        return this.proposals;
    }

    public boolean isSearchFinished() {
        return this.searchFinished;
    }

    public void runAnalyzer(DBRProgressMonitor monitor) throws DBException {
        this.monitor = monitor;
        this.runAnalyzer();
    }

    /*
     * Unable to fully structure code
     */
    private void runAnalyzer() throws DBException {
        block73: {
            block67: {
                block72: {
                    block68: {
                        block70: {
                            block69: {
                                searchPrefix = this.request.getWordPart();
                                this.request.setQueryType(null);
                                wordDetector = this.request.getWordDetector();
                                syntaxManager = this.request.getContext().getSyntaxManager();
                                prevKeyWord = wordDetector.getPrevKeyWord();
                                isPrevWordEmpty = CommonUtils.isEmpty(wordDetector.getPrevWords());
                                prevDelimiter = wordDetector.getPrevDelimiter();
                                if (!CommonUtils.isEmpty((String)prevKeyWord)) {
                                    if (syntaxManager.getDialect().isEntityQueryWord(prevKeyWord)) {
                                        if ("DELETE".equals(prevKeyWord)) {
                                            this.request.setQueryType(null);
                                        } else if ("INTO".equals(prevKeyWord) && !isPrevWordEmpty && ("(".equals(prevDelimiter) || ",".equals(prevDelimiter))) {
                                            this.request.setQueryType(SQLCompletionRequest.QueryType.COLUMN);
                                        } else if ("INTO".equals(prevKeyWord) && !isPrevWordEmpty && ("(*".equals(prevDelimiter) || "{*".equals(prevDelimiter) || "[*".equals(prevDelimiter))) {
                                            wordDetector.shiftOffset(-"*".length());
                                            searchPrefix = "*";
                                            this.request.setQueryType(SQLCompletionRequest.QueryType.COLUMN);
                                        } else if ("JOIN".equals(prevKeyWord) && isPrevWordEmpty) {
                                            this.request.setQueryType(SQLCompletionRequest.QueryType.JOIN);
                                        } else {
                                            if (!isPrevWordEmpty && CommonUtils.isEmpty((String)prevDelimiter)) {
                                                return;
                                            }
                                            this.request.setQueryType(SQLCompletionRequest.QueryType.TABLE);
                                        }
                                    } else if (syntaxManager.getDialect().isAttributeQueryWord(prevKeyWord)) {
                                        this.request.setQueryType(SQLCompletionRequest.QueryType.COLUMN);
                                        if (!this.request.isSimpleMode() && CommonUtils.isEmpty((String)this.request.getWordPart()) && prevDelimiter.equals("*")) {
                                            wordDetector.shiftOffset(-"*".length());
                                            searchPrefix = "*";
                                        }
                                    } else if (SQLUtils.isExecQuery((SQLDialect)syntaxManager.getDialect(), (String)prevKeyWord)) {
                                        this.request.setQueryType(SQLCompletionRequest.QueryType.EXEC);
                                    }
                                }
                                this.request.setWordPart(searchPrefix);
                                dataSource = this.request.getContext().getDataSource();
                                if (dataSource == null) {
                                    return;
                                }
                                wordPart = this.request.getWordPart();
                                emptyWord = wordPart.length() == 0;
                                isInLiteral = "sql_character".equals(this.request.getContentType());
                                isInQuotedIdentifier = "sql_quoted".equals(this.request.getContentType());
                                queryType = this.request.getQueryType();
                                parameters = new LinkedHashMap<String, Object>();
                                prevWords = wordDetector.getPrevWords();
                                previousWord = "";
                                if (!CommonUtils.isEmpty(prevWords)) {
                                    previousWord = prevWords.get(0).toUpperCase(Locale.ENGLISH);
                                }
                                if (!CommonUtils.isEmpty(prevWords) && ("PROCEDURE".equals(previousWord) || "FUNCTION".equals(previousWord))) {
                                    parameters.put("exec", false);
                                } else {
                                    parameters.put("exec", true);
                                }
                                if (queryType == null) break block67;
                                if (!emptyWord && !isInLiteral && !isInQuotedIdentifier) break block68;
                                rootObject = null;
                                if (queryType != SQLCompletionRequest.QueryType.COLUMN || !(dataSource instanceof DBSObjectContainer)) break block69;
                                rootObject = this.getTableFromAlias((DBSObjectContainer)dataSource, null, true);
                                if (!(rootObject instanceof DBSEntity)) break block70;
                                var17_17 = prevKeyWord;
                                tmp = -1;
                                switch (var17_17.hashCode()) {
                                    case 2527: {
                                        if (var17_17.equals("ON")) {
                                            tmp = 1;
                                        }
                                        break;
                                    }
                                    case 2531: {
                                        if (var17_17.equals("OR")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                    case 64951: {
                                        if (var17_17.equals("AND")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                    case 82560199: {
                                        if (var17_17.equals("WHERE")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 1: {
                                        if (this.makeJoinColumnProposals((DBSObjectContainer)dataSource, (DBSEntity)rootObject)) {
                                            return;
                                        }
                                    }
                                    case 2: {
                                        if (this.request.isSimpleMode()) break block70;
                                        isLike = "LIKE".equals(previousWord) != false || "ILIKE".equals(previousWord) != false;
                                        v0 = waitsForValue = isInLiteral != false || CommonUtils.isEmpty(prevWords) == false && isLike != false || CommonUtils.isEmpty((String)prevDelimiter) == false && prevDelimiter.endsWith(")") == false;
                                        if (!waitsForValue) break block70;
                                        this.makeProposalsFromAttributeValues(dataSource, wordDetector, isInLiteral, (DBSEntity)rootObject);
                                    }
                                    default: {
                                        ** break;
                                    }
                                    {
lbl100:
                                        // 1 sources

                                        break block70;
                                    }
                                }
                            }
                            if (dataSource instanceof DBSObjectContainer) {
                                selectedObject = DBUtils.getActiveInstanceObject((DBCExecutionContext)this.request.getContext().getExecutionContext());
                                if (selectedObject != null) {
                                    this.makeProposalsFromChildren((DBPObject)selectedObject, null, false, parameters);
                                    rootObject = DBUtils.getPublicObject((DBSObject)selectedObject.getParentObject());
                                } else {
                                    rootObject = dataSource;
                                }
                            }
                        }
                        if (rootObject != null) {
                            this.makeProposalsFromChildren((DBPObject)rootObject, null, false, parameters);
                        }
                        if (queryType == SQLCompletionRequest.QueryType.JOIN && !this.proposals.isEmpty() && dataSource instanceof DBSObjectContainer && (leftTable = this.getTableFromAlias((DBSObjectContainer)dataSource, null, true)) instanceof DBSEntity) {
                            this.filterNonJoinableProposals((DBSEntity)leftTable);
                        }
                        break block72;
                    }
                    rootObject = null;
                    if (queryType == SQLCompletionRequest.QueryType.COLUMN && dataSource instanceof DBSObjectContainer) {
                        sc = (DBSObjectContainer)dataSource;
                        selectedObject = DBUtils.getActiveInstanceObject((DBCExecutionContext)this.request.getContext().getExecutionContext());
                        if (selectedObject instanceof DBSObjectContainer) {
                            sc = (DBSObjectContainer)selectedObject;
                        }
                        sqlDialect = this.request.getContext().getDataSource().getSQLDialect();
                        tableAlias = null;
                        if ("*".equals(wordPart) && !isPrevWordEmpty && !prevKeyWord.equalsIgnoreCase("INTO") && (prevWord = wordDetector.getPrevWords().get(0)).contains(sqlDialect.getCatalogSeparator())) {
                            divPos = prevWord.lastIndexOf(sqlDialect.getCatalogSeparator());
                            tableAlias = prevWord.substring(0, divPos);
                        }
                        if (tableAlias == null) {
                            divPos = wordPart.lastIndexOf(syntaxManager.getStructSeparator());
                            v1 = tableAlias = divPos == -1 ? null : wordPart.substring(0, divPos);
                        }
                        if (tableAlias == null && !CommonUtils.isEmpty((String)wordPart) && (rootObject = this.getTableFromAlias(sc, wordPart, false)) != null) {
                            this.searchFinished = true;
                            return;
                        }
                        rootObject = this.getTableFromAlias(sc, tableAlias, false);
                        if (rootObject == null && tableAlias != null) {
                            allNames = SQLUtils.splitFullIdentifier((String)tableAlias, (String)sqlDialect.getCatalogSeparator(), (String[][])sqlDialect.getIdentifierQuoteStrings(), (boolean)false);
                            rootObject = SQLSearchUtils.findObjectByFQN(this.monitor, sc, this.request.getContext().getExecutionContext(), Arrays.asList(allNames), this.request.isSimpleMode() == false, wordDetector);
                        }
                    }
                    if (rootObject != null) {
                        this.makeProposalsFromChildren((DBPObject)rootObject, wordPart, false, parameters);
                    } else if (queryType != SQLCompletionRequest.QueryType.COLUMN && queryType != SQLCompletionRequest.QueryType.EXEC) {
                        this.makeDataSourceProposals();
                    }
                }
                if (!this.request.isSimpleMode() && (queryType == SQLCompletionRequest.QueryType.EXEC || queryType == SQLCompletionRequest.QueryType.COLUMN && this.request.getContext().isSearchProcedures()) && dataSource instanceof DBSObjectContainer) {
                    this.makeProceduresProposals(dataSource, wordPart, true);
                }
                break block73;
            }
            if (!this.request.isSimpleMode() && !CommonUtils.isEmpty(prevWords) && ("PROCEDURE".equals(previousWord) || "FUNCTION".equals(previousWord))) {
                this.makeProceduresProposals(dataSource, wordPart, false);
            }
        }
        if (!(emptyWord || isInLiteral || isInQuotedIdentifier)) {
            this.makeProposalsFromQueryParts();
        }
        if (!(this.searchFinished || isInLiteral || isInQuotedIdentifier)) {
            matchedKeywords = Collections.emptyList();
            allowedKeywords = null;
            sqlDialect = this.request.getContext().getDataSource().getSQLDialect();
            if (CommonUtils.isEmpty((String)prevKeyWord)) {
                allowedKeywords = new HashSet<String>();
                Collections.addAll(allowedKeywords, sqlDialect.getQueryKeywords());
                Collections.addAll(allowedKeywords, sqlDialect.getDMLKeywords());
                Collections.addAll(allowedKeywords, sqlDialect.getDDLKeywords());
                Collections.addAll(allowedKeywords, sqlDialect.getExecuteKeywords());
            } else if (ArrayUtils.contains((Object[])sqlDialect.getQueryKeywords(), (Object)prevKeyWord.toUpperCase(Locale.ENGLISH))) {
                delimiter = wordDetector.getPrevDelimiter();
                if (!isPrevWordEmpty && (CommonUtils.isEmpty((String)delimiter) || delimiter.endsWith(")"))) {
                    allowedKeywords = new HashSet<E>();
                    allowedKeywords.add("FROM");
                    if (CommonUtils.isEmpty((String)this.request.getWordPart())) {
                        matchedKeywords = Arrays.asList(new String[]{"FROM"});
                    }
                }
            } else if (sqlDialect.isEntityQueryWord(prevKeyWord)) {
                allowedKeywords = new HashSet<E>();
                if ("DELETE".equals(prevKeyWord)) {
                    allowedKeywords.add("FROM");
                } else {
                    allowedKeywords.add("WHERE");
                }
            }
            if (!CommonUtils.isEmpty((String)this.request.getWordPart())) {
                matchedKeywords = syntaxManager.getDialect().getMatchedKeywords(this.request.getWordPart());
                if (!this.request.isSimpleMode()) {
                    matchedKeywords.sort(Comparator.comparingInt((ToIntFunction<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$0(java.lang.String ), (Ljava/lang/String;)I)((SQLCompletionAnalyzer)this)));
                }
            }
            for (String keyWord : matchedKeywords) {
                keywordType = syntaxManager.getDialect().getKeywordType(keyWord);
                if (keywordType == null || keywordType == DBPKeywordType.TYPE || this.request.getQueryType() == SQLCompletionRequest.QueryType.COLUMN && keywordType != DBPKeywordType.FUNCTION && keywordType != DBPKeywordType.KEYWORD && keywordType != DBPKeywordType.OTHER || allowedKeywords != null && !allowedKeywords.contains(keyWord)) continue;
                this.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, keyWord, keyWord, keywordType, null, false, null, Collections.emptyMap()));
            }
        }
        this.filterProposals(dataSource);
    }

    private void makeProceduresProposals(DBPDataSource dataSource, String wordPart, boolean exec) throws DBException {
        DBSStructureAssistant structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)dataSource);
        DBSObjectContainer sc = (DBSObjectContainer)dataSource;
        DBSObject selectedObject = DBUtils.getActiveInstanceObject((DBCExecutionContext)this.request.getContext().getExecutionContext());
        if (selectedObject instanceof DBSObjectContainer && (!this.request.getContext().isSearchGlobally() || this.request.getWordDetector().containsSeparator(wordPart))) {
            sc = (DBSObjectContainer)selectedObject;
        }
        if (structureAssistant != null) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("exec", exec);
            this.makeProposalsFromAssistant(structureAssistant, sc, new DBSObjectType[]{RelationalObjectType.TYPE_PROCEDURE}, wordPart, params);
        }
    }

    private void makeProposalsFromAttributeValues(DBPDataSource dataSource, SQLWordPartDetector wordDetector, boolean isInLiteral, DBSEntity entity) throws DBException {
        List<String> prevWords = wordDetector.getPrevWords();
        if (!prevWords.isEmpty()) {
            DBSEntityAttribute attribute;
            int divPos;
            String columnName = prevWords.get(prevWords.size() - 1);
            if (!DBUtils.isQuotedIdentifier((DBPDataSource)dataSource, (String)columnName) && (divPos = columnName.indexOf(this.request.getContext().getSyntaxManager().getStructSeparator())) != -1) {
                columnName = columnName.substring(divPos + 1);
            }
            if ((attribute = entity.getAttribute(this.monitor, columnName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)columnName))) != null) {
                Throwable throwable = null;
                Object var9_11 = null;
                try (DBCSession session = this.request.getContext().getExecutionContext().openSession(this.monitor, DBCExecutionPurpose.META, "Read attribute values");){
                    DBSEntityAttribute refAttribute;
                    DBSEntity dictEntity;
                    List valueEnumeration = null;
                    DBSEntityReferrer enumConstraint = DBStructUtils.getEnumerableConstraint((DBRProgressMonitor)this.monitor, (DBSEntityAttribute)attribute);
                    if (enumConstraint instanceof DBSEntityAssociation && (dictEntity = DBStructUtils.getAssociatedEntity((DBRProgressMonitor)this.monitor, (DBSEntityConstraint)enumConstraint)) != null && (refAttribute = DBUtils.getReferenceAttribute((DBRProgressMonitor)this.monitor, (DBSEntityAssociation)((DBSEntityAssociation)enumConstraint), (DBSEntityAttribute)attribute, (boolean)false)) != null) {
                        valueEnumeration = ((DBSDictionary)dictEntity).getDictionaryEnumeration(this.monitor, refAttribute, null, Collections.emptyList(), true, true, 50);
                    }
                    if (CommonUtils.isEmpty(valueEnumeration) && attribute instanceof DBSAttributeEnumerable) {
                        valueEnumeration = ((DBSAttributeEnumerable)attribute).getValueEnumeration(session, (Object)(isInLiteral ? wordDetector.getFullWord() : null), 50, false, false);
                    }
                    if (!CommonUtils.isEmpty(valueEnumeration)) {
                        valueEnumeration.sort((o1, o2) -> DBUtils.compareDataValues((Object)o1.getValue(), (Object)o2.getValue()));
                        DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)attribute);
                        DBPImage attrImage = null;
                        for (DBDLabelValuePair valuePair : valueEnumeration) {
                            String displayString = SQLUtils.convertValueToSQL((DBPDataSource)session.getDataSource(), (DBSAttributeBase)attribute, (DBDValueHandler)valueHandler, (Object)valuePair.getValue(), (DBDDisplayFormat)DBDDisplayFormat.UI);
                            if (!CommonUtils.isEmpty((String)valuePair.getLabel()) && !CommonUtils.equalObjects((Object)valuePair.getLabel(), (Object)valuePair.getValue())) {
                                displayString = String.valueOf(displayString) + " - " + valuePair.getLabel();
                            }
                            String sqlValue = isInLiteral ? valueHandler.getValueDisplayString((DBSTypedObject)attribute, valuePair.getValue(), DBDDisplayFormat.NATIVE) : SQLUtils.convertValueToSQL((DBPDataSource)dataSource.getDataSource(), (DBSAttributeBase)attribute, (DBDValueHandler)valueHandler, (Object)valuePair.getValue(), (DBDDisplayFormat)DBDDisplayFormat.NATIVE);
                            this.proposals.add(this.request.getContext().createProposal(this.request, displayString, sqlValue, sqlValue.length(), attrImage, DBPKeywordType.LITERAL, null, null, Collections.emptyMap()));
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void filterProposals(DBPDataSource dataSource) {
        boolean hideDups;
        HashSet<String> proposalMap = new HashSet<String>(this.proposals.size());
        int i = 0;
        while (i < this.proposals.size()) {
            SQLCompletionProposalBase proposal = this.proposals.get(i);
            if (proposalMap.contains(proposal.getDisplayString())) {
                this.proposals.remove(i);
                continue;
            }
            proposalMap.add(proposal.getDisplayString());
            ++i;
        }
        DBSInstance defaultInstance = dataSource == null ? null : dataSource.getDefaultInstance();
        DBCExecutionContext executionContext = this.request.getContext().getExecutionContext();
        DBSObject selectedObject = defaultInstance == null || executionContext == null ? null : DBUtils.getActiveInstanceObject((DBCExecutionContext)executionContext);
        boolean bl = hideDups = this.request.getContext().isHideDuplicates() && selectedObject != null;
        if (hideDups) {
            int i2 = 0;
            while (i2 < this.proposals.size()) {
                SQLCompletionProposalBase proposal = this.proposals.get(i2);
                int n = 0;
                while (n < this.proposals.size()) {
                    SQLCompletionProposalBase proposal2 = this.proposals.get(n);
                    if (i2 != n && proposal.hasStructObject() && proposal2.hasStructObject() && CommonUtils.equalObjects((Object)proposal.getObject().getName(), (Object)proposal2.getObject().getName()) && proposal.getObjectContainer() == selectedObject) {
                        this.proposals.remove(n);
                        continue;
                    }
                    ++n;
                }
                ++i2;
            }
        }
        if (hideDups) {
            boolean cfr_ignored_0 = selectedObject instanceof DBSObjectContainer;
        }
        if (dataSource != null) {
            DBPDataSourceContainer dsContainer = dataSource.getContainer();
            HashMap<DBSObject, Map> containerMap = new HashMap<DBSObject, Map>();
            for (SQLCompletionProposalBase sQLCompletionProposalBase : this.proposals) {
                DBSObject container = sQLCompletionProposalBase.getObjectContainer();
                DBPNamedObject object = sQLCompletionProposalBase.getObject();
                if (object == null) continue;
                Map typeMap = containerMap.computeIfAbsent(container, k -> new HashMap());
                Class objectType = object instanceof DBSObjectReference ? ((DBSObjectReference)object).getObjectClass() : object.getClass();
                List list = typeMap.computeIfAbsent(objectType, k -> new ArrayList());
                list.add(sQLCompletionProposalBase);
            }
            for (Map.Entry entry : containerMap.entrySet()) {
                for (Map.Entry typeEntry : ((Map)entry.getValue()).entrySet()) {
                    DBSObjectFilter filter = dsContainer.getObjectFilter((Class)typeEntry.getKey(), (DBSObject)entry.getKey(), true);
                    if (filter == null || !filter.isEnabled()) continue;
                    for (SQLCompletionProposalBase proposal : (List)typeEntry.getValue()) {
                        if (filter.matches(proposal.getObject().getName())) continue;
                        this.proposals.remove(proposal);
                    }
                }
            }
        }
    }

    private void makeProposalsFromQueryParts() {
        String wordPart = this.request.getWordPart();
        SQLScriptElement activeQuery = this.request.getActiveQuery();
        if (activeQuery != null && !CommonUtils.isEmpty((String)activeQuery.getText()) && !CommonUtils.isEmpty((String)wordPart)) {
            if (wordPart.indexOf(this.request.getContext().getSyntaxManager().getStructSeparator()) != -1 || wordPart.equals(ALL_COLUMNS_PATTERN)) {
                return;
            }
            SQLDialect sqlDialect = this.request.getContext().getDataSource().getSQLDialect();
            String tableNamePattern = SQLCompletionAnalyzer.getTableNamePattern(sqlDialect);
            String tableAliasPattern = this.getTableAliasPattern("(" + wordPart + "[a-z]*)", tableNamePattern);
            Pattern rp = Pattern.compile(tableAliasPattern);
            Matcher matcher = rp.matcher(String.valueOf(this.request.getActiveQuery().getText()) + " ");
            while (matcher.find()) {
                String tableName = matcher.group(1);
                String tableAlias = matcher.group(2);
                if (tableAlias.equals(wordPart)) continue;
                if (!SQLCompletionAnalyzer.hasProposal(this.proposals, tableName)) {
                    this.proposals.add(0, SQLCompletionAnalyzer.createCompletionProposal(this.request, tableName, tableName, DBPKeywordType.OTHER, null, false, null, Collections.emptyMap()));
                }
                if (CommonUtils.isEmpty((String)tableAlias) || SQLCompletionAnalyzer.hasProposal(this.proposals, tableAlias)) continue;
                this.proposals.add(0, SQLCompletionAnalyzer.createCompletionProposal(this.request, tableAlias, tableAlias, DBPKeywordType.OTHER, null, false, null, Collections.emptyMap()));
            }
        }
    }

    private static boolean hasProposal(List<SQLCompletionProposalBase> proposals, String displayName) {
        for (SQLCompletionProposalBase proposal : proposals) {
            if (!displayName.equals(proposal.getDisplayString())) continue;
            return true;
        }
        return false;
    }

    private boolean makeJoinColumnProposals(DBSObjectContainer sc, DBSEntity leftTable) {
        SQLWordPartDetector joinTableDetector = new SQLWordPartDetector(this.request.getDocument(), this.request.getContext().getSyntaxManager(), this.request.getWordDetector().getStartOffset(), 2);
        List<String> prevWords = joinTableDetector.getPrevWords();
        if (!CommonUtils.isEmpty(prevWords)) {
            DBPDataSource dataSource = this.request.getContext().getDataSource();
            SQLDialect sqlDialect = dataSource.getSQLDialect();
            String rightTableName = prevWords.get(0);
            String[] allNames = SQLUtils.splitFullIdentifier((String)rightTableName, (String)sqlDialect.getCatalogSeparator(), (String[][])sqlDialect.getIdentifierQuoteStrings(), (boolean)false);
            DBSObject rightTable = SQLSearchUtils.findObjectByFQN(this.monitor, sc, this.request.getContext().getExecutionContext(), Arrays.asList(allNames), !this.request.isSimpleMode(), this.request.getWordDetector());
            if (rightTable instanceof DBSEntity) {
                try {
                    String joinCriteria = SQLUtils.generateTableJoin((DBRProgressMonitor)this.monitor, (DBSEntity)leftTable, (String)DBUtils.getQuotedIdentifier((DBSObject)leftTable), (DBSEntity)((DBSEntity)rightTable), (String)DBUtils.getQuotedIdentifier((DBSObject)rightTable));
                    this.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, joinCriteria, joinCriteria, DBPKeywordType.OTHER, "Join condition"));
                    return true;
                }
                catch (DBException e) {
                    log.error((Object)"Error generating join condition", (Throwable)e);
                }
            }
        }
        return false;
    }

    private void filterNonJoinableProposals(DBSEntity leftTable) {
        ArrayList<SQLCompletionProposalBase> joinableProposals = new ArrayList<SQLCompletionProposalBase>();
        for (SQLCompletionProposalBase proposal : this.proposals) {
            DBSEntity rightTable;
            if (!(proposal.getObject() instanceof DBSEntity) || !this.tableHaveJoins(rightTable = (DBSEntity)proposal.getObject(), leftTable) && !this.tableHaveJoins(leftTable, rightTable)) continue;
            proposal.setReplacementAfter(" ON");
            joinableProposals.add(proposal);
        }
        if (!joinableProposals.isEmpty()) {
            this.proposals.clear();
            this.proposals.addAll(joinableProposals);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tableHaveJoins(DBSEntity table1, DBSEntity table2) {
        try {
            Collection associations = table1.getAssociations(this.monitor);
            if (!CommonUtils.isEmpty((Collection)associations)) {
                for (DBSEntityAssociation fk : associations) {
                    if (fk.getAssociatedEntity() != table2) continue;
                    return true;
                }
            }
            return false;
        }
        catch (DBException e) {
            log.error((Object)e);
            return false;
        }
    }

    private void makeDataSourceProposals() throws DBException {
        Object sc;
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        DBSObjectContainer rootContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
        if (rootContainer == null) {
            return;
        }
        DBCExecutionContext executionContext = this.request.getContext().getExecutionContext();
        if (executionContext == null) {
            return;
        }
        DBSObjectContainer childObject = sc = rootContainer;
        String[] tokens = this.request.getWordDetector().splitWordPart();
        DBSObject[] selectedObjects = DBUtils.getSelectedObjects((DBRProgressMonitor)this.monitor, (DBCExecutionContext)executionContext);
        DBSObjectContainer[] selectedContainers = new DBSObjectContainer[selectedObjects.length];
        int i = 0;
        while (i < selectedObjects.length) {
            selectedContainers[i] = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)selectedObjects[i]);
            ++i;
        }
        String lastToken = null;
        i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            if (i == tokens.length - 1 && !this.request.getWordDetector().getWordPart().endsWith(".")) {
                lastToken = token;
                break;
            }
            if (sc == null) break;
            String objectName = this.request.getWordDetector().isQuoted(token) ? this.request.getWordDetector().removeQuotes(token) : DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)token);
            DBSObject dBSObject = childObject = objectName == null ? null : sc.getChild(this.monitor, objectName);
            if (childObject == null && i == 0 && objectName != null) {
                DBSObjectContainer[] dBSObjectContainerArray = selectedContainers;
                int n = selectedContainers.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSObjectContainer selectedContainer = dBSObjectContainerArray[n2];
                    if (selectedContainer != null && (childObject = selectedContainer.getChild(this.monitor, objectName)) != null) {
                        sc = selectedContainer;
                        break;
                    }
                    ++n2;
                }
            }
            if (childObject == null) {
                if (i == 0) {
                    List references;
                    DBSStructureAssistant structureAssistant;
                    childObject = this.getTableFromAlias((DBSObjectContainer)sc, token, false);
                    if (childObject == null && !this.request.isSimpleMode() && (structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)sc)) != null && !(references = structureAssistant.findObjectsByMask(this.monitor, executionContext, null, structureAssistant.getAutoCompleteObjectTypes(), this.request.getWordDetector().removeQuotes(token), this.request.getWordDetector().isQuoted(token), false, 2)).isEmpty()) {
                        childObject = ((DBSObjectReference)references.iterator().next()).resolveObject(this.monitor);
                    }
                } else {
                    return;
                }
            }
            sc = childObject instanceof DBSObjectContainer ? childObject : null;
            ++i;
        }
        if (childObject == null) {
            return;
        }
        if (lastToken == null) {
            this.makeProposalsFromChildren((DBPObject)childObject, null, false, Collections.emptyMap());
        } else {
            this.makeProposalsFromChildren((DBPObject)childObject, lastToken, false, Collections.emptyMap());
            int cfr_ignored_0 = tokens.length;
            if (tokens.length == 1) {
                DBSObjectContainer[] dBSObjectContainerArray = selectedContainers;
                int n = selectedContainers.length;
                int token = 0;
                while (token < n) {
                    DBSObjectContainer selectedContainer = dBSObjectContainerArray[token];
                    if (selectedContainer != null && selectedContainer != childObject) {
                        this.makeProposalsFromChildren((DBPObject)selectedContainer, lastToken, true, Collections.emptyMap());
                    }
                    ++token;
                }
                if (this.proposals.isEmpty() && !this.request.isSimpleMode()) {
                    DBSStructureAssistant structureAssistant = null;
                    DBSObjectContainer object = childObject;
                    while (object != null) {
                        structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)object);
                        if (structureAssistant != null) break;
                        object = object.getParentObject();
                    }
                    if (structureAssistant != null) {
                        this.makeProposalsFromAssistant(structureAssistant, (DBSObjectContainer)sc, null, lastToken, Collections.emptyMap());
                    }
                }
            }
        }
    }

    @Nullable
    private DBSObject getTableFromAlias(DBSObjectContainer sc, @Nullable String token, boolean firstMatch) {
        Pattern aliasPattern;
        String structNamePattern;
        if (token == null) {
            token = "";
        } else if (token.equals(ALL_COLUMNS_PATTERN)) {
            return null;
        }
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        if (dataSource == null) {
            return null;
        }
        SQLScriptElement activeQuery = this.request.getActiveQuery();
        if (activeQuery == null) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        SQLDialect sqlDialect = dataSource.getSQLDialect();
        String catalogSeparator = sqlDialect.getCatalogSeparator();
        while (token.endsWith(catalogSeparator)) {
            token = token.substring(0, token.length() - 1);
        }
        String tableNamePattern = SQLCompletionAnalyzer.getTableNamePattern(sqlDialect);
        if (CommonUtils.isEmpty((String)token)) {
            String kwList = "from|update|join|into";
            if (this.request.getQueryType() != SQLCompletionRequest.QueryType.COLUMN) {
                kwList = String.valueOf(kwList) + "|,";
            }
            structNamePattern = "(?:" + kwList + ")\\s+" + tableNamePattern;
        } else {
            structNamePattern = this.getTableAliasPattern(token, tableNamePattern);
        }
        try {
            aliasPattern = Pattern.compile(structNamePattern, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
        String testQuery = String.valueOf(SQLUtils.stripComments((SQLDialect)this.request.getContext().getSyntaxManager().getDialect(), (String)activeQuery.getText())) + " ";
        Matcher matcher = aliasPattern.matcher(testQuery);
        while (matcher.find()) {
            if (!nameList.isEmpty() && (firstMatch || matcher.start() > this.request.getDocumentOffset() - activeQuery.getOffset())) break;
            nameList.clear();
            int groupCount = matcher.groupCount();
            int i = 1;
            while (i <= groupCount) {
                String group = matcher.group(i);
                if (!CommonUtils.isEmpty((String)group)) {
                    String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
                    String[] allNames = SQLUtils.splitFullIdentifier((String)group, (String)catalogSeparator, (String[][])quoteStrings, (boolean)false);
                    Collections.addAll(nameList, allNames);
                }
                ++i;
            }
        }
        return SQLSearchUtils.findObjectByFQN(this.monitor, sc, this.request.getContext().getExecutionContext(), nameList, !this.request.isSimpleMode(), this.request.getWordDetector());
    }

    private String getTableAliasPattern(String alias, String tableNamePattern) {
        return String.valueOf(tableNamePattern) + "\\s+(?:as\\s)?" + alias + "[\\s,]+";
    }

    private static String getTableNamePattern(SQLDialect sqlDialect) {
        String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
        StringBuilder quotes = new StringBuilder();
        if (quoteStrings != null) {
            String[][] stringArray = quoteStrings;
            int n = quoteStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] quotePair = stringArray[n2];
                if (quotes.indexOf(quotePair[0]) == -1) {
                    quotes.append('\\').append(quotePair[0]);
                }
                if (quotes.indexOf(quotePair[1]) == -1) {
                    quotes.append('\\').append(quotePair[1]);
                }
                ++n2;
            }
        }
        return "([\\p{L}0-9_$\u00a7#@\\.\\-" + quotes.toString() + "]+)";
    }

    private void makeProposalsFromChildren(DBPObject parent, @Nullable String startPart, boolean addFirst, Map<String, Object> params) throws DBException {
        int divPos;
        if (this.request.getQueryType() == SQLCompletionRequest.QueryType.EXEC) {
            return;
        }
        if (parent instanceof DBSAlias) {
            DBSObject realParent = ((DBSAlias)parent).getTargetObject(this.monitor);
            if (realParent == null) {
                log.debug((Object)"Can't get synonym target object");
            } else {
                parent = realParent;
            }
        }
        SQLWordPartDetector wordDetector = this.request.getWordDetector();
        if (startPart != null && (divPos = (startPart = wordDetector.removeQuotes(startPart).toUpperCase(Locale.ENGLISH)).lastIndexOf(this.request.getContext().getSyntaxManager().getStructSeparator())) != -1) {
            startPart = startPart.substring(divPos + 1);
        }
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        Collection children = null;
        if (parent instanceof DBSObjectContainer) {
            children = ((DBSObjectContainer)parent).getChildren(this.monitor);
        } else if (parent instanceof DBSEntity) {
            children = ((DBSEntity)parent).getAttributes(this.monitor);
        }
        if (children != null && !children.isEmpty()) {
            String prevWord;
            ArrayList<DBSObject> matchedObjects = new ArrayList<DBSObject>();
            HashMap<String, Integer> scoredMatches = new HashMap<String, Integer>();
            boolean simpleMode = this.request.isSimpleMode();
            boolean allObjects = !simpleMode && ALL_COLUMNS_PATTERN.equals(startPart);
            String objPrefix = null;
            if (allObjects && !CommonUtils.isEmpty(wordDetector.getPrevWords()) && (prevWord = wordDetector.getPrevWords().get(0)).length() > 0 && prevWord.charAt(prevWord.length() - 1) == this.request.getContext().getSyntaxManager().getStructSeparator()) {
                objPrefix = prevWord;
            }
            StringBuilder combinedMatch = new StringBuilder();
            for (DBSObject child : children) {
                int score;
                if (DBUtils.isHiddenObject((Object)child)) continue;
                if (DBUtils.isVirtualObject((Object)child)) {
                    this.makeProposalsFromChildren((DBPObject)child, startPart, addFirst, Collections.emptyMap());
                    continue;
                }
                if (allObjects) {
                    if (combinedMatch.length() > 0) {
                        combinedMatch.append(", ");
                        if (objPrefix != null) {
                            combinedMatch.append(objPrefix);
                        }
                    }
                    combinedMatch.append(DBUtils.getQuotedIdentifier((DBSObject)child));
                    continue;
                }
                if (dataSource != null && !this.request.getContext().isSearchInsideNames()) {
                    if (!CommonUtils.isEmpty((String)startPart) && !CommonUtils.startsWithIgnoreCase((String)child.getName(), (String)startPart)) continue;
                    matchedObjects.add(child);
                    continue;
                }
                int n = score = CommonUtils.isEmpty((String)startPart) ? 1 : TextUtils.fuzzyScore(child.getName(), startPart);
                if (score <= 0) continue;
                matchedObjects.add(child);
                scoredMatches.put(child.getName(), score);
            }
            if (combinedMatch.length() > 0) {
                String replaceString = combinedMatch.toString();
                this.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, replaceString, replaceString, DBPKeywordType.OTHER, "All objects"));
            } else if (!matchedObjects.isEmpty()) {
                if (startPart == null || scoredMatches.isEmpty()) {
                    if (dataSource != null && this.request.getContext().isSortAlphabetically()) {
                        matchedObjects.sort(DBUtils.nameComparatorIgnoreCase());
                    }
                } else {
                    matchedObjects.sort((o1, o2) -> {
                        int score2;
                        int score1 = (Integer)scoredMatches.get(o1.getName());
                        if (score1 == (score2 = ((Integer)scoredMatches.get(o2.getName())).intValue())) {
                            if (o1 instanceof DBSAttributeBase) {
                                return ((DBSAttributeBase)o1).getOrdinalPosition() - ((DBSAttributeBase)o2).getOrdinalPosition();
                            }
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                        return score2 - score1;
                    });
                }
                ArrayList<SQLCompletionProposalBase> childProposals = new ArrayList<SQLCompletionProposalBase>(matchedObjects.size());
                for (DBSObject child : matchedObjects) {
                    SQLCompletionProposalBase proposal = this.makeProposalsFromObject(child, !(parent instanceof DBPDataSource), params);
                    if (!scoredMatches.isEmpty()) {
                        int proposalScore = (Integer)scoredMatches.get(child.getName());
                        proposal.setProposalScore(proposalScore);
                    }
                    childProposals.add(proposal);
                }
                if (addFirst) {
                    this.proposals.addAll(0, childProposals);
                } else {
                    this.proposals.addAll(childProposals);
                }
            }
        }
    }

    private void makeProposalsFromAssistant(DBSStructureAssistant assistant, @Nullable DBSObjectContainer rootSC, DBSObjectType[] objectTypes, String objectName, @NotNull Map<String, Object> params) throws DBException {
        List references = assistant.findObjectsByMask(this.monitor, this.request.getContext().getExecutionContext(), (DBSObject)rootSC, objectTypes == null ? assistant.getAutoCompleteObjectTypes() : objectTypes, this.makeObjectNameMask(objectName, rootSC), this.request.getWordDetector().isQuoted(objectName), this.request.getContext().isSearchGlobally(), 100);
        for (DBSObjectReference reference : references) {
            this.proposals.add(this.makeProposalsFromObject((DBPNamedObject)reference, !(rootSC instanceof DBPDataSource), reference.getObjectType().getImage(), params));
        }
    }

    private String makeObjectNameMask(String objectName, @Nullable DBSObjectContainer rootSC) {
        SQLWordPartDetector wordDetector = this.request.getWordDetector();
        if (wordDetector.containsSeparator(objectName)) {
            String[] strings = wordDetector.splitIdentifier(objectName);
            if (rootSC != null) {
                boolean endsOnStructureSeparator;
                boolean bl = endsOnStructureSeparator = objectName.charAt(objectName.length() - 1) == wordDetector.getStructSeparator();
                if (this.isParentNameInPatternNameArray(strings, rootSC, wordDetector, endsOnStructureSeparator)) {
                    objectName = endsOnStructureSeparator ? "" : wordDetector.removeQuotes(strings[strings.length - 1]);
                }
            }
        } else {
            objectName = wordDetector.removeQuotes(objectName);
        }
        if (this.request.getContext().isSearchInsideNames()) {
            return MATCH_ANY_PATTERN + objectName + MATCH_ANY_PATTERN;
        }
        return String.valueOf(objectName) + MATCH_ANY_PATTERN;
    }

    private boolean isParentNameInPatternNameArray(String[] strings, @NotNull DBSObjectContainer rootSC, SQLWordPartDetector wordDetector, boolean endsOnStructureSeparator) {
        int indexOfParent = endsOnStructureSeparator || strings.length < 2 ? strings.length - 1 : strings.length - 2;
        return rootSC.getName().equals(wordDetector.removeQuotes(strings[indexOfParent]));
    }

    private SQLCompletionProposalBase makeProposalsFromObject(DBSObject object, boolean useShortName, Map<String, Object> params) {
        DBPImage objectIcon;
        DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)this.monitor, (DBSObject)object, (boolean)false);
        DBPImage dBPImage = objectIcon = node == null ? null : node.getNodeIconDefault();
        if (objectIcon == null) {
            objectIcon = DBValueFormatting.getObjectImage((DBPObject)object);
        }
        return this.makeProposalsFromObject((DBPNamedObject)object, useShortName, objectIcon, params);
    }

    private SQLCompletionProposalBase makeProposalsFromObject(DBPNamedObject object, boolean useShortName, @Nullable DBPImage objectIcon, @NotNull Map<String, Object> params) {
        String alias = null;
        SQLTableAliasInsertMode aliasMode = SQLTableAliasInsertMode.NONE;
        String prevWord = this.request.getWordDetector().getPrevKeyWord();
        if ("FROM".equals(prevWord) || "JOIN".equals(prevWord)) {
            SQLDialect dialect;
            if (object instanceof DBSEntity) {
                aliasMode = SQLTableAliasInsertMode.fromPreferences(((DBSEntity)object).getDataSource().getContainer().getPreferenceStore());
            }
            if (aliasMode != SQLTableAliasInsertMode.NONE && (dialect = SQLUtils.getDialectFromObject((DBPObject)object)).supportsAliasInSelect()) {
                String firstKeyword = SQLUtils.getFirstKeyword((SQLDialect)dialect, (String)this.request.getActiveQuery().getText());
                if (dialect.supportsAliasInUpdate() || !ArrayUtils.contains((Object[])dialect.getDMLKeywords(), (Object)firstKeyword.toUpperCase(Locale.ENGLISH))) {
                    SQLDialect sqlDialect;
                    Statement sqlStatement;
                    String queryText = this.request.getActiveQuery().getText();
                    final LinkedHashSet aliases = new LinkedHashSet();
                    if (this.request.getActiveQuery() instanceof SQLQuery && (sqlStatement = ((SQLQuery)this.request.getActiveQuery()).getStatement()) != null) {
                        TablesNamesFinder namesFinder = new TablesNamesFinder(){

                            public void visit(Table table) {
                                if (table != null && table.getAlias() != null && table.getAlias().getName() != null) {
                                    aliases.add(table.getAlias().getName().toLowerCase(Locale.ENGLISH));
                                }
                            }
                        };
                        sqlStatement.accept((StatementVisitor)namesFinder);
                    }
                    if ((alias = SQLUtils.generateEntityAlias((DBSEntity)((DBSEntity)object), arg_0 -> SQLCompletionAnalyzer.lambda$5(aliases, sqlDialect = SQLUtils.getDialectFromObject((DBPObject)object), queryText, arg_0))).equalsIgnoreCase(object.getName())) {
                        alias = "";
                    }
                }
            }
        }
        String objectName = useShortName ? object.getName() : DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DML);
        boolean isSingleObject = true;
        String replaceString = null;
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        if (dataSource != null) {
            DBSObject selectedObject;
            DBSObjectReference structObject;
            if (!this.request.getContext().isUseShortNames() && object instanceof DBSObjectReference && this.request.getWordDetector().getFullWord().indexOf(this.request.getContext().getSyntaxManager().getStructSeparator()) == -1 && (structObject = (DBSObjectReference)object).getContainer() != null && (selectedObject = DBUtils.getActiveInstanceObject((DBCExecutionContext)this.request.getContext().getExecutionContext())) != structObject.getContainer()) {
                replaceString = structObject.getFullyQualifiedName(DBPEvaluationContext.DML);
                isSingleObject = false;
            }
            if (replaceString == null) {
                replaceString = this.request.getContext().isUseFQNames() && object instanceof DBPQualifiedObject ? ((DBPQualifiedObject)object).getFullyQualifiedName(DBPEvaluationContext.DML) : DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)object.getName());
            }
        } else {
            replaceString = DBUtils.getObjectShortName((Object)object);
        }
        if (!CommonUtils.isEmpty(alias)) {
            if (aliasMode == SQLTableAliasInsertMode.EXTENDED) {
                replaceString = String.valueOf(replaceString) + " " + SQLCompletionAnalyzer.convertKeywordCase(this.request, "as", false);
            }
            replaceString = String.valueOf(replaceString) + " " + alias;
        }
        return SQLCompletionAnalyzer.createCompletionProposal(this.request, replaceString, objectName, DBPKeywordType.OTHER, objectIcon, isSingleObject, object, params);
    }

    static SQLCompletionProposalBase createCompletionProposal(SQLCompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, @Nullable DBPImage image, boolean isObject, @Nullable DBPNamedObject object, @NotNull Map<String, Object> params) {
        int cursorPos;
        boolean quotedString;
        DBPDataSource dataSource = request.getContext().getDataSource();
        if (dataSource != null) {
            // empty if block
        }
        if (!(quotedString = request.getWordDetector().isQuoted(replaceString))) {
            replaceString = SQLCompletionAnalyzer.convertKeywordCase(request, replaceString, isObject);
        }
        if (proposalType == DBPKeywordType.FUNCTION) {
            replaceString = String.valueOf(replaceString) + "()";
            cursorPos = replaceString.length() - 2;
        } else {
            cursorPos = replaceString.length();
        }
        return request.getContext().createProposal(request, displayString, replaceString, cursorPos, image, proposalType, null, object, params);
    }

    private static String convertKeywordCase(SQLCompletionRequest request, String replaceString, boolean isObject) {
        int proposalCase = request.getContext().getInsertCase();
        switch (proposalCase) {
            case 1: {
                replaceString = replaceString.toUpperCase();
                break;
            }
            case 2: {
                replaceString = replaceString.toLowerCase();
                break;
            }
            default: {
                if (isObject) break;
                SQLDialect dialect = request.getContext().getSyntaxManager().getDialect();
                DBPKeywordType keywordType = dialect.getKeywordType(replaceString);
                replaceString = keywordType == DBPKeywordType.KEYWORD ? request.getContext().getSyntaxManager().getKeywordCase().transform(replaceString) : dialect.storesUnquotedCase().transform(replaceString);
            }
        }
        return replaceString;
    }

    protected static SQLCompletionProposalBase createCompletionProposal(SQLCompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, String description) {
        return request.getContext().createProposal(request, displayString, replaceString, replaceString.length(), null, proposalType, description, null, Collections.emptyMap());
    }

    private /* synthetic */ int lambda$0(String o) {
        return TextUtils.fuzzyScore(o, this.request.getWordPart());
    }

    private static /* synthetic */ Boolean lambda$5(Set set, SQLDialect sQLDialect, String string, String s) {
        if (set.contains(s) || sQLDialect.getKeywordType(s) != null) {
            return true;
        }
        return Pattern.compile("\\s+" + s + "[^\\w]+").matcher(string).find();
    }
}

