/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.edit;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandAggregator;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandFilter;
import org.jkiss.dbeaver.model.edit.DBECommandListener;
import org.jkiss.dbeaver.model.edit.DBECommandQueue;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBECommandRename;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractCommandContext
implements DBECommandContext {
    private static final Log log = Log.getLog(AbstractCommandContext.class);
    private final DBCExecutionContext executionContext;
    private final List<CommandInfo> commands = new ArrayList<CommandInfo>();
    private final List<CommandInfo> undidCommands = new ArrayList<CommandInfo>();
    private List<CommandQueue> commandQueues;
    private final Map<Object, Object> userParams = new HashMap<Object, Object>();
    private final List<DBECommandListener> listeners = new ArrayList<DBECommandListener>();
    private final boolean atomic;

    public AbstractCommandContext(DBCExecutionContext executionContext, boolean atomic) {
        this.executionContext = executionContext;
        this.atomic = atomic;
    }

    @Override
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDirty() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            CommandQueue queue;
            Iterator<CommandQueue> iterator = this.getCommandQueues().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((queue = iterator.next()).isEmpty());
            return true;
        }
    }

    @Override
    public void saveChanges(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (!this.executionContext.isConnected()) {
            this.executionContext.invalidateContext(monitor, false);
            if (!this.executionContext.isConnected()) {
                throw new DBException("Context [" + this.executionContext.getContextName() + "] isn't connected to the database");
            }
        }
        DBCTransactionManager txnManager = DBUtils.getTransactionManager(this.executionContext);
        boolean useAutoCommit = false;
        HashMap<String, Object> validateOptions = new HashMap<String, Object>();
        for (CommandQueue queue : this.getCommandQueues()) {
            for (CommandInfo cmd : queue.commands) {
                cmd.command.validateCommand(monitor, validateOptions);
            }
        }
        useAutoCommit = CommonUtils.getOption(validateOptions, (String)"avoidTransactions");
        boolean oldAutoCommit = false;
        if (txnManager != null && txnManager.isSupportsTransactions() && (oldAutoCommit = txnManager.isAutoCommit()) != useAutoCommit) {
            try {
                txnManager.setAutoCommit(monitor, useAutoCommit);
            }
            catch (DBCException e) {
                log.warn("Can't switch to transaction mode", e);
            }
        }
        try {
            try {
                this.executeCommands(monitor, options, useAutoCommit ? null : txnManager);
                this.clearCommandQueues();
            }
            catch (Throwable e) {
                if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
                    try {
                        Object object = null;
                        Object var8_12 = null;
                        try (DBCSession session = this.executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Rollback script transaction");){
                            session.enableLogging(false);
                            txnManager.rollback(session, null);
                        }
                        catch (Throwable throwable) {
                            if (object == null) {
                                object = throwable;
                            } else if (object != throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            throw object;
                        }
                    }
                    catch (DBCException dBCException) {
                        log.warn("Can't rollback transaction after error", e);
                    }
                }
                throw e;
            }
        }
        finally {
            if (txnManager != null && txnManager.isSupportsTransactions()) {
                try {
                    Throwable e = null;
                    Object var12_24 = null;
                    try (DBCSession session = this.executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Commit script transaction");){
                        session.enableLogging(false);
                        txnManager.commit(session);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                    if (oldAutoCommit != useAutoCommit) {
                        txnManager.setAutoCommit(monitor, oldAutoCommit);
                    }
                }
                catch (DBCException e) {
                    log.warn("Can't commit changes", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommands(DBRProgressMonitor monitor, Map<String, Object> options, DBCTransactionManager txnManager) throws DBException {
        ArrayList<CommandInfo> executedCommands;
        block42: {
            List<CommandQueue> commandQueues = this.getCommandQueues();
            executedCommands = new ArrayList<CommandInfo>();
            try {
                block16: for (CommandQueue queue : commandQueues) {
                    int i = 0;
                    while (i < queue.commands.size()) {
                        if (monitor.isCanceled()) continue block16;
                        CommandInfo cmd = (CommandInfo)queue.commands.get(i);
                        while (cmd.mergedBy != null) {
                            cmd = cmd.mergedBy;
                        }
                        if (!cmd.executed) {
                            Object[] persistActions = cmd.command.getPersistActions(monitor, this.executionContext, options);
                            if (!ArrayUtils.isEmpty((Object[])persistActions)) {
                                cmd.persistActions = new ArrayList<PersistInfo>(persistActions.length);
                                Object[] objectArray = persistActions;
                                int n = persistActions.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object action = objectArray[n2];
                                    cmd.persistActions.add(new PersistInfo((DBEPersistAction)action));
                                    ++n2;
                                }
                            }
                            if (!CommonUtils.isEmpty(cmd.persistActions)) {
                                Throwable throwable = null;
                                Object var12_14 = null;
                                try (DBCSession session = this.openCommandPersistContext(monitor, cmd.command);){
                                    DBException error = null;
                                    for (PersistInfo persistInfo : cmd.persistActions) {
                                        DBEPersistAction.ActionType actionType = persistInfo.action.getType();
                                        if (actionType == DBEPersistAction.ActionType.COMMENT || persistInfo.executed && actionType == DBEPersistAction.ActionType.NORMAL) continue;
                                        if (monitor.isCanceled()) break;
                                        try {
                                            if (error == null || actionType == DBEPersistAction.ActionType.FINALIZER) {
                                                queue.objectManager.executePersistAction(session, cmd.command, persistInfo.action);
                                            }
                                            persistInfo.executed = true;
                                        }
                                        catch (DBException e) {
                                            persistInfo.error = e;
                                            persistInfo.executed = false;
                                            if (actionType == DBEPersistAction.ActionType.OPTIONAL) continue;
                                            error = e;
                                        }
                                    }
                                    if (error != null) {
                                        throw error;
                                    }
                                    if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
                                        txnManager.commit(session);
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                cmd.executed = true;
                            }
                        }
                        if (cmd.executed) {
                            List<CommandInfo> list = this.commands;
                            synchronized (list) {
                                this.commands.remove(cmd);
                            }
                        }
                        if (!executedCommands.contains(cmd)) {
                            executedCommands.add(cmd);
                        }
                        ++i;
                    }
                }
                this.commands.clear();
                this.userParams.clear();
                break block42;
            }
            catch (Throwable throwable) {
                try {
                    if (this.atomic) {
                        for (CommandInfo cmd : executedCommands) {
                            if (cmd.reflector == null) continue;
                            cmd.reflector.redoCommand(cmd.command);
                        }
                    }
                    for (CommandInfo cmd : executedCommands) {
                        cmd.command.updateModel();
                    }
                }
                catch (Exception e) {
                    log.warn("Error updating model", e);
                }
            }
            this.clearCommandQueues();
            this.clearUndidCommands();
            DBECommandListener[] dBECommandListenerArray = this.getListeners();
            int n = dBECommandListenerArray.length;
            int n3 = 0;
            while (n3 < n) {
                DBECommandListener listener = dBECommandListenerArray[n3];
                listener.onSave();
                ++n3;
            }
            throw throwable;
        }
        try {
            if (this.atomic) {
                for (CommandInfo cmd : executedCommands) {
                    if (cmd.reflector == null) continue;
                    cmd.reflector.redoCommand(cmd.command);
                }
            }
            for (CommandInfo cmd : executedCommands) {
                cmd.command.updateModel();
            }
        }
        catch (Exception e) {
            log.warn("Error updating model", e);
        }
        this.clearCommandQueues();
        this.clearUndidCommands();
        DBECommandListener[] dBECommandListenerArray = this.getListeners();
        int n = dBECommandListenerArray.length;
        int n4 = 0;
        while (n4 < n) {
            DBECommandListener listener = dBECommandListenerArray[n4];
            listener.onSave();
            ++n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void resetChanges(boolean undoCommands) {
        var2_2 = this.commands;
        synchronized (var2_2) {
            try {
                if (undoCommands) {
                    while (!this.commands.isEmpty()) {
                        this.undoCommand();
                    }
                }
                this.clearUndidCommands();
                this.clearCommandQueues();
                this.commands.clear();
                this.userParams.clear();
            }
            finally {
                var7_5 = this.getListeners();
                var6_7 = var7_5.length;
                var5_9 = 0;
                ** while (var5_9 < var6_7)
            }
lbl-1000:
            // 1 sources

            {
                listener = var7_5[var5_9];
                listener.onReset();
                ++var5_9;
                continue;
            }
lbl23:
            // 1 sources

        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends DBECommand<?>> getFinalCommands() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            ArrayList cmdCopy = new ArrayList(this.commands.size());
            for (CommandQueue queue : this.getCommandQueues()) {
                for (CommandInfo cmdInfo : queue.commands) {
                    while (cmdInfo.mergedBy != null) {
                        cmdInfo = cmdInfo.mergedBy;
                    }
                    if (cmdCopy.contains(cmdInfo.command)) continue;
                    cmdCopy.add(cmdInfo.command);
                }
            }
            return cmdCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends DBECommand<?>> getUndoCommands() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            ArrayList result = new ArrayList();
            int i = this.commands.size() - 1;
            while (i >= 0) {
                CommandInfo cmd = this.commands.get(i);
                while (cmd.prevInBatch != null) {
                    cmd = cmd.prevInBatch;
                    --i;
                }
                if (!cmd.command.isUndoable()) break;
                result.add(cmd.command);
                --i;
            }
            return result;
        }
    }

    @Override
    public Collection<DBPObject> getEditedObjects() {
        List<CommandQueue> queues = this.getCommandQueues();
        ArrayList<DBPObject> result = new ArrayList<DBPObject>(queues.size());
        for (CommandQueue queue : queues) {
            result.add(queue.getObject());
        }
        return result;
    }

    @Override
    public void addCommand(DBECommand command, DBECommandReflector reflector) {
        this.addCommand(command, reflector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommand(DBECommand command, DBECommandReflector reflector, boolean execute) {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            this.commands.add(new CommandInfo(command, reflector));
            this.clearUndidCommands();
            this.clearCommandQueues();
        }
        this.fireCommandChange(command);
        if (execute && reflector != null && !this.atomic) {
            reflector.redoCommand(command);
        }
        this.refreshCommandState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommand(DBECommand<?> command) {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            for (CommandInfo cmd : this.commands) {
                if (cmd.command != command) continue;
                this.commands.remove(cmd);
                break;
            }
            this.clearUndidCommands();
            this.clearCommandQueues();
        }
        this.fireCommandChange(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCommand(DBECommand<?> command, DBECommandReflector commandReflector) {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            boolean found = false;
            for (CommandInfo cmd : this.commands) {
                if (cmd.command != command) continue;
                found = true;
                break;
            }
            if (!found) {
                this.addCommand(command, commandReflector);
            } else {
                this.clearUndidCommands();
                this.clearCommandQueues();
            }
        }
        this.fireCommandChange(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommandListener(DBECommandListener listener) {
        List<DBECommandListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommandListener(DBECommandListener listener) {
        List<DBECommandListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public Map<Object, Object> getUserParams() {
        return this.userParams;
    }

    private void fireCommandChange(DBECommand<?> command) {
        DBECommandListener[] dBECommandListenerArray = this.getListeners();
        int n = dBECommandListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBECommandListener listener = dBECommandListenerArray[n2];
            listener.onCommandChange(command);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBECommandListener[] getListeners() {
        List<DBECommandListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new DBECommandListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBECommand getUndoCommand() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            if (!this.commands.isEmpty()) {
                CommandInfo cmd = this.commands.get(this.commands.size() - 1);
                while (cmd.prevInBatch != null) {
                    cmd = cmd.prevInBatch;
                }
                if (cmd.command.isUndoable()) {
                    return cmd.command;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBECommand getRedoCommand() {
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            if (!this.undidCommands.isEmpty()) {
                CommandInfo cmd = this.undidCommands.get(this.undidCommands.size() - 1);
                while (cmd.prevInBatch != null) {
                    cmd = cmd.prevInBatch;
                }
                return cmd.command;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void undoCommand() {
        if (this.getUndoCommand() == null) {
            throw new IllegalStateException("Can't undo command");
        }
        ArrayList<CommandInfo> processedCommands = new ArrayList<CommandInfo>();
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            CommandInfo lastCommand = this.commands.get(this.commands.size() - 1);
            if (!lastCommand.command.isUndoable()) {
                throw new IllegalStateException("Last executed command is not undoable");
            }
            while (true) {
                if (lastCommand == null) {
                    this.clearCommandQueues();
                    this.getCommandQueues();
                    break;
                }
                this.commands.remove(lastCommand);
                this.undidCommands.add(lastCommand);
                processedCommands.add(lastCommand);
                lastCommand = lastCommand.prevInBatch;
            }
        }
        this.refreshCommandState();
        for (CommandInfo cmd : processedCommands) {
            if (cmd.reflector == null || this.atomic) continue;
            cmd.reflector.undoCommand(cmd.command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redoCommand() {
        if (this.getRedoCommand() == null) {
            throw new IllegalStateException("Can't redo command");
        }
        ArrayList<CommandInfo> processedCommands = new ArrayList<CommandInfo>();
        List<CommandInfo> list = this.commands;
        synchronized (list) {
            CommandInfo commandInfo = null;
            while (!(this.undidCommands.isEmpty() || commandInfo != null && this.undidCommands.get((int)(this.undidCommands.size() - 1)).prevInBatch != commandInfo)) {
                commandInfo = this.undidCommands.remove(this.undidCommands.size() - 1);
                this.commands.add(commandInfo);
                processedCommands.add(commandInfo);
            }
            this.clearCommandQueues();
            this.getCommandQueues();
        }
        for (CommandInfo cmd : processedCommands) {
            if (cmd.reflector == null) continue;
            cmd.reflector.redoCommand(cmd.command);
        }
        this.refreshCommandState();
    }

    private void clearUndidCommands() {
        this.undidCommands.clear();
    }

    private List<CommandQueue> getCommandQueues() {
        if (this.commandQueues != null) {
            return this.commandQueues;
        }
        this.commandQueues = new ArrayList<CommandQueue>();
        CommandInfo aggregator = null;
        for (CommandInfo commandInfo : this.commands) {
            if (commandInfo.command instanceof DBECommandAggregator) {
                aggregator = commandInfo;
            }
            Object object = commandInfo.command.getObject();
            CommandQueue queue = null;
            if (!this.commandQueues.isEmpty()) {
                for (CommandQueue tmpQueue : this.commandQueues) {
                    if (tmpQueue.getObject() != object) continue;
                    queue = tmpQueue;
                    break;
                }
            }
            if (queue == null) {
                DBEObjectManager<?> objectManager = this.executionContext.getDataSource().getContainer().getPlatform().getEditorsRegistry().getObjectManager(object.getClass());
                if (objectManager == null) {
                    throw new IllegalStateException("Can't find object manager for '" + object.getClass().getName() + "'");
                }
                queue = new CommandQueue(objectManager, null, (DBPObject)object);
                this.commandQueues.add(queue);
            }
            queue.addCommand(commandInfo);
        }
        for (CommandQueue queue : this.commandQueues) {
            IdentityHashMap mergedByMap = new IdentityHashMap();
            ArrayList mergedCommands = new ArrayList();
            int i = 0;
            while (i < queue.commands.size()) {
                block31: {
                    int k;
                    DBECommand<?> result;
                    CommandInfo firstCommand;
                    CommandInfo lastCommand;
                    block30: {
                        block29: {
                            lastCommand = (CommandInfo)queue.commands.get(i);
                            lastCommand.mergedBy = null;
                            firstCommand = null;
                            result = lastCommand.command;
                            if (!mergedCommands.isEmpty()) break block29;
                            result = lastCommand.command.merge(null, this.userParams);
                            break block30;
                        }
                        boolean skipCommand = false;
                        k = mergedCommands.size();
                        while (k > 0) {
                            firstCommand = (CommandInfo)mergedCommands.get(k - 1);
                            result = lastCommand.command.merge(firstCommand.command, this.userParams);
                            if (result == null) {
                                mergedCommands.remove(firstCommand);
                                skipCommand = true;
                            } else if (result != lastCommand.command) break;
                            --k;
                        }
                        if (skipCommand) break block31;
                    }
                    mergedCommands.add(lastCommand);
                    if (result != lastCommand.command) {
                        if (firstCommand != null && result == firstCommand.command) {
                            lastCommand.mergedBy = firstCommand;
                        } else {
                            CommandInfo mergedBy = (CommandInfo)mergedByMap.get(result);
                            if (mergedBy == null) {
                                k = i;
                                while (k >= 0) {
                                    if (((CommandInfo)((CommandQueue)queue).commands.get((int)k)).command == result) {
                                        mergedBy = (CommandInfo)queue.commands.get(k);
                                        break;
                                    }
                                    --k;
                                }
                                if (mergedBy == null) {
                                    mergedBy = new CommandInfo(result, null);
                                }
                                mergedByMap.put(result, mergedBy);
                            }
                            lastCommand.mergedBy = mergedBy;
                            if (!mergedCommands.contains(mergedBy)) {
                                mergedCommands.add(mergedBy);
                            }
                        }
                    }
                }
                ++i;
            }
            queue.commands = mergedCommands;
        }
        for (CommandQueue queue : this.commandQueues) {
            if (!(queue.objectManager instanceof DBECommandFilter)) continue;
            ((DBECommandFilter)((Object)queue.objectManager)).filterCommands(queue);
        }
        if (aggregator != null) {
            ((DBECommandAggregator)aggregator.command).resetAggregatedCommands();
            for (CommandQueue queue : this.commandQueues) {
                for (CommandInfo cmd : queue.commands) {
                    if (cmd.command == aggregator.command || cmd.mergedBy != null || !((DBECommandAggregator)aggregator.command).aggregateCommand(cmd.command)) continue;
                    cmd.mergedBy = aggregator;
                }
            }
        }
        for (CommandQueue queue : this.commandQueues) {
            int headIndex = 0;
            for (CommandInfo cmd : new ArrayList(queue.commands)) {
                if (cmd.mergedBy != null || !(cmd.command instanceof DBECommandRename)) continue;
                queue.commands.remove(cmd);
                queue.commands.add(headIndex++, cmd);
            }
        }
        return this.commandQueues;
    }

    private void clearCommandQueues() {
        this.commandQueues = null;
    }

    protected DBCSession openCommandPersistContext(DBRProgressMonitor monitor, DBECommand<?> command) throws DBException {
        return this.executionContext.openSession(monitor, DBCExecutionPurpose.META_DDL, String.valueOf(ModelMessages.model_edit_execute_) + command.getTitle());
    }

    protected void refreshCommandState() {
    }

    public static class CommandInfo {
        final DBECommand<?> command;
        final DBECommandReflector<?, DBECommand<?>> reflector;
        List<PersistInfo> persistActions;
        CommandInfo mergedBy = null;
        CommandInfo prevInBatch = null;
        boolean executed = false;

        CommandInfo(DBECommand<?> command, DBECommandReflector<?, DBECommand<?>> reflector) {
            this.command = command;
            this.reflector = reflector;
        }

        public String toString() {
            return String.valueOf(this.command.toString()) + " [executed=" + this.executed + ";merged by: " + this.mergedBy + "]";
        }
    }

    private static class CommandQueue
    extends AbstractCollection<DBECommand<DBPObject>>
    implements DBECommandQueue<DBPObject> {
        private final CommandQueue parent;
        private List<DBECommandQueue> subQueues;
        private final DBPObject object;
        private final DBEObjectManager objectManager;
        private List<CommandInfo> commands = new ArrayList<CommandInfo>();

        private CommandQueue(DBEObjectManager objectManager, CommandQueue parent, DBPObject object) {
            this.parent = parent;
            this.object = object;
            this.objectManager = objectManager;
            if (parent != null) {
                parent.addSubQueue(this);
            }
        }

        void addSubQueue(CommandQueue queue) {
            if (this.subQueues == null) {
                this.subQueues = new ArrayList<DBECommandQueue>();
            }
            this.subQueues.add(queue);
        }

        void addCommand(CommandInfo info) {
            this.commands.add(info);
        }

        @Override
        public DBPObject getObject() {
            return this.object;
        }

        @Override
        public DBECommandQueue getParentQueue() {
            return this.parent;
        }

        @Override
        public Collection<DBECommandQueue> getSubQueues() {
            return this.subQueues;
        }

        @Override
        public boolean add(DBECommand dbeCommand) {
            return this.commands.add(new CommandInfo(dbeCommand, null));
        }

        @Override
        public Iterator<DBECommand<DBPObject>> iterator() {
            return new Iterator<DBECommand<DBPObject>>(){
                private int index = -1;

                @Override
                public boolean hasNext() {
                    return this.index < commands.size() - 1;
                }

                @Override
                public DBECommand<DBPObject> next() {
                    ++this.index;
                    return ((CommandInfo)((CommandQueue)this).commands.get((int)this.index)).command;
                }

                @Override
                public void remove() {
                    commands.remove(this.index);
                }
            };
        }

        @Override
        public int size() {
            return this.commands.size();
        }
    }

    private static class PersistInfo {
        final DBEPersistAction action;
        boolean executed = false;
        Throwable error;

        public PersistInfo(DBEPersistAction action) {
            this.action = action;
        }
    }
}

