/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.session.MySQLSession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.utils.CommonUtils;

public class MySQLSessionManager
implements DBAServerSessionManager<MySQLSession> {
    public static final String PROP_KILL_QUERY = "killQuery";
    public static final String OPTION_HIDE_SLEEPING = "hideSleeping";
    private final MySQLDataSource dataSource;

    public MySQLSessionManager(MySQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Loose catch block
     */
    public Collection<MySQLSession> getSessions(DBCSession session, Map<String, Object> options) throws DBException {
        boolean hideSleeping = CommonUtils.getOption(options, (String)OPTION_HIDE_SLEEPING);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SHOW FULL PROCESSLIST");){
                ArrayList<MySQLSession> arrayList;
                JDBCResultSet dbResult;
                Throwable throwable2;
                block22: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbResult = dbStat.executeQuery();
                    ArrayList<MySQLSession> sessions = new ArrayList<MySQLSession>();
                    while (dbResult.next()) {
                        MySQLSession sessionInfo = new MySQLSession((ResultSet)dbResult);
                        if (hideSleeping && "Sleep".equals(sessionInfo.getCommand())) continue;
                        sessions.add(sessionInfo);
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block22;
                    dbResult.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(DBCSession session, MySQLSession sessionType, Map<String, Object> options) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(Boolean.TRUE.equals(options.get(PROP_KILL_QUERY)) ? "KILL QUERY " + sessionType.getPid() : "KILL CONNECTION " + sessionType.getPid());){
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }
}

