/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;

public class StreamProducerSettings
implements IDataTransferSettings {
    private static final Log log = Log.getLog(StreamProducerSettings.class);
    private Map<String, StreamEntityMapping> entityMapping = new LinkedHashMap<String, StreamEntityMapping>();
    private Map<String, Object> processorProperties;
    private int maxRows;

    public Map<String, Object> getProcessorProperties() {
        return this.processorProperties;
    }

    public void setProcessorProperties(Map<String, Object> processorProperties) {
        this.processorProperties = processorProperties;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DataTransferSettings dataTransferSettings, Map<String, Object> settings) {
        this.setProcessorProperties(dataTransferSettings.getProcessorProperties());
        try {
            for (Map mapping : JSONUtils.getObjectList(settings, (String)"mappings")) {
                StreamEntityMapping em = new StreamEntityMapping(mapping);
                this.entityMapping.put(em.getEntityName(), em);
            }
            runnableContext.run(true, true, monitor -> this.updateMappingsFromStream(monitor, dataTransferSettings));
        }
        catch (Exception e) {
            log.error((Object)"Error loading stream producer settings", (Throwable)e);
        }
    }

    public void updateMappingsFromStream(DBRProgressMonitor monitor, DataTransferSettings dataTransferSettings) {
        for (DataTransferPipe pipe : dataTransferSettings.getDataPipes()) {
            StreamTransferProducer producer = (StreamTransferProducer)pipe.getProducer();
            if (producer.getEntityMapping() == null) continue;
            this.updateProducerSettingsFromStream(monitor, producer, dataTransferSettings);
        }
    }

    public void updateProducerSettingsFromStream(DBRProgressMonitor monitor, @NotNull StreamTransferProducer producer, DataTransferSettings dataTransferSettings) {
        monitor.beginTask("Update data produces settings from import stream", 1);
        Map<String, Object> processorProperties = dataTransferSettings.getProcessorProperties();
        List<StreamDataImporterColumnInfo> columnInfos = null;
        StreamEntityMapping entityMapping = producer.getEntityMapping();
        IDataTransferProcessor importer = dataTransferSettings.getProcessor().getInstance();
        if (importer instanceof IStreamDataImporter) {
            IStreamDataImporter sdi = (IStreamDataImporter)importer;
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (FileInputStream is = new FileInputStream(entityMapping.getInputFile());){
                    sdi.init(new StreamDataImporterSite(this, entityMapping, processorProperties));
                    try {
                        columnInfos = sdi.readColumnsInfo(entityMapping, is);
                        entityMapping.setStreamColumns(columnInfos);
                    }
                    finally {
                        sdi.dispose();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                dataTransferSettings.getState().addError(e);
                log.error((Object)"IO error while reading columns from stream", (Throwable)e);
            }
        }
        monitor.done();
    }

    @Override
    public void saveSettings(Map<String, Object> settings) {
        ArrayList<Map<String, Object>> mappings = new ArrayList<Map<String, Object>>();
        settings.put("mappings", mappings);
        for (StreamEntityMapping emc : this.entityMapping.values()) {
            Map<String, Object> emSettings = emc.saveSettings();
            if (emSettings == null) continue;
            mappings.add(emSettings);
        }
    }

    @Override
    public String getSettingsSummary() {
        return "";
    }
}

