/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerFilterObjectType
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof DatabaseNavigatorView) {
            DatabaseNavigatorTree navigatorTree = ((DatabaseNavigatorView)activePart).getNavigatorTree();
            DatabaseNavigatorTreeFilterObjectType objectType = (DatabaseNavigatorTreeFilterObjectType)CommonUtils.valueOf(DatabaseNavigatorTreeFilterObjectType.class, (String)event.getParameter("type"), (Enum)DatabaseNavigatorTreeFilterObjectType.table);
            if (objectType == navigatorTree.getFilterObjectType()) {
                return null;
            }
            navigatorTree.setFilterObjectType(objectType);
            navigatorTree.getViewer().getControl().setRedraw(false);
            try {
                navigatorTree.getViewer().refresh();
            }
            finally {
                navigatorTree.getViewer().getControl().setRedraw(true);
            }
        }
        ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.navigator.filter.connected"});
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String toolTip;
        String text;
        DatabaseNavigatorTreeFilterObjectType objectType = (DatabaseNavigatorTreeFilterObjectType)CommonUtils.valueOf(DatabaseNavigatorTreeFilterObjectType.class, (String)CommonUtils.toString(parameters.get("type")), (Enum)DatabaseNavigatorTreeFilterObjectType.table);
        DatabaseNavigatorTreeFilterObjectType curObjectType = DatabaseNavigatorTreeFilterObjectType.table;
        IWorkbenchPartSite partSite = UIUtils.getWorkbenchPartSite((IServiceLocator)element.getServiceLocator());
        if (partSite != null && partSite.getPart() instanceof DatabaseNavigatorView) {
            curObjectType = ((DatabaseNavigatorView)partSite.getPart()).getNavigatorTree().getFilterObjectType();
        }
        switch (objectType) {
            case connection: {
                text = "Filter connections";
                toolTip = "Filter connections by name";
                break;
            }
            case container: {
                text = "Filter databases or schemas";
                toolTip = "Filter containers (databases or schemas) by name";
                break;
            }
            case table: {
                text = "Filter tables, procedures";
                toolTip = "Filter objects (tables, procedures, users, etc) by name";
                break;
            }
            default: {
                return;
            }
        }
        element.setText(text);
        element.setTooltip(toolTip);
        element.setChecked(objectType == curObjectType);
    }
}

