/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerCreateFolder
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            String folderName;
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            Object element = structSelection.getFirstElement();
            if (!(element instanceof DBNResource)) {
                return null;
            }
            final DBNResource parentResource = (DBNResource)element;
            Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            EnterNameDialog dialog = new EnterNameDialog(activeShell, UINavigatorMessages.actions_navigator_create_folder_folder_name, null){

                protected Composite createDialogArea(Composite parent) {
                    Composite area = super.createDialogArea(parent);
                    UIUtils.createLabelText((Composite)area, (String)"Container", (String)parentResource.getResourcePath(), (int)2056);
                    return area;
                }
            };
            if (dialog.open() == 0 && !CommonUtils.isEmpty((String)(folderName = dialog.getResult()))) {
                try {
                    parentResource.createNewFolder(folderName);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_create_folder_error_title, NLS.bind((String)UINavigatorMessages.actions_navigator_create_folder_error_message, (Object)folderName), (Throwable)e);
                }
            }
        }
        return null;
    }
}

