/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class ApplicationDescriptor
extends AbstractDescriptor {
    private final String id;
    private final String name;
    private final String description;
    private final String parentId;
    private final String[] umbrellaProductIds;
    private ApplicationDescriptor parent;
    private boolean finalApplication = true;

    ApplicationDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.description = config.getAttribute("description");
        this.parentId = config.getAttribute("parent");
        String umbrella = config.getAttribute("umbrella");
        this.umbrellaProductIds = !CommonUtils.isEmptyTrimmed((String)umbrella) ? umbrella.split(",") : new String[0];
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ApplicationDescriptor getParent() {
        return this.parent;
    }

    void setParent(ApplicationDescriptor parent) {
        this.parent = parent;
        this.parent.finalApplication = false;
    }

    public String[] getUmbrellaProductIds() {
        return this.umbrellaProductIds;
    }

    boolean isFinalApplication() {
        return this.finalApplication;
    }

    String getParentId() {
        return this.parentId;
    }
}

