/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.DB2Constants;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.editors.DB2SourceObject;
import org.jkiss.dbeaver.ext.db2.editors.DB2TableTablespaceListProvider;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.DB2TableCheckConstraint;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKey;
import org.jkiss.dbeaver.ext.db2.model.DB2TablePartition;
import org.jkiss.dbeaver.ext.db2.model.DB2TablePeriod;
import org.jkiss.dbeaver.ext.db2.model.DB2TableReference;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.ext.db2.model.DB2Trigger;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableTriggerCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableAccessMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableCompressionMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableDropRule;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableLockSize;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TablePartitionMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableStatus;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableTemporalType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DB2Table
extends DB2TableBase
implements DBPNamedObject2,
DBPRefreshableObject,
DB2SourceObject,
DBDPseudoAttributeContainer {
    private static final String LINE_SEPARATOR = GeneralUtils.getDefaultLineSeparator();
    private static final String C_PT = "SELECT * FROM SYSCAT.DATAPARTITIONS WHERE TABSCHEMA = ? AND TABNAME = ? ORDER BY SEQNO WITH UR";
    private static final String C_PE = "SELECT * FROM SYSCAT.PERIODS WHERE TABSCHEMA = ? AND TABNAME = ? ORDER BY PERIODNAME WITH UR";
    private DB2TableTriggerCache tableTriggerCache = new DB2TableTriggerCache();
    private DBSObjectCache<DB2Table, DB2TablePartition> partitionCache;
    private DBSObjectCache<DB2Table, DB2TablePeriod> periodCache;
    private DB2TableStatus status;
    private DB2TableType type;
    private Object tablespace;
    private Object indexTablespace;
    private Object longTablespace;
    private String dataCapture;
    private String constChecked;
    private DB2TablePartitionMode partitionMode;
    private Boolean append;
    private DB2TableLockSize lockSize;
    private String volatileMode;
    private DB2TableCompressionMode compression;
    private DB2TableAccessMode accessMode;
    private Boolean mdcClustered;
    private DB2TableDropRule dropRule;
    private DB2TableTemporalType temporalType;
    private Timestamp alterTime;
    private Timestamp invalidateTime;
    private Timestamp lastRegenTime;
    private Timestamp statsTime;
    private Long card;
    private Long nPages;
    private Long fPages;
    private Long overFLow;

    public DB2Table(DBRProgressMonitor monitor, DB2Schema schema, ResultSet dbResult) throws DBException {
        super(monitor, schema, dbResult);
        String lockSizeString;
        this.status = (DB2TableStatus)CommonUtils.valueOf(DB2TableStatus.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
        this.type = (DB2TableType)CommonUtils.valueOf(DB2TableType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE"));
        this.statsTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"STATS_TIME");
        this.dataCapture = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATACAPTURE");
        this.constChecked = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONST_CHECKED");
        this.partitionMode = (DB2TablePartitionMode)CommonUtils.valueOf(DB2TablePartitionMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARTITION_MODE"));
        this.append = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"APPEND_MODE", (String)DB2YesNo.Y.name());
        this.volatileMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VOLATILE");
        this.compression = (DB2TableCompressionMode)CommonUtils.valueOf(DB2TableCompressionMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMPRESSION"));
        this.accessMode = (DB2TableAccessMode)CommonUtils.valueOf(DB2TableAccessMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACCESS_MODE"));
        this.mdcClustered = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"CLUSTERED", (String)DB2YesNo.Y.name());
        this.dropRule = (DB2TableDropRule)CommonUtils.valueOf(DB2TableDropRule.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DROPRULE"));
        this.card = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"CARD");
        this.nPages = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"NPAGES");
        this.fPages = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"FPAGES");
        this.overFLow = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"OVERFLOW");
        this.invalidateTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"INVALIDATE_TIME");
        this.lastRegenTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REGEN_TIME");
        if (((DB2DataSource)this.getDataSource()).isAtLeastV9_5()) {
            this.alterTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"ALTER_TIME");
        }
        if (((DB2DataSource)this.getDataSource()).isAtLeastV10_1()) {
            this.temporalType = (DB2TableTemporalType)CommonUtils.valueOf(DB2TableTemporalType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TEMPORALTYPE"));
        }
        if (CommonUtils.isNotEmpty((String)(lockSizeString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOCKSIZE")))) {
            this.lockSize = (DB2TableLockSize)CommonUtils.valueOf(DB2TableLockSize.class, (String)lockSizeString);
        }
        this.tablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TBSPACE");
        this.indexTablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INDEX_TBSPACE");
        this.longTablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LONG_TBSPACE");
        this.partitionCache = new JDBCObjectSimpleCache(DB2TablePartition.class, C_PT, new Object[]{schema.getName(), this.getName()});
        this.periodCache = new JDBCObjectSimpleCache(DB2TablePeriod.class, C_PE, new Object[]{schema.getName(), this.getName()});
    }

    public DB2Table(DB2Schema schema, String name) {
        super(schema, name, false);
        this.type = DB2TableType.T;
        this.status = DB2TableStatus.N;
    }

    public boolean isView() {
        return false;
    }

    public JDBCStructCache<DB2Schema, DB2Table, DB2TableColumn> getCache() {
        return ((DB2Schema)this.getContainer()).getTableCache();
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((DB2Schema)this.getContainer()).getConstraintCache().clearObjectCache(this);
        ((DB2Schema)this.getContainer()).getAssociationCache().clearObjectCache(this);
        ((DB2Schema)this.getContainer()).getReferenceCache().clearObjectCache(this);
        super.refreshObject(monitor);
        return ((DB2Schema)this.getContainer()).getTableCache().refreshObject(monitor, (DB2Schema)this.getContainer(), this);
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.status.getState();
    }

    @Override
    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return DB2Utils.generateDDLforTable(monitor, LINE_SEPARATOR, (DB2DataSource)this.getDataSource(), this);
    }

    @Association
    public Collection<DB2Trigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.tableTriggerCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<DB2TablePartition> getPartitions(DBRProgressMonitor monitor) throws DBException {
        if (this.partitionCache == null) {
            return null;
        }
        return this.partitionCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<DB2TablePeriod> getPeriods(DBRProgressMonitor monitor) throws DBException {
        if (this.periodCache == null) {
            return null;
        }
        return this.periodCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Override
    @Nullable
    @Association
    public Collection<DB2TableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getConstraintCache().getObjects(monitor, (DB2Schema)this.getContainer(), this);
    }

    public DB2TableUniqueKey getConstraint(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DB2TableUniqueKey)((DB2Schema)this.getContainer()).getConstraintCache().getObject(monitor, (DB2Schema)this.getContainer(), this, ukName);
    }

    @Override
    @Association
    public Collection<DB2TableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getAssociationCache().getObjects(monitor, (DB2Schema)this.getContainer(), this);
    }

    public DBSTableForeignKey getAssociation(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DBSTableForeignKey)((DB2Schema)this.getContainer()).getAssociationCache().getObject(monitor, (DB2Schema)this.getContainer(), this, ukName);
    }

    @Override
    @Association
    public Collection<DB2TableReference> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getReferenceCache().getObjects(monitor, (DB2Schema)this.getContainer(), this);
    }

    public DBSTableForeignKey getReference(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DBSTableForeignKey)((DB2Schema)this.getContainer()).getReferenceCache().getObject(monitor, (DB2Schema)this.getContainer(), this, ukName);
    }

    @Association
    public Collection<DB2TableCheckConstraint> getCheckConstraints(DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getCheckCache().getObjects(monitor, (DB2Schema)this.getContainer(), this);
    }

    public DB2TableCheckConstraint getCheckConstraint(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DB2TableCheckConstraint)((DB2Schema)this.getContainer()).getCheckCache().getObject(monitor, (DB2Schema)this.getContainer(), this, ukName);
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=false, order=3, category="Statistics")
    public Long getCard() {
        return this.card;
    }

    @Property(viewable=true, editable=false, order=4)
    public DB2TableStatus getStatus() {
        return this.status;
    }

    @Property(viewable=true, editable=false, order=5)
    public DB2TableType getType() {
        return this.type;
    }

    @Property(viewable=true, editable=true, order=10, category="Tablespace", listProvider=DB2TableTablespaceListProvider.class)
    public DB2Tablespace getTablespace(DBRProgressMonitor monitor) throws DBException {
        return DB2Tablespace.resolveTablespaceReference(monitor, (DB2DataSource)this.getDataSource(), this.tablespace);
    }

    public void setTablespace(DB2Tablespace tablespace) {
        this.tablespace = tablespace;
    }

    @Property(viewable=false, editable=true, order=11, category="Tablespace", listProvider=DB2TableTablespaceListProvider.class)
    public DB2Tablespace getIndexTablespace(DBRProgressMonitor monitor) throws DBException {
        return DB2Tablespace.resolveTablespaceReference(monitor, (DB2DataSource)this.getDataSource(), this.indexTablespace);
    }

    public void setIndexTablespace(DB2Tablespace indexTablespace) {
        this.indexTablespace = indexTablespace;
    }

    @Property(viewable=false, editable=true, order=12, category="Tablespace", listProvider=DB2TableTablespaceListProvider.class)
    public DB2Tablespace getLongTablespace(DBRProgressMonitor monitor) throws DBException {
        return DB2Tablespace.resolveTablespaceReference(monitor, (DB2DataSource)this.getDataSource(), this.longTablespace);
    }

    public void setLongTablespace(DB2Tablespace longTablespace) {
        this.longTablespace = longTablespace;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Timestamp getStatsTime() {
        return this.statsTime;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getnPages() {
        return this.nPages;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getfPages() {
        return this.fPages;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getOverFLow() {
        return this.overFLow;
    }

    @Property(viewable=false, editable=false, order=100)
    public Boolean getAppend() {
        return this.append;
    }

    @Property(viewable=false, editable=false, order=101)
    public String getVolatileMode() {
        return this.volatileMode;
    }

    @Property(viewable=false, editable=false, order=104)
    public DB2TableLockSize getLockSize() {
        return this.lockSize;
    }

    @Property(viewable=false, editable=false, order=105)
    public DB2TableCompressionMode getCompression() {
        return this.compression;
    }

    @Property(viewable=false, editable=false, order=106)
    public DB2TableAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Property(viewable=false, editable=false, order=107)
    public Boolean getMdcClustered() {
        return this.mdcClustered;
    }

    @Property(viewable=false, editable=false, order=108)
    public DB2TableDropRule getDropRule() {
        return this.dropRule;
    }

    @Property(viewable=false, editable=false, order=109)
    public String getDataCapture() {
        return this.dataCapture;
    }

    @Property(viewable=false, editable=false, order=110)
    public DB2TablePartitionMode getPartitionMode() {
        return this.partitionMode;
    }

    @Property(viewable=false, editable=false, order=111)
    public String getConstChecked() {
        return this.constChecked;
    }

    @Property(viewable=false, editable=false, order=120, category="Temporal")
    public DB2TableTemporalType getTemporalType() {
        return this.temporalType;
    }

    @Property(viewable=false, editable=false, order=101, category="Date & Time")
    public Timestamp getAlterTime() {
        return this.alterTime;
    }

    @Property(viewable=false, editable=false, order=102, category="Date & Time")
    public Timestamp getInvalidateTime() {
        return this.invalidateTime;
    }

    @Property(viewable=false, editable=false, order=103, category="Date & Time")
    public Timestamp getLastRegenTime() {
        return this.lastRegenTime;
    }

    public DBDPseudoAttribute[] getPseudoAttributes() throws DBException {
        if (((DB2DataSource)this.getDataSource()).isAtLeastV9_5()) {
            return new DBDPseudoAttribute[]{DB2Constants.PSEUDO_ATTR_RID_BIT};
        }
        return null;
    }
}

