/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.ERDConstants;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDElement;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDLogicalAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.AssociationPart;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.ext.erd.part.NodePart;
import org.jkiss.dbeaver.ext.erd.part.NotePart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.SharedFonts;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiagramLoader {
    private static final Log log = Log.getLog(DiagramLoader.class);
    private static final String TAG_DIAGRAM = "diagram";
    private static final String TAG_ENTITIES = "entities";
    private static final String TAG_DATA_SOURCE = "data-source";
    private static final String TAG_ENTITY = "entity";
    private static final String TAG_PATH = "path";
    private static final String TAG_RELATIONS = "relations";
    private static final String TAG_RELATION = "relation";
    private static final String TAG_BEND = "bend";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_ALIAS = "alias";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ORDER = "order";
    private static final String ATTR_TRANSPARENT = "transparent";
    private static final String ATTR_COLOR_BG = "color-bg";
    private static final String ATTR_COLOR_FG = "color-fg";
    private static final String ATTR_FONT = "font";
    private static final String ATTR_BORDER_WIDTH = "border-width";
    private static final String ATTR_FQ_NAME = "fq-name";
    private static final String ATTR_REF_NAME = "ref-name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PK_REF = "pk-ref";
    private static final String ATTR_FK_REF = "fk-ref";
    private static final String ATTR_ATTRIBUTE_VISIBILITY = "showAttrs";
    private static final String TAG_COLUMN = "column";
    private static final String ATTR_X = "x";
    private static final String ATTR_Y = "y";
    private static final String ATTR_W = "w";
    private static final String ATTR_H = "h";
    private static final int ERD_VERSION_1 = 1;
    private static final String BEND_ABSOLUTE = "abs";
    private static final String BEND_RELATIVE = "rel";
    private static final String TAG_NOTES = "notes";
    private static final String TAG_NOTE = "note";

    public static List<DBPDataSourceContainer> extractContainers(IFile resource) throws IOException, XMLException, DBException {
        ArrayList<DBPDataSourceContainer> containers = new ArrayList<DBPDataSourceContainer>();
        DBPProject projectMeta = DBWorkbench.getPlatform().getWorkspace().getProject(resource.getProject());
        if (projectMeta == null) {
            return containers;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = resource.getContents();){
                Document document = XMLUtils.parseDocument((InputStream)is);
                Element diagramElem = document.getDocumentElement();
                Element entitiesElem = XMLUtils.getChildElement((Element)diagramElem, (String)TAG_ENTITIES);
                if (entitiesElem != null) {
                    for (Element dsElem : XMLUtils.getChildElementList((Element)entitiesElem, (String)TAG_DATA_SOURCE)) {
                        DBPDataSourceContainer dataSourceContainer;
                        String dsId = dsElem.getAttribute(ATTR_ID);
                        if (CommonUtils.isEmpty((String)dsId) || (dataSourceContainer = projectMeta.getDataSourceRegistry().getDataSource(dsId)) == null) continue;
                        containers.add(dataSourceContainer);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            throw new DBException("Error reading resource contents", (Throwable)e);
        }
        return containers;
    }

    public static void load(DBRProgressMonitor monitor, IProject project, DiagramPart diagramPart, InputStream in) throws IOException, XMLException, DBException {
        ERDElement targetEntity;
        ERDElement sourceEntity;
        Element relationsElem;
        Element notesElem;
        monitor.beginTask("Parse diagram", 1);
        EntityDiagram diagram = diagramPart.getDiagram();
        DBPProject projectMeta = DBWorkbench.getPlatform().getWorkspace().getProject(project);
        if (projectMeta == null) {
            throw new DBException("Cannot find datasource registry for project '" + project.getName() + "'");
        }
        Document document = XMLUtils.parseDocument((InputStream)in);
        Element diagramElem = document.getDocumentElement();
        monitor.done();
        String diagramVersion = diagramElem.getAttribute(ATTR_VERSION);
        if (CommonUtils.isEmpty((String)diagramVersion)) {
            throw new DBException("Diagram version not found");
        }
        if (!diagramVersion.equals(String.valueOf(1))) {
            throw new DBException("Unsupported diagram version: " + diagramVersion);
        }
        ArrayList<ElementLoadInfo> tableInfos = new ArrayList<ElementLoadInfo>();
        ArrayList<RelationLoadInfo> relInfos = new ArrayList<RelationLoadInfo>();
        HashMap<String, ElementLoadInfo> elementMap = new HashMap<String, ElementLoadInfo>();
        Element entitiesElem = XMLUtils.getChildElement((Element)diagramElem, (String)TAG_ENTITIES);
        if (entitiesElem != null) {
            for (Element dsElem : XMLUtils.getChildElementList((Element)entitiesElem, (String)TAG_DATA_SOURCE)) {
                DBPDataSource dataSource;
                String dsId = dsElem.getAttribute(ATTR_ID);
                if (CommonUtils.isEmpty((String)dsId)) {
                    log.warn((Object)"Missing datasource ID");
                    continue;
                }
                DBPDataSourceContainer dBPDataSourceContainer = projectMeta.getDataSourceRegistry().getDataSource(dsId);
                if (dBPDataSourceContainer == null) {
                    log.warn((Object)("Datasource '" + dsId + "' not found"));
                    continue;
                }
                if (!dBPDataSourceContainer.isConnected()) {
                    monitor.subTask("Connect to '" + dBPDataSourceContainer.getName() + "'");
                    try {
                        dBPDataSourceContainer.connect(monitor, true, true);
                    }
                    catch (DBException e) {
                        diagram.addErrorMessage("Can't connect to '" + dBPDataSourceContainer.getName() + "': " + e.getMessage());
                        continue;
                    }
                }
                if (!((dataSource = dBPDataSourceContainer.getDataSource()) instanceof DBSObjectContainer)) {
                    diagram.addErrorMessage("Datasource '" + dBPDataSourceContainer.getName() + "' entities cannot be loaded - no entity container found");
                    continue;
                }
                DBSObjectContainer rootContainer = (DBSObjectContainer)dataSource;
                List entityElemList = XMLUtils.getChildElementList((Element)dsElem, (String)TAG_ENTITY);
                monitor.beginTask("Parse entities", entityElemList.size());
                for (Element entityElem : entityElemList) {
                    String tableId = entityElem.getAttribute(ATTR_ID);
                    String tableName = entityElem.getAttribute(ATTR_NAME);
                    monitor.subTask("Load " + tableName);
                    ArrayList<String> path = new ArrayList<String>();
                    for (Element pathElem : XMLUtils.getChildElementList((Element)entityElem, (String)TAG_PATH)) {
                        path.add(0, pathElem.getAttribute(ATTR_NAME));
                    }
                    DBSObjectContainer container = rootContainer;
                    for (String conName : path) {
                        DBSObject child = container.getChild(monitor, conName);
                        if (child == null) {
                            diagram.addErrorMessage("Container '" + conName + "' not found within '" + container.getName() + "'. Skip table '" + tableName + "'.");
                            container = null;
                            break;
                        }
                        if (child instanceof DBSObjectContainer) {
                            container = (DBSObjectContainer)child;
                            continue;
                        }
                        diagram.addErrorMessage("Object '" + child.getName() + "' is not a container");
                        container = null;
                        break;
                    }
                    if (container == null) continue;
                    DBSObject child = container.getChild(monitor, tableName);
                    if (!(child instanceof DBSEntity)) {
                        diagram.addErrorMessage("Cannot find table '" + tableName + "' in '" + container.getName() + "'");
                        continue;
                    }
                    String locX = entityElem.getAttribute(ATTR_X);
                    String locY = entityElem.getAttribute(ATTR_Y);
                    DBSEntity table = (DBSEntity)child;
                    EntityDiagram.NodeVisualInfo visualInfo = new EntityDiagram.NodeVisualInfo();
                    visualInfo.initBounds = new Rectangle();
                    if (CommonUtils.isEmpty((String)locX) || CommonUtils.isEmpty((String)locY)) {
                        diagram.setNeedsAutoLayout(true);
                    } else {
                        visualInfo.initBounds.x = Integer.parseInt(locX);
                        visualInfo.initBounds.y = Integer.parseInt(locY);
                    }
                    String attrVis = entityElem.getAttribute(ATTR_ATTRIBUTE_VISIBILITY);
                    if (!CommonUtils.isEmpty((String)attrVis)) {
                        visualInfo.attributeVisibility = ERDAttributeVisibility.valueOf(attrVis);
                    }
                    DiagramLoader.loadNodeVisualInfo(entityElem, visualInfo);
                    ElementLoadInfo info = new ElementLoadInfo(tableId, table, null, visualInfo);
                    tableInfos.add(info);
                    elementMap.put(info.objectId, info);
                    diagram.addVisualInfo(table, info.visualInfo);
                    monitor.worked(1);
                }
                monitor.done();
            }
        }
        if ((notesElem = XMLUtils.getChildElement((Element)diagramElem, (String)TAG_NOTES)) != null) {
            List noteElemList = XMLUtils.getChildElementList((Element)notesElem, (String)TAG_NOTE);
            monitor.beginTask("Parse notes", noteElemList.size());
            for (Element noteElem : noteElemList) {
                String noteText = XMLUtils.getElementBody((Element)noteElem);
                ERDNote note = new ERDNote(noteText);
                diagram.addNote(note, false);
                String noteId = noteElem.getAttribute(ATTR_ID);
                String locX = noteElem.getAttribute(ATTR_X);
                String locY = noteElem.getAttribute(ATTR_Y);
                String locW = noteElem.getAttribute(ATTR_W);
                String locH = noteElem.getAttribute(ATTR_H);
                EntityDiagram.NodeVisualInfo visualInfo = new EntityDiagram.NodeVisualInfo();
                if (!(CommonUtils.isEmpty((String)locX) || CommonUtils.isEmpty((String)locY) || CommonUtils.isEmpty((String)locW) || CommonUtils.isEmpty((String)locH))) {
                    visualInfo.initBounds = new Rectangle(Integer.parseInt(locX), Integer.parseInt(locY), Integer.parseInt(locW), Integer.parseInt(locH));
                }
                DiagramLoader.loadNodeVisualInfo(noteElem, visualInfo);
                diagram.addVisualInfo(note, visualInfo);
                if (CommonUtils.isEmpty((String)noteId)) continue;
                ElementLoadInfo info = new ElementLoadInfo(noteId, null, note, visualInfo);
                tableInfos.add(info);
                elementMap.put(info.objectId, info);
            }
        }
        if ((relationsElem = XMLUtils.getChildElement((Element)diagramElem, (String)TAG_RELATIONS)) != null) {
            List relElemList = XMLUtils.getChildElementList((Element)relationsElem, (String)TAG_RELATION);
            monitor.beginTask("Parse relations", relElemList.size());
            for (Element element : relElemList) {
                String relName = element.getAttribute(ATTR_NAME);
                monitor.subTask("Load " + relName);
                String relType = element.getAttribute(ATTR_TYPE);
                String pkRefId = element.getAttribute(ATTR_PK_REF);
                String fkRefId = element.getAttribute(ATTR_FK_REF);
                if (CommonUtils.isEmpty((String)relName) || CommonUtils.isEmpty((String)pkRefId) || CommonUtils.isEmpty((String)fkRefId)) {
                    log.warn((Object)"Missing relation ID");
                    continue;
                }
                ElementLoadInfo pkTable = (ElementLoadInfo)elementMap.get(pkRefId);
                ElementLoadInfo fkTable = (ElementLoadInfo)elementMap.get(fkRefId);
                if (pkTable == null || fkTable == null) {
                    log.debug((Object)("PK (" + pkRefId + ") or FK (" + fkRefId + ") table(s) not found for relation " + relName));
                    continue;
                }
                RelationLoadInfo relationLoadInfo = new RelationLoadInfo(relName, relType, pkTable, fkTable);
                relInfos.add(relationLoadInfo);
                for (Element columnElem : XMLUtils.getChildElementList((Element)element, (String)TAG_COLUMN)) {
                    String name = columnElem.getAttribute(ATTR_NAME);
                    String refName = columnElem.getAttribute(ATTR_REF_NAME);
                    relationLoadInfo.columns.put(name, refName);
                }
                for (Element bendElem : XMLUtils.getChildElementList((Element)element, (String)TAG_BEND)) {
                    String type = bendElem.getAttribute(ATTR_TYPE);
                    if (BEND_RELATIVE.equals(type)) continue;
                    String locX = bendElem.getAttribute(ATTR_X);
                    String locY = bendElem.getAttribute(ATTR_Y);
                    if (CommonUtils.isEmpty((String)locX) || CommonUtils.isEmpty((String)locY)) continue;
                    relationLoadInfo.bends.add(new Point(Integer.parseInt(locX), Integer.parseInt(locY)));
                }
                monitor.worked(1);
            }
            monitor.done();
        }
        ArrayList<DBSEntity> tableList = new ArrayList<DBSEntity>();
        for (ElementLoadInfo elementLoadInfo : tableInfos) {
            if (elementLoadInfo.entity == null) continue;
            tableList.add(elementLoadInfo.entity);
        }
        diagram.fillEntities(monitor, tableList, null);
        for (RelationLoadInfo relationLoadInfo : relInfos) {
            if (!relationLoadInfo.type.equals(ERDConstants.CONSTRAINT_LOGICAL_FK.getId())) continue;
            sourceEntity = relationLoadInfo.pkTable.entity != null ? diagram.getEntity(relationLoadInfo.pkTable.entity) : relationLoadInfo.pkTable.note;
            ERDElement eRDElement = targetEntity = relationLoadInfo.fkTable.entity != null ? diagram.getEntity(relationLoadInfo.fkTable.entity) : relationLoadInfo.fkTable.note;
            if (sourceEntity != null && targetEntity != null) {
                new ERDAssociation(targetEntity, sourceEntity, false);
            }
            diagram.addInitRelationBends(sourceEntity, targetEntity, relationLoadInfo.name, relationLoadInfo.bends);
        }
        for (RelationLoadInfo relationLoadInfo : relInfos) {
            if (CommonUtils.isEmpty(relationLoadInfo.bends) || relationLoadInfo.pkTable.entity == null || relationLoadInfo.fkTable.entity == null) continue;
            sourceEntity = diagram.getEntity(relationLoadInfo.pkTable.entity);
            if (sourceEntity == null) {
                log.warn((Object)("Source table " + relationLoadInfo.pkTable.entity.getName() + " not found"));
                continue;
            }
            targetEntity = diagram.getEntity(relationLoadInfo.fkTable.entity);
            if (targetEntity == null) {
                log.warn((Object)("Target table " + relationLoadInfo.pkTable.entity.getName() + " not found"));
                continue;
            }
            diagram.addInitRelationBends(sourceEntity, targetEntity, relationLoadInfo.name, relationLoadInfo.bends);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String serializeDiagram(DBRProgressMonitor monitor, @Nullable DiagramPart diagramPart, EntityDiagram diagram, boolean verbose, boolean compact) throws IOException {
        List allNodeFigures = diagramPart == null ? new ArrayList() : diagramPart.getFigure().getChildren();
        Map<DBPDataSourceContainer, DataSourceObjects> dsMap = DiagramLoader.createDataSourceObjectMap(diagram);
        IdentityHashMap<ERDElement, ElementSaveInfo> elementInfoMap = new IdentityHashMap<ERDElement, ElementSaveInfo>();
        int elementCounter = 1;
        StringWriter out = new StringWriter(1000);
        XMLBuilder xml = new XMLBuilder((Writer)out, GeneralUtils.UTF8_ENCODING, !compact);
        xml.setButify(!compact);
        if (verbose) {
            xml.addContent((CharSequence)"\n<!DOCTYPE diagram [\n<!ATTLIST diagram version CDATA #REQUIRED\n name CDATA #IMPLIED\n time CDATA #REQUIRED>\n<!ELEMENT diagram (entities, relations, notes)>\n<!ELEMENT entities (data-source*)>\n<!ELEMENT data-source (entity*)>\n<!ATTLIST data-source id CDATA #REQUIRED>\n<!ELEMENT entity (path*)>\n<!ATTLIST entity id ID #REQUIRED\n name CDATA #REQUIRED\n fq-name CDATA #REQUIRED>\n<!ELEMENT relations (relation*)>\n<!ELEMENT relation (bend*)>\n<!ATTLIST relation name CDATA #REQUIRED\n fq-name CDATA #REQUIRED\n pk-ref IDREF #REQUIRED\n fk-ref IDREF #REQUIRED>\n]>\n");
        }
        xml.startElement(TAG_DIAGRAM);
        xml.addAttribute(ATTR_VERSION, 1);
        if (diagram != null) {
            xml.addAttribute(ATTR_NAME, diagram.getName());
        }
        if (compact) {
            xml.addAttribute(ATTR_TIME, RuntimeUtils.getCurrentTimeStamp());
        }
        if (diagram != null) {
            xml.startElement(TAG_ENTITIES);
            for (DBPDataSourceContainer dsContainer : dsMap.keySet()) {
                xml.startElement(TAG_DATA_SOURCE);
                xml.addAttribute(ATTR_ID, dsContainer.getId());
                DataSourceObjects desc = dsMap.get(dsContainer);
                for (ERDEntity erdEntity : desc.entities) {
                    void var19_19;
                    DBSEntity table = (DBSEntity)erdEntity.getObject();
                    EntityPart tablePart = diagramPart == null ? null : diagramPart.getEntityPart(erdEntity);
                    ElementSaveInfo info = new ElementSaveInfo(erdEntity, tablePart, elementCounter++);
                    elementInfoMap.put(erdEntity, info);
                    xml.startElement(TAG_ENTITY);
                    xml.addAttribute(ATTR_ID, info.objectId);
                    xml.addAttribute(ATTR_NAME, table.getName());
                    if (table instanceof DBPQualifiedObject) {
                        xml.addAttribute(ATTR_FQ_NAME, ((DBPQualifiedObject)table).getFullyQualifiedName(DBPEvaluationContext.UI));
                    }
                    if (!CommonUtils.isEmpty((String)erdEntity.getAlias())) {
                        xml.addAttribute(ATTR_ALIAS, erdEntity.getAlias());
                    }
                    if (erdEntity.getAttributeVisibility() != null) {
                        xml.addAttribute(ATTR_ATTRIBUTE_VISIBILITY, erdEntity.getAttributeVisibility().name());
                    }
                    if (tablePart != null) {
                        EntityDiagram.NodeVisualInfo nodeVisualInfo = new EntityDiagram.NodeVisualInfo();
                        nodeVisualInfo.initBounds = tablePart.getBounds();
                        nodeVisualInfo.bgColor = tablePart.getCustomBackgroundColor();
                        DiagramLoader.saveColorAndOrder(allNodeFigures, xml, tablePart);
                    } else {
                        EntityDiagram.NodeVisualInfo nodeVisualInfo = diagram.getVisualInfo((DBSEntity)erdEntity.getObject());
                    }
                    if (var19_19 != null && var19_19.initBounds != null) {
                        xml.addAttribute(ATTR_X, var19_19.initBounds.x);
                        xml.addAttribute(ATTR_Y, var19_19.initBounds.y);
                    }
                    Object parent = table.getParentObject();
                    while (parent != null && DBUtils.getPublicObjectContainer((DBSObject)parent) != dsContainer) {
                        xml.startElement(TAG_PATH);
                        xml.addAttribute(ATTR_NAME, parent.getName());
                        xml.endElement();
                        parent = parent.getParentObject();
                    }
                    xml.endElement();
                }
                xml.endElement();
            }
            xml.endElement();
            if (!CommonUtils.isEmpty(diagram.getNotes())) {
                xml.startElement(TAG_NOTES);
                for (ERDNote note : diagram.getNotes()) {
                    NotePart notePart = diagramPart == null ? null : diagramPart.getNotePart(note);
                    xml.startElement(TAG_NOTE);
                    if (notePart != null) {
                        ElementSaveInfo info = new ElementSaveInfo(note, notePart, elementCounter++);
                        elementInfoMap.put(note, info);
                        xml.addAttribute(ATTR_ID, info.objectId);
                        DiagramLoader.saveColorAndOrder(allNodeFigures, xml, notePart);
                        Rectangle noteBounds = notePart.getBounds();
                        if (noteBounds != null) {
                            xml.addAttribute(ATTR_X, noteBounds.x);
                            xml.addAttribute(ATTR_Y, noteBounds.y);
                            xml.addAttribute(ATTR_W, noteBounds.width);
                            xml.addAttribute(ATTR_H, noteBounds.height);
                        }
                    }
                    xml.addText((CharSequence)note.getObject());
                    xml.endElement();
                }
                xml.endElement();
            }
            xml.startElement(TAG_RELATIONS);
            ArrayList<ERDElement> allElements = new ArrayList<ERDElement>();
            allElements.addAll(diagram.getEntities());
            allElements.addAll(diagram.getNotes());
            for (ERDElement element : allElements) {
                for (ERDAssociation rel : element.getReferences()) {
                    List<Bendpoint> bendpoints;
                    AssociationPart associationPart;
                    ElementSaveInfo pkInfo = (ElementSaveInfo)elementInfoMap.get(rel.getTargetEntity());
                    if (pkInfo == null) {
                        log.error((Object)("Cannot find PK table '" + rel.getTargetEntity().getName() + "' in info map"));
                        continue;
                    }
                    ElementSaveInfo fkInfo = (ElementSaveInfo)elementInfoMap.get(rel.getSourceEntity());
                    if (fkInfo == null) {
                        log.error((Object)("Cannot find FK table '" + rel.getSourceEntity().getName() + "' in info map"));
                        continue;
                    }
                    DBSEntityAssociation association = (DBSEntityAssociation)rel.getObject();
                    xml.startElement(TAG_RELATION);
                    xml.addAttribute(ATTR_NAME, association.getName());
                    if (association instanceof DBPQualifiedObject) {
                        xml.addAttribute(ATTR_FQ_NAME, ((DBPQualifiedObject)association).getFullyQualifiedName(DBPEvaluationContext.UI));
                    }
                    xml.addAttribute(ATTR_TYPE, association.getConstraintType().getId());
                    xml.addAttribute(ATTR_PK_REF, pkInfo.objectId);
                    xml.addAttribute(ATTR_FK_REF, fkInfo.objectId);
                    if (association instanceof ERDLogicalAssociation) {
                        for (DBSEntityAttributeRef dBSEntityAttributeRef : ((ERDLogicalAssociation)association).getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor())) {
                            xml.startElement(TAG_COLUMN);
                            xml.addAttribute(ATTR_NAME, dBSEntityAttributeRef.getAttribute().getName());
                            try {
                                DBSEntityAttribute referenceAttribute = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)association, (DBSEntityAttribute)dBSEntityAttributeRef.getAttribute(), (boolean)false);
                                if (referenceAttribute != null) {
                                    xml.addAttribute(ATTR_REF_NAME, referenceAttribute.getName());
                                }
                            }
                            catch (DBException e) {
                                log.warn((Object)"Error getting reference attribute", (Throwable)e);
                            }
                            xml.endElement();
                        }
                    }
                    if (pkInfo.nodePart != null && (associationPart = pkInfo.nodePart.getConnectionPart(rel, false)) != null && !CommonUtils.isEmpty(bendpoints = associationPart.getBendpoints())) {
                        for (Bendpoint bendpoint : bendpoints) {
                            xml.startElement(TAG_BEND);
                            if (bendpoint instanceof AbsoluteBendpoint) {
                                xml.addAttribute(ATTR_TYPE, BEND_ABSOLUTE);
                                xml.addAttribute(ATTR_X, bendpoint.getLocation().x);
                                xml.addAttribute(ATTR_Y, bendpoint.getLocation().y);
                            } else if (bendpoint instanceof RelativeBendpoint) {
                                xml.addAttribute(ATTR_TYPE, BEND_RELATIVE);
                                xml.addAttribute(ATTR_X, bendpoint.getLocation().x);
                                xml.addAttribute(ATTR_Y, bendpoint.getLocation().y);
                            }
                            xml.endElement();
                        }
                    }
                    xml.endElement();
                }
            }
            xml.endElement();
        }
        xml.endElement();
        xml.flush();
        return out.toString();
    }

    private static Map<DBPDataSourceContainer, DataSourceObjects> createDataSourceObjectMap(EntityDiagram diagram) {
        IdentityHashMap<DBPDataSourceContainer, DataSourceObjects> dsMap = new IdentityHashMap<DBPDataSourceContainer, DataSourceObjects>();
        if (diagram != null) {
            for (ERDEntity erdEntity : diagram.getEntities()) {
                DBPDataSourceContainer dsContainer = ((DBSEntity)erdEntity.getObject()).getDataSource().getContainer();
                DataSourceObjects desc = dsMap.computeIfAbsent(dsContainer, k -> new DataSourceObjects());
                desc.entities.add(erdEntity);
            }
        }
        return dsMap;
    }

    private static void saveColorAndOrder(List allNodeFigures, XMLBuilder xml, NodePart nodePart) throws IOException {
        if (nodePart != null) {
            int defBorderWidth;
            Color defFgColor;
            Color fgColor;
            Color defBgColor;
            Color bgColor;
            xml.addAttribute(ATTR_ORDER, allNodeFigures.indexOf(nodePart.getFigure()));
            if (nodePart.getCustomTransparency()) {
                xml.addAttribute(ATTR_TRANSPARENT, true);
            }
            if ((bgColor = nodePart.getCustomBackgroundColor()) != null && !CommonUtils.equalObjects((Object)bgColor, (Object)(defBgColor = UIUtils.getColorRegistry().get(nodePart instanceof NotePart ? "org.jkiss.dbeaver.erd.diagram.notes.background" : "org.jkiss.dbeaver.erd.diagram.entity.regular.background")))) {
                xml.addAttribute(ATTR_COLOR_BG, StringConverter.asString((RGB)bgColor.getRGB()));
            }
            if ((fgColor = nodePart.getCustomForegroundColor()) != null && !CommonUtils.equalObjects((Object)fgColor, (Object)(defFgColor = UIUtils.getColorRegistry().get(nodePart instanceof NotePart ? "org.jkiss.dbeaver.erd.diagram.notes.foreground" : "org.jkiss.dbeaver.erd.diagram.entity.name.foreground")))) {
                xml.addAttribute(ATTR_COLOR_FG, StringConverter.asString((RGB)fgColor.getRGB()));
            }
            int borderWidth = nodePart.getCustomBorderWidth();
            int n = defBorderWidth = nodePart instanceof NotePart ? 1 : 2;
            if (borderWidth != defBorderWidth) {
                xml.addAttribute(ATTR_BORDER_WIDTH, borderWidth);
            }
            if (!SharedFonts.equalFonts((Font)nodePart.getCustomFont(), (Font)Display.getCurrent().getSystemFont())) {
                xml.addAttribute(ATTR_FONT, SharedFonts.toString((Font)nodePart.getCustomFont()));
            }
        }
    }

    private static void loadNodeVisualInfo(Element entityElem, EntityDiagram.NodeVisualInfo visualInfo) {
        String orderStr;
        String fontStr;
        String borderWidth;
        String colorFg;
        String colorBg;
        String isTransparent = entityElem.getAttribute(ATTR_TRANSPARENT);
        if (!CommonUtils.isEmpty((String)isTransparent)) {
            visualInfo.transparent = CommonUtils.toBoolean((Object)isTransparent);
        }
        if (!CommonUtils.isEmpty((String)(colorBg = entityElem.getAttribute(ATTR_COLOR_BG)))) {
            visualInfo.bgColor = UIUtils.getSharedColor((String)colorBg);
        }
        if (!CommonUtils.isEmpty((String)(colorFg = entityElem.getAttribute(ATTR_COLOR_FG)))) {
            visualInfo.fgColor = UIUtils.getSharedColor((String)colorFg);
        }
        if (!CommonUtils.isEmpty((String)(borderWidth = entityElem.getAttribute(ATTR_BORDER_WIDTH)))) {
            visualInfo.borderWidth = CommonUtils.toInt((Object)borderWidth);
        }
        if (!CommonUtils.isEmpty((String)(fontStr = entityElem.getAttribute(ATTR_FONT)))) {
            visualInfo.font = UIUtils.getSharedFonts().getFont((Device)Display.getCurrent(), fontStr);
        }
        if (!CommonUtils.isEmpty((String)(orderStr = entityElem.getAttribute(ATTR_ORDER)))) {
            visualInfo.zOrder = Integer.parseInt(orderStr);
        }
    }

    private static class DataSourceObjects {
        List<ERDEntity> entities = new ArrayList<ERDEntity>();

        private DataSourceObjects() {
        }
    }

    private static class ElementLoadInfo {
        final String objectId;
        final DBSEntity entity;
        final ERDNote note;
        final EntityDiagram.NodeVisualInfo visualInfo;

        private ElementLoadInfo(String objectId, DBSEntity entity, ERDNote note, EntityDiagram.NodeVisualInfo visualInfo) {
            this.objectId = objectId;
            this.entity = entity;
            this.note = note;
            this.visualInfo = visualInfo;
        }
    }

    private static class ElementSaveInfo {
        final ERDElement element;
        final NodePart nodePart;
        final int objectId;

        private ElementSaveInfo(ERDElement element, NodePart nodePart, int objectId) {
            this.element = element;
            this.nodePart = nodePart;
            this.objectId = objectId;
        }
    }

    private static class RelationLoadInfo {
        final String name;
        final String type;
        final ElementLoadInfo pkTable;
        final ElementLoadInfo fkTable;
        final Map<String, String> columns = new LinkedHashMap<String, String>();
        final List<Point> bends = new ArrayList<Point>();

        private RelationLoadInfo(String name, String type, ElementLoadInfo pkTable, ElementLoadInfo fkTable) {
            this.name = name;
            this.type = type;
            this.pkTable = pkTable;
            this.fkTable = fkTable;
        }
    }
}

