/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.views;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.internal.GenericMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCURL;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class GenericConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private Text hostText;
    private Text portText;
    private Text serverText;
    private Text dbText;
    private Text pathText;
    private Text userNameText;
    private Text passwordText;
    private Text urlText;
    private boolean isCustom;
    private JDBCURL.MetaURL metaURL;
    private Composite settingsGroup;
    private Map<String, List<Control>> propGroupMap = new HashMap<String, List<Control>>();
    private static final String GROUP_URL = "url";
    private static final String GROUP_HOST = "host";
    private static final String GROUP_SERVER = "server";
    private static final String GROUP_DB = "db";
    private static final String GROUP_PATH = "path";
    private static final String GROUP_LOGIN = "login";
    private boolean activated;
    private Button createButton;

    public void createControl(Composite composite) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(composite, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Label urlLabel = new Label(this.settingsGroup, 0);
        urlLabel.setText(GenericMessages.dialog_connection_jdbc_url_);
        gd = new GridData(128);
        urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 355;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(e -> this.site.updateButtons());
        this.addControlToGroup(GROUP_URL, (Control)urlLabel);
        this.addControlToGroup(GROUP_URL, (Control)this.urlText);
        Label hostLabel = new Label(this.settingsGroup, 0);
        hostLabel.setText(GenericMessages.dialog_connection_host_label);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        Label portLabel = new Label(this.settingsGroup, 0);
        portLabel.setText(GenericMessages.dialog_connection_port_label);
        portLabel.setLayoutData((Object)new GridData(128));
        this.portText = new Text(this.settingsGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.addControlToGroup(GROUP_HOST, (Control)hostLabel);
        this.addControlToGroup(GROUP_HOST, (Control)this.hostText);
        this.addControlToGroup(GROUP_HOST, (Control)portLabel);
        this.addControlToGroup(GROUP_HOST, (Control)this.portText);
        Label serverLabel = new Label(this.settingsGroup, 0);
        serverLabel.setText(GenericMessages.dialog_connection_server_label);
        serverLabel.setLayoutData((Object)new GridData(128));
        this.serverText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.serverText.setLayoutData((Object)gd);
        this.serverText.addModifyListener(textListener);
        Control emptyLabel = UIUtils.createEmptyLabel((Composite)this.settingsGroup, (int)2, (int)1);
        this.addControlToGroup(GROUP_SERVER, (Control)serverLabel);
        this.addControlToGroup(GROUP_SERVER, (Control)this.serverText);
        this.addControlToGroup(GROUP_SERVER, emptyLabel);
        Label dbLabel = new Label(this.settingsGroup, 0);
        dbLabel.setText(GenericMessages.dialog_connection_database_schema_label);
        dbLabel.setLayoutData((Object)new GridData(128));
        this.dbText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.dbText.setLayoutData((Object)gd);
        this.dbText.addModifyListener(textListener);
        emptyLabel = UIUtils.createEmptyLabel((Composite)this.settingsGroup, (int)2, (int)1);
        this.addControlToGroup(GROUP_DB, (Control)dbLabel);
        this.addControlToGroup(GROUP_DB, (Control)this.dbText);
        this.addControlToGroup(GROUP_DB, emptyLabel);
        Label pathLabel = new Label(this.settingsGroup, 0);
        pathLabel.setText(GenericMessages.dialog_connection_path_label);
        pathLabel.setLayoutData((Object)new GridData(128));
        this.pathText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 200;
        gd.horizontalSpan = 2;
        this.pathText.setLayoutData((Object)gd);
        this.pathText.addModifyListener(textListener);
        this.pathText.addModifyListener(e -> this.updateCreateButton(this.site.getDriver()));
        Composite buttonsPanel = new Composite(this.settingsGroup, 0);
        gl = new GridLayout(2, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonsPanel.setLayout((Layout)gl);
        gd = new GridData(128);
        gd.widthHint = 150;
        buttonsPanel.setLayoutData((Object)gd);
        Button browseButton = new Button(buttonsPanel, 8);
        browseButton.setText(GenericMessages.dialog_connection_browse_button);
        gd = new GridData(768);
        browseButton.setLayoutData((Object)gd);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GenericConnectionPage.this.metaURL.getAvailableProperties().contains("file")) {
                    FileDialog dialog = new FileDialog(GenericConnectionPage.this.getShell(), 4100);
                    dialog.setFileName(GenericConnectionPage.this.pathText.getText());
                    dialog.setText(GenericMessages.dialog_connection_db_file_chooser_text);
                    String file = dialog.open();
                    if (file != null) {
                        GenericConnectionPage.this.pathText.setText(file);
                    }
                } else {
                    DirectoryDialog dialog = new DirectoryDialog(GenericConnectionPage.this.getShell(), 0);
                    String curPath = GenericConnectionPage.this.pathText.getText();
                    File curFolder = new File(curPath);
                    if (curFolder.exists()) {
                        if (curFolder.isDirectory()) {
                            dialog.setFilterPath(curFolder.getAbsolutePath());
                        } else {
                            dialog.setFilterPath(curFolder.getParentFile().getAbsolutePath());
                        }
                    }
                    dialog.setText(GenericMessages.dialog_connection_db_folder_chooser_text);
                    dialog.setMessage(GenericMessages.dialog_connection_db_folder_chooser_message);
                    String folder = dialog.open();
                    if (folder != null) {
                        GenericConnectionPage.this.pathText.setText(folder);
                    }
                }
            }
        });
        this.createButton = new Button(buttonsPanel, 8);
        this.createButton.setText("Create");
        this.createButton.setLayoutData((Object)new GridData(768));
        this.createButton.setEnabled(false);
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenericConnectionPage.this.createEmbeddedDatabase();
            }
        });
        this.addControlToGroup(GROUP_PATH, (Control)pathLabel);
        this.addControlToGroup(GROUP_PATH, (Control)this.pathText);
        this.addControlToGroup(GROUP_PATH, (Control)buttonsPanel);
        Label userNameLabel = new Label(this.settingsGroup, 0);
        userNameLabel.setText(GenericMessages.dialog_connection_user_name_label);
        userNameLabel.setLayoutData((Object)new GridData(128));
        this.userNameText = new Text(this.settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.userNameText.setLayoutData((Object)gd);
        this.userNameText.addModifyListener(textListener);
        emptyLabel = UIUtils.createEmptyLabel((Composite)this.settingsGroup, (int)2, (int)1);
        Label passwordLabel = new Label(this.settingsGroup, 0);
        passwordLabel.setText(GenericMessages.dialog_connection_password_label);
        passwordLabel.setLayoutData((Object)new GridData(128));
        this.passwordText = new Text(this.settingsGroup, 0x400800);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        this.createSavePasswordButton(this.settingsGroup, 2);
        this.addControlToGroup(GROUP_LOGIN, (Control)userNameLabel);
        this.addControlToGroup(GROUP_LOGIN, (Control)this.userNameText);
        this.addControlToGroup(GROUP_LOGIN, emptyLabel);
        this.addControlToGroup(GROUP_LOGIN, (Control)passwordLabel);
        this.addControlToGroup(GROUP_LOGIN, (Control)this.passwordText);
        this.addControlToGroup(GROUP_LOGIN, (Control)this.savePasswordCheck);
        this.createDriverPanel(this.settingsGroup);
        this.setControl((Control)this.settingsGroup);
    }

    protected void updateDriverInfo(DBPDriver driver) {
        this.parseSampleURL(driver);
        this.saveAndUpdate();
    }

    public boolean isComplete() {
        if (this.isCustom) {
            return !CommonUtils.isEmpty((String)this.urlText.getText());
        }
        if (this.metaURL == null) {
            return false;
        }
        for (String prop : this.metaURL.getRequiredProperties()) {
            if (!(prop.equals(GROUP_HOST) && CommonUtils.isEmptyTrimmed((String)this.hostText.getText()) || prop.equals("port") && CommonUtils.isEmptyTrimmed((String)this.portText.getText()) || prop.equals("database") && CommonUtils.isEmptyTrimmed((String)this.dbText.getText())) && (!prop.equals("file") && !prop.equals("folder") || !CommonUtils.isEmptyTrimmed((String)this.pathText.getText()))) continue;
            return false;
        }
        return true;
    }

    protected boolean isCustomURL() {
        return this.isCustom;
    }

    public void loadSettings() {
        super.loadSettings();
        DBPDriver driver = this.getSite().getDriver();
        DBPImage iconBig = driver.getIconBig();
        if (iconBig != null) {
            ImageDescriptor imageDescriptor = DBeaverIcons.getImageDescriptor((DBPImage)iconBig);
            if (imageDescriptor.getImageData().width >= 64) {
                this.setImageDescriptor(imageDescriptor);
            } else {
                this.setImageDescriptor(null);
            }
        }
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.parseSampleURL(this.site.getDriver());
        if (!this.isCustom) {
            if (this.hostText != null) {
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                    this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
                } else {
                    this.hostText.setText("localhost");
                }
            }
            if (this.portText != null) {
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                    this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
                } else if (this.site.getDriver().getDefaultPort() != null) {
                    this.portText.setText(this.site.getDriver().getDefaultPort());
                } else {
                    this.portText.setText("");
                }
            }
            if (this.serverText != null) {
                this.serverText.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
            }
            if (this.dbText != null) {
                this.dbText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            }
            if (this.pathText != null) {
                this.pathText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            }
        } else {
            this.hostText.setText("");
            this.portText.setText("");
            this.serverText.setText("");
            this.dbText.setText("");
            this.pathText.setText("");
        }
        if (this.userNameText != null) {
            this.userNameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
        if (this.urlText != null) {
            if (CommonUtils.isEmpty((String)connectionInfo.getUrl())) {
                try {
                    this.saveSettings(this.site.getActiveDataSource());
                }
                catch (Exception e) {
                    this.setMessage(e.getMessage());
                }
            }
            if (connectionInfo.getUrl() != null) {
                this.urlText.setText(CommonUtils.notEmpty((String)connectionInfo.getUrl()));
            } else {
                this.urlText.setText("");
            }
        }
        this.activated = true;
        UIUtils.asyncExec(() -> {
            if (CommonUtils.isEmpty((String)this.site.getDriver().getSampleURL())) {
                this.urlText.setFocus();
            } else if (this.hostText != null && this.hostText.isVisible()) {
                this.hostText.setFocus();
            } else if (this.serverText != null && this.serverText.isVisible()) {
                this.serverText.setFocus();
            } else if (this.dbText != null && this.dbText.isVisible()) {
                this.dbText.setFocus();
            } else if (this.pathText != null && this.pathText.isVisible()) {
                this.pathText.setFocus();
            } else if (this.userNameText != null && this.userNameText.isVisible()) {
                this.userNameText.setFocus();
            }
        });
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        Set properties;
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        Set set = properties = this.metaURL == null ? Collections.emptySet() : this.metaURL.getAvailableProperties();
        if (this.hostText != null && properties.contains(GROUP_HOST)) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null && properties.contains("port")) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.serverText != null && properties.contains(GROUP_SERVER)) {
            connectionInfo.setServerName(this.serverText.getText().trim());
        }
        if (this.dbText != null && properties.contains("database")) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.pathText != null && (properties.contains("folder") || properties.contains("file"))) {
            connectionInfo.setDatabaseName(this.pathText.getText().trim());
        }
        if (this.userNameText != null) {
            connectionInfo.setUserName(this.userNameText.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        super.saveSettings(dataSource);
        if (this.isCustom) {
            if (this.urlText != null) {
                connectionInfo.setUrl(this.urlText.getText().trim());
            }
        } else if (this.urlText != null && connectionInfo.getUrl() != null) {
            this.urlText.setText(connectionInfo.getUrl());
        }
    }

    private void parseSampleURL(DBPDriver driver) {
        this.metaURL = null;
        if (!CommonUtils.isEmpty((String)driver.getSampleURL())) {
            this.isCustom = false;
            try {
                this.metaURL = JDBCURL.parseSampleURL((String)driver.getSampleURL());
            }
            catch (DBException e) {
                this.setErrorMessage(e.getMessage());
            }
            Set properties = this.metaURL.getAvailableProperties();
            this.urlText.setEditable(false);
            this.showControlGroup(GROUP_HOST, properties.contains(GROUP_HOST));
            this.showControlGroup(GROUP_SERVER, properties.contains(GROUP_SERVER));
            this.showControlGroup(GROUP_DB, properties.contains("database"));
            this.showControlGroup(GROUP_PATH, properties.contains("folder") || properties.contains("file"));
        } else {
            this.isCustom = true;
            this.showControlGroup(GROUP_HOST, false);
            this.showControlGroup(GROUP_SERVER, false);
            this.showControlGroup(GROUP_DB, false);
            this.showControlGroup(GROUP_PATH, false);
            this.urlText.setEditable(true);
        }
        UIUtils.fixReadonlyTextBackground((Text)this.urlText);
        this.showControlGroup(GROUP_LOGIN, !driver.isAnonymousAccess());
        this.updateCreateButton(driver);
        this.settingsGroup.layout();
    }

    private void updateCreateButton(DBPDriver driver) {
        if (driver == null) {
            this.createButton.setEnabled(false);
            return;
        }
        String paramCreate = CommonUtils.toString((Object)driver.getDriverParameter("create-url-param"));
        this.createButton.setEnabled(!CommonUtils.isEmpty((String)paramCreate) && !CommonUtils.isEmpty((String)this.pathText.getText()));
    }

    private void createEmbeddedDatabase() {
        String paramCreate = CommonUtils.toString((Object)this.site.getDriver().getDriverParameter("create-url-param"));
        DataSourceDescriptor dataSource = (DataSourceDescriptor)this.site.getActiveDataSource();
        DataSourceDescriptor testDataSource = new DataSourceDescriptor(this.site.getDataSourceRegistry(), dataSource.getId(), dataSource.getDriver(), new DBPConnectionConfiguration(dataSource.getConnectionConfiguration()));
        this.saveSettings((DBPDataSourceContainer)testDataSource);
        DBPConnectionConfiguration cfg = testDataSource.getConnectionConfiguration();
        cfg.setUrl(String.valueOf(cfg.getUrl()) + paramCreate);
        String databaseName = cfg.getDatabaseName();
        testDataSource.setName(databaseName);
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Create Database", (String)("Are you sure you want to create database '" + databaseName + "'?"))) {
            testDataSource.dispose();
            return;
        }
        try {
            this.site.getRunnableContext().run(true, true, monitor -> {
                try {
                    this.createEmbeddedDatabase(monitor, testDataSource);
                }
                catch (DBException e1) {
                    throw new InvocationTargetException(e1);
                }
            });
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Database Create", (String)("Database '" + databaseName + "' created!"));
        }
        catch (InvocationTargetException e1) {
            DBWorkbench.getPlatformUI().showError("Create database", "Error creating database", e1.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void createEmbeddedDatabase(DBRProgressMonitor monitor, DataSourceDescriptor testDataSource) throws DBException {
        try {
            testDataSource.connect(monitor, true, true);
            testDataSource.disconnect(monitor);
        }
        finally {
            testDataSource.dispose();
        }
    }

    private void saveAndUpdate() {
        this.saveSettings(this.site.getActiveDataSource());
        this.site.updateButtons();
    }

    private void showControlGroup(String group, boolean show) {
        List<Control> controlList = this.propGroupMap.get(group);
        if (controlList != null) {
            for (Control control : controlList) {
                GridData gd = (GridData)control.getLayoutData();
                if (gd == null) {
                    gd = new GridData(1);
                    control.setLayoutData((Object)gd);
                }
                gd.exclude = !show;
                control.setVisible(show);
            }
        }
    }

    private void addControlToGroup(String group, Control control) {
        List<Control> controlList = this.propGroupMap.get(group);
        if (controlList == null) {
            controlList = new ArrayList<Control>();
            this.propGroupMap.put(group, controlList);
        }
        controlList.add(control);
    }

    public IDialogPage[] getSubPages(boolean extrasOnly) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

