/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.view;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.part.StatusPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;

public class ErrorPresentation
extends AbstractPresentation {
    private static final Log log = Log.getLog(ErrorPresentation.class);
    private static final String SETTINGS_SECTION_ERROR_PANEL = ErrorPresentation.class.getSimpleName();
    private static final String PROP_ERROR_WIDTH = "errorWidth";
    private final String sqlText;
    private final IStatus status;
    private Composite errorComposite;
    private StatusPart statusPart;
    private Composite sqlPanel;
    private StyledText textWidget;

    public ErrorPresentation(String sqlText, IStatus status) {
        this.sqlText = sqlText;
        this.status = status;
    }

    @Override
    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        CustomSashForm partDivider = UIUtils.createPartDivider((IWorkbenchPart)controller.getSite().getPart(), (Composite)parent, (int)256);
        partDivider.setLayoutData((Object)new GridData(1808));
        this.errorComposite = UIUtils.createComposite((Composite)partDivider, (int)1);
        this.errorComposite.setLayoutData((Object)new GridData(1808));
        this.statusPart = new StatusPart(this.errorComposite, this.status);
        this.sqlPanel = UIUtils.createComposite((Composite)partDivider, (int)1);
        this.sqlPanel.setLayout((Layout)new FillLayout());
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        try {
            Object panel = serviceSQL.createSQLPanel((Object)controller.getSite(), (Object)this.sqlPanel, (DBPContextProvider)controller, "SQL", true, this.sqlText);
            if (panel instanceof TextViewer) {
                this.textWidget = ((TextViewer)panel).getTextWidget();
            }
        }
        catch (DBException dBException) {
            this.textWidget = new StyledText(this.sqlPanel, 2056);
            this.textWidget.setText(this.sqlText);
        }
        try {
            boolean widthSet = false;
            IDialogSettings viewSettings = ResultSetUtils.getViewerSettings(SETTINGS_SECTION_ERROR_PANEL);
            String errorWidth = viewSettings.get(PROP_ERROR_WIDTH);
            if (errorWidth != null) {
                String[] widthStrs = errorWidth.split(":");
                if (widthStrs.length == 2) {
                    partDivider.setWeights(new int[]{Integer.parseInt(widthStrs[0]), Integer.parseInt(widthStrs[1])});
                }
                widthSet = true;
            }
            if (!widthSet) {
                partDivider.setWeights(new int[]{700, 300});
            }
            partDivider.addCustomSashFormListener((firstControlWeight, secondControlWeight) -> {
                int[] weights = partDivider.getWeights();
                viewSettings.put(PROP_ERROR_WIDTH, String.valueOf(weights[0]) + ":" + weights[1]);
            });
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
    }

    @Override
    public Control getControl() {
        return this.textWidget;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
    }

    @Override
    public void formatData(boolean refreshData) {
    }

    @Override
    public void clearMetaData() {
    }

    @Override
    public void updateValueView() {
    }

    @Override
    public void changeMode(boolean recordMode) {
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return null;
    }

    @Override
    @Nullable
    public String copySelectionToString(ResultSetCopySettings settings) {
        return null;
    }
}

