/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleStatefulObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.utils.CommonUtils;

public class OracleUtils {
    private static final Log log = Log.getLog(OracleUtils.class);

    /*
     * Exception decompiling
     */
    public static String getDDL(DBRProgressMonitor monitor, String objectType, OracleTableBase object, OracleDDLFormat ddlFormat, Map<String, Object> options) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setCurrentSchema(JDBCSession session, String schema) throws SQLException {
        JDBCUtils.executeSQL((Connection)session, (String)("ALTER SESSION SET CURRENT_SCHEMA=" + DBUtils.getQuotedIdentifier((DBPDataSource)session.getDataSource(), (String)schema)), (Object[])new Object[0]);
    }

    public static String getCurrentSchema(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((JDBCSession)session, (String)"SELECT SYS_CONTEXT( 'USERENV', 'CURRENT_SCHEMA' ) FROM DUAL", (Object[])new Object[0]);
    }

    public static String normalizeSourceName(OracleSourceObject object, boolean body) {
        String objectName;
        String source;
        block5: {
            try {
                String string = source = body ? ((DBPScriptObjectExt)object).getExtendedDefinitionText(null) : object.getObjectDefinitionText(null, DBPScriptObject.EMPTY_OPTIONS);
                if (source != null) break block5;
                return null;
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
        }
        Pattern pattern = Pattern.compile((Object)((Object)object.getSourceType()) + (body ? "\\s+BODY" : "") + "\\s(\\s*)([\\w$\\.]+)[\\s\\(]+", 2);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find() && (objectName = matcher.group(2)).indexOf(46) == -1) {
            if (!objectName.equalsIgnoreCase(object.getName())) {
                object.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)object, (String)objectName));
                object.getDataSource().getContainer().fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)object));
            }
            return source;
        }
        return source.trim();
    }

    public static void addSchemaChangeActions(List<DBEPersistAction> actions, OracleSourceObject object) {
        actions.add(0, (DBEPersistAction)new SQLDatabasePersistAction("Set target schema", "ALTER SESSION SET CURRENT_SCHEMA=" + object.getSchema().getName(), DBEPersistAction.ActionType.INITIALIZER));
        if (object.getSchema() != object.getDataSource().getDefaultObject()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current schema", "ALTER SESSION SET CURRENT_SCHEMA=" + object.getDataSource().getDefaultObject().getName(), DBEPersistAction.ActionType.FINALIZER));
        }
    }

    public static String getSysSchemaPrefix(OracleDataSource dataSource) {
        boolean useSysView = CommonUtils.toBoolean((Object)dataSource.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-meta-use-sys-schema@"));
        if (useSysView) {
            return "SYS.";
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    public static String getSource(DBRProgressMonitor monitor, OracleSourceObject sourceObject, boolean body, boolean insertCreateReplace) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 12 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getSysUserViewName(DBRProgressMonitor monitor, OracleDataSource dataSource, String viewName) {
        String dbaView = "DBA_" + viewName;
        if (dataSource.isViewAvailable(monitor, "SYS", dbaView)) {
            return String.valueOf(OracleUtils.getSysSchemaPrefix(dataSource)) + dbaView;
        }
        return String.valueOf(OracleUtils.getSysSchemaPrefix(dataSource)) + "USER_" + viewName;
    }

    public static String getAdminAllViewPrefix(DBRProgressMonitor monitor, OracleDataSource dataSource, String viewName) {
        String dbaView;
        boolean useDBAView = CommonUtils.toBoolean((Object)dataSource.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-always-use-dba-views@"));
        if (useDBAView && dataSource.isViewAvailable(monitor, "SYS", dbaView = "DBA_" + viewName)) {
            return String.valueOf(OracleUtils.getSysSchemaPrefix(dataSource)) + dbaView;
        }
        return String.valueOf(OracleUtils.getSysSchemaPrefix(dataSource)) + "ALL_" + viewName;
    }

    public static String getSysCatalogHint(OracleDataSource dataSource) {
        return dataSource.isUseRuleHint() ? "/*+RULE*/" : "";
    }

    static <PARENT extends DBSObject> Object resolveLazyReference(DBRProgressMonitor monitor, PARENT parent, DBSObjectCache<PARENT, ?> cache, DBSObjectLazy<?> referrer, Object propertyId) throws DBException {
        Object reference = referrer.getLazyReference(propertyId);
        if (reference instanceof String) {
            DBSObject object = monitor != null ? cache.getObject(monitor, parent, (String)reference) : cache.getCachedObject((String)reference);
            if (object != null) {
                return object;
            }
            log.warn((Object)("Object '" + reference + "' not found"));
            return reference;
        }
        return reference;
    }

    /*
     * Exception decompiling
     */
    public static boolean getObjectStatus(DBRProgressMonitor monitor, OracleStatefulObject object, OracleObjectType objectType) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String insertCreateReplace(OracleSourceObject object, boolean body, String source) {
        Pattern srcPattern;
        Matcher matcher;
        String sourceType = object.getSourceType().name();
        if (body) {
            sourceType = String.valueOf(sourceType) + " BODY";
        }
        if ((matcher = (srcPattern = Pattern.compile("^(" + sourceType + ")\\s+(\"{0,1}\\w+\"{0,1})", 2)).matcher(source)).find()) {
            return "CREATE OR REPLACE " + matcher.group(1) + " " + DBUtils.getQuotedIdentifier((DBSObject)object.getSchema()) + "." + matcher.group(2) + source.substring(matcher.end());
        }
        return source;
    }

    public static String formatWord(String word) {
        if (word == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(word.length());
        sb.append(Character.toUpperCase(word.charAt(0)));
        int i = 1;
        while (i < word.length()) {
            char c = word.charAt(i);
            if ((c == 'i' || c == 'I') && sb.charAt(i - 1) == 'I') {
                sb.append('I');
            } else {
                sb.append(Character.toLowerCase(c));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String formatSentence(String sent) {
        if (sent == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(sent, " \t\n\r-,.\\/", true);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (word.length() <= 0) continue;
            result.append(OracleUtils.formatWord(word));
        }
        return result.toString();
    }
}

