/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUser;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class OracleSchemaManager
extends SQLObjectEditor<OracleSchema, OracleDataSource>
implements DBEObjectRenamer<OracleSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleSchema> getObjectsCache(OracleSchema object) {
        return object.getDataSource().schemaCache;
    }

    protected OracleSchema createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new OracleSchema((OracleDataSource)((Object)container), -1L, "NEW_SCHEMA");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        OracleUser user = ((OracleSchema)command.getObject()).getUser();
        String sql = "CREATE USER " + DBUtils.getQuotedIdentifier((DBSObject)user);
        if (!CommonUtils.isEmpty((String)user.getPassword())) {
            sql = String.valueOf(sql) + " IDENTIFIED BY \"" + user.getPassword() + "\"";
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create schema", sql));
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP USER " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " CASCADE"));
    }

    public void renameObject(DBECommandContext commandContext, OracleSchema schema, String newName) throws DBException {
        throw new DBException("Direct database rename is not yet implemented in Oracle. You should use export/import functions for that.");
    }
}

