/*
	lean and mean DAAP-lib
	a very simple test of the lib

	Copyright (c) deleet 2003, Alexander Oberdoerster & Johannes Zander
	http://deleet.de/projekte/daap/
*/


#include <stdio.h>
#include <string.h>
#include <ctype.h>

#if defined( _WIN32 ) && defined( _DEBUG )
	#include <conio.h>
#endif

#include <daap/basic.h>
#include <daap/tagoutput.h>
#include <daap/taginput.h>
#include <daap/registry.h>


	void dumpAscii( const u8* ptr, u32 max ) {
		for( u32 i=0; i<max; ++i ) putchar( isgraph( ptr[i] ) ? ptr[i] : '.' );
	}


	void hexDump( const Chunk& c ) {
		for( u32 i=0; i<c.size(); ++i ) {
			printf( "%02X %s", c[i], (i&3)!=3 ? "" : " " );
			if( (i&15)==15 ) {
				dumpAscii( c.begin()+i-15, 16 );
				if( i!=c.size()-1 ) putchar('\n');
			}
		}
		
		u32 rest = c.size()&15;
		if( rest>0 ) {
			for( u32 i=rest; i<16; ++i ) printf( "   %s", (i&3)!=3 ? "" : " " );
			dumpAscii( c.end()-rest, rest );
		}
	}

	void dumpTag( TagInput& in, int indent=0 ) {
		if( !in.isFinished()) {
			Tag tag;

			in >> tag;
				for( int i=0; i<indent; ++i ) printf( "\t" );
				printf("'%c%c%c%c': ",
					( tag.type>>24 )&0xff, ( tag.type>>16 )&0xff,
					( tag.type>>8 )&0xff,    tag.type&0xff );

				switch( tag.type ) {
				// container tags
				case 'mccr':
				case 'mdcl':
					printf("container\n");
					while( in.leftInTag()>0 )
						dumpTag( in, indent+1 );
					break;
				
				// data tags
				case 'mcnm': { Chunk       x; in >> x; printf("mnemonic '%c%c%c%c'\n", x[0],x[1],x[2],x[3] ); break; }
				case 'mcna': { std::string x; in >> x; printf("name     \"%s\"\n", x.c_str()); break;	}
				case 'mcty': { u16         x; in >> x; printf("type     0x%04X\n", x ); break; }

				// unknown
				default:     { Chunk       x; in >> x; printf("unknown\n"); hexDump( x ); printf("\n"); break; }
				}
			in >> end;
		}
	}


int main( int arc, char** argv ) {
	//////
	// easy test for tag output

	TagOutput out;
	u32       larifari = 42;
	
	out << Tag('blub') <<
		larifari <<
		Tag('1234') <<
			((u8)0xff) <<
		end <<
		Tag('hoho') <<
			"hossa!" <<
		end <<
		"ha!" <<
	end;
	
	hexDump( out.data());
	
	
	//////
	// easy test for tag input

	TagInput    in( out.data());
	Tag         tag0, tag1, tag2;
	u32         v1;
	u8          v2;
	std::string v3;
	Chunk       v4;

	in >> tag0 >>
		v1 >>
		tag1 >>
			v2 >>
		end >>
		tag2 >>
			TagInput::Skip( 1 ) >>
			v3 >>
		end >>
		v4 >>
	end;
		
	printf("\n\ncorrupted=%i, finished=%i, v1=%i, v2=%i, v3='%s', left=%i\n", in.isCorrupted(), in.isFinished(), v1, v2, v3.c_str(), in.leftInTag());
	hexDump( v4 );


	//////
	// easy test for the type registry
	
	printf( "\n\n" );

	#if 0
		FILE* file = fopen( "content-codes", "rb" );
		if( file ) {
			fseek( file, 0, SEEK_END );

			long size   = ftell( file );
			u8*  buffer = new u8[size];
			
			fseek( file, 0, SEEK_SET );
			if( fread( buffer, size, 1, file ))
				dumpTag( TagInput( Chunk( buffer, size )));

			delete[]buffer;
			fclose( file );
		}
	#else
		TagInput reg( TypeRegistry::getDictionary());
		dumpTag( reg );
	#endif


	#if defined( _WIN32 ) && defined( _DEBUG )
		_getch();
	#endif
	return( 0 );
}
