/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.text.MessageFormat;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class PServerConnection
extends AbstractConnection {
    protected static final String OPEN_PREAMBLE = "BEGIN AUTH REQUEST\n";
    protected static final String OPEN_POSTAMBLE = "END AUTH REQUEST\n";
    protected static final String VERIFY_PREAMBLE = "BEGIN VERIFICATION REQUEST\n";
    protected static final String VERIFY_POSTAMBLE = "END VERIFICATION REQUEST\n";
    protected static final String AUTHENTICATION_SUCCEEDED_RESPONSE = "I LOVE YOU";
    protected static final String AUTHENTICATION_FAILED_RESPONSE = "I HATE YOU";
    protected String userName;
    protected String encodedPassword;
    public static final int DEFAULT_PORT = 2401;
    protected int port = 2401;
    protected String hostName;
    protected Socket socket;

    public PServerConnection() {
    }

    public PServerConnection(CVSRoot cvsRoot) {
        if (!"pserver".equals(cvsRoot.getMethod())) {
            throw new IllegalArgumentException("CVS Root '" + cvsRoot + "' does not represent :pserver: connection type.");
        }
        String userName = cvsRoot.getUserName();
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        this.setUserName(userName);
        String password = cvsRoot.getPassword();
        if (password != null) {
            this.setEncodedPassword(StandardScrambler.getInstance().scramble(password));
        }
        this.setHostName(cvsRoot.getHostName());
        this.setRepository(cvsRoot.getRepository());
        int port = cvsRoot.getPort();
        if (port == 0) {
            port = 2401;
        }
        this.setPort(port);
    }

    private void openConnection(String preamble, String postamble) throws AuthenticationException, CommandAbortedException {
        if (this.hostName == null) {
            String locMessage = AuthenticationException.getBundleString("AuthenticationException.HostIsNull");
            throw new AuthenticationException("HostIsNull", locMessage);
        }
        try {
            this.socket = new Socket(this.hostName, this.port);
            BufferedOutputStream bos = new BufferedOutputStream(this.socket.getOutputStream(), 32768);
            LoggedDataOutputStream outputStream = new LoggedDataOutputStream(bos);
            this.setOutputStream(outputStream);
            BufferedInputStream bis = new BufferedInputStream(this.socket.getInputStream(), 32768);
            LoggedDataInputStream inputStream = new LoggedDataInputStream(bis);
            this.setInputStream(inputStream);
            outputStream.writeBytes(preamble);
            outputStream.writeBytes(this.getRepository() + "\n");
            outputStream.writeBytes(this.userName + "\n");
            outputStream.writeBytes(this.getEncodedPasswordNotNull() + "\n");
            outputStream.writeBytes(postamble);
            outputStream.flush();
            if (Thread.interrupted()) {
                this.reset();
                String localMsg = CommandException.getLocalMessage("Client.connectionAborted", null);
                throw new CommandAbortedException("Aborted during connecting to the server.", localMsg);
            }
            String response = inputStream.readLine();
            if (Thread.interrupted()) {
                this.reset();
                String localMsg = CommandException.getLocalMessage("Client.connectionAborted", null);
                throw new CommandAbortedException("Aborted during connecting to the server.", localMsg);
            }
            if (AUTHENTICATION_SUCCEEDED_RESPONSE.equals(response)) {
                return;
            }
            if (AUTHENTICATION_FAILED_RESPONSE.equals(response)) {
                String localizedMsg = this.getLocalMessage("AuthenticationException.badPassword", null);
                throw new AuthenticationException("AuthenticationFailed", localizedMsg);
            }
            if (response == null) {
                response = "";
            }
            String locMessage = this.getLocalMessage("AuthenticationException.AuthenticationFailed", new Object[]{response});
            throw new AuthenticationException("AuthenticationFailed", locMessage);
        }
        catch (AuthenticationException ex) {
            this.reset();
            throw ex;
        }
        catch (ConnectException ex) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.ConnectException", new Object[]{this.hostName, new Integer(this.port)});
            throw new AuthenticationException("ConnectException", ex, locMessage);
        }
        catch (NoRouteToHostException ex) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.NoRouteToHostException", new Object[]{this.hostName});
            throw new AuthenticationException("NoRouteToHostException", ex, locMessage);
        }
        catch (IOException ex) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.IOException", new Object[]{this.hostName});
            throw new AuthenticationException("IOException", ex, locMessage);
        }
    }

    private void reset() {
        this.socket = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    public void verify() throws AuthenticationException {
        try {
            this.openConnection(VERIFY_PREAMBLE, VERIFY_POSTAMBLE);
        }
        catch (CommandAbortedException caex) {
            // empty catch block
        }
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException exc) {
            String locMessage = AuthenticationException.getBundleString("AuthenticationException.Throwable");
            throw new AuthenticationException("General error", exc, locMessage);
        }
        finally {
            this.reset();
        }
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        this.openConnection(OPEN_PREAMBLE, OPEN_POSTAMBLE);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    private String getEncodedPasswordNotNull() {
        if (this.encodedPassword == null) {
            return StandardScrambler.getInstance().scramble("");
        }
        return this.encodedPassword;
    }

    public void setEncodedPassword(String encodedPassword) {
        this.encodedPassword = encodedPassword;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.socket.close();
        }
        finally {
            this.reset();
        }
    }

    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(this.getOutputStream());
    }

    private String getLocalMessage(String key, Object[] arguments) {
        String locMessage = AuthenticationException.getBundleString(key);
        if (locMessage == null) {
            return null;
        }
        locMessage = MessageFormat.format(locMessage, arguments);
        return locMessage;
    }

    public boolean isOpen() {
        return this.socket != null;
    }
}

