/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.commit;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.commit.CommitInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class CommitBuilder
implements Builder {
    public static final String UNKNOWN = "commit: nothing known about `";
    public static final String EXAM_DIR = ": Examining";
    public static final String CHECKING_IN = "Checking in ";
    public static final String REMOVING = "Removing ";
    public static final String NEW_REVISION = "new revision:";
    public static final String INITIAL_REVISION = "initial revision:";
    public static final String DONE = "done";
    public static final String RCS_FILE = "RCS file: ";
    public static final String ADD = "commit: use `cvs add' to create an entry for ";
    private CommitInformation commitInformation;
    private String fileDirectory;
    private final EventManager eventManager;
    private final String localPath;
    private boolean isAdding;

    public CommitBuilder(EventManager eventManager, String localPath) {
        this.eventManager = eventManager;
        this.localPath = localPath;
    }

    public void outputDone() {
        if (this.commitInformation != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.commitInformation));
            this.commitInformation = null;
        }
    }

    public void parseLine(String line, boolean isErrorMessage) {
        if (line.indexOf(UNKNOWN) >= 0) {
            this.processUnknownFile(line.substring(line.indexOf(UNKNOWN) + UNKNOWN.length()).trim());
        } else if (line.indexOf(ADD) > 0) {
            this.processToAddFile(line.substring(line.indexOf(ADD) + ADD.length()).trim());
        } else if (line.startsWith(CHECKING_IN)) {
            this.processFile(line.substring(CHECKING_IN.length(), line.length() - 1));
            if (this.isAdding) {
                this.commitInformation.setType("Added");
                this.isAdding = false;
            } else {
                this.commitInformation.setType("Changed");
            }
        } else if (line.startsWith(REMOVING)) {
            this.processFile(line.substring(REMOVING.length(), line.length() - 1));
            this.commitInformation.setType("Removed");
        } else if (line.indexOf(EXAM_DIR) >= 0) {
            this.fileDirectory = line.substring(line.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim();
        } else if (line.startsWith(RCS_FILE)) {
            this.isAdding = true;
        } else if (line.startsWith(DONE)) {
            this.outputDone();
        } else if (line.startsWith(INITIAL_REVISION)) {
            this.processRevision(line.substring(INITIAL_REVISION.length()));
        } else if (line.startsWith(NEW_REVISION)) {
            this.processRevision(line.substring(NEW_REVISION.length()));
        }
    }

    private File createFile(String fileName) {
        return new File(this.localPath, fileName);
    }

    private void processUnknownFile(String line) {
        this.commitInformation = new CommitInformation();
        this.commitInformation.setType("Unknown");
        int index = line.indexOf(39);
        String fileName = line.substring(0, index - 1).trim();
        this.commitInformation.setFile(this.createFile(fileName));
        this.outputDone();
    }

    private void processToAddFile(String line) {
        this.commitInformation = new CommitInformation();
        this.commitInformation.setType("To-be-added");
        String fileName = line.trim();
        if (fileName.endsWith(";")) {
            fileName = fileName.substring(0, fileName.length() - 2);
        }
        this.commitInformation.setFile(this.createFile(fileName));
        this.outputDone();
    }

    private void processFile(String filename) {
        if (this.commitInformation == null) {
            this.commitInformation = new CommitInformation();
        }
        if (filename.startsWith("no file")) {
            filename = filename.substring(8);
        }
        this.commitInformation.setFile(this.createFile(filename));
    }

    private void processRevision(String revision) {
        int index = revision.indexOf(59);
        if (index >= 0) {
            revision = revision.substring(0, index);
        }
        this.commitInformation.setRevision(revision.trim());
    }

    public void parseEnhancedMessage(String key, Object value) {
    }
}

