/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.response.ErrorResponse;

public abstract class Command
implements CVSListener,
Cloneable {
    protected String localDirectory;
    private GlobalOptions globalOptions;
    private boolean failed = false;

    public void execute(ClientServices client, EventManager eventManager) throws CommandException, CommandAbortedException, AuthenticationException {
        this.setLocalDirectory(client.getLocalPath());
        this.globalOptions = client.getGlobalOptions();
    }

    public abstract String getCVSCommand();

    public abstract String getCVSArguments();

    public abstract boolean setCVSCommand(char var1, String var2);

    public abstract void resetCVSCommand();

    public abstract String getOptString();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public void messageSent(MessageEvent e) {
        if (e.isError() && e.getSource() instanceof ErrorResponse) {
            this.failed = true;
        }
    }

    public void fileAdded(FileAddedEvent e) {
    }

    public void fileRemoved(FileRemovedEvent e) {
    }

    public void fileUpdated(FileUpdatedEvent e) {
    }

    public void fileInfoGenerated(FileInfoEvent e) {
    }

    public void commandTerminated(TerminationEvent e) {
    }

    public void moduleExpanded(ModuleExpansionEvent e) {
    }

    public final String getLocalDirectory() {
        return this.localDirectory;
    }

    public final String getLocalPath() {
        return this.localDirectory;
    }

    public final GlobalOptions getGlobalOptions() {
        return this.globalOptions;
    }

    public final String getRelativeToLocalPathInUnixStyle(File file) {
        String filePath = file.getAbsolutePath();
        int startIndex = this.localDirectory.length() + 1;
        if (startIndex >= filePath.length()) {
            return ".";
        }
        String relativePath = filePath.substring(startIndex);
        return relativePath.replace('\\', '/');
    }

    protected final void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    protected static final String getTrimmedString(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }
}

