/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff.print;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.myers.MyersDiff;
import org.apache.commons.jrcs.diff.print.BasePrint;

public class UnifiedPrint
extends BasePrint {
    private int nbContextLines = 3;
    private Object[] original;
    private Object[] revision;
    private Stack changeBlocks = new Stack();

    public UnifiedPrint(StringBuffer sb, Object[] original, Object[] revision) {
        super(sb);
        this.original = original;
        this.revision = revision;
    }

    public void close() {
        if (this.changeBlocks.isEmpty()) {
            return;
        }
        ChangeBlock lastChangeBlock = (ChangeBlock)this.changeBlocks.peek();
        if (lastChangeBlock != null) {
            lastChangeBlock.fillEndBlock();
        }
        Iterator i = this.changeBlocks.iterator();
        while (i.hasNext()) {
            ChangeBlock changeBlock = (ChangeBlock)i.next();
            changeBlock.print(this.getStringBuffer());
        }
    }

    public int getNbContextLines() {
        return this.nbContextLines;
    }

    public void setNbContextLines(int nbContextLines) {
        this.nbContextLines = nbContextLines;
    }

    protected void printHeader() {
        if (this.getFileName() == null) {
            return;
        }
        StringBuffer sb = this.getStringBuffer();
        sb.append("Index: ");
        sb.append(this.getFileName());
        sb.append(this.getEOL());
        sb.append("===================================================================");
        sb.append(this.getEOL());
        sb.append("RCS File: ");
        sb.append(this.getRCSFileName());
        sb.append(this.getEOL());
        if (this.getOriginalVersion() != null) {
            sb.append("retrieving revision ");
            sb.append(this.getOriginalVersion());
            sb.append(this.getEOL());
        }
        if (this.getRevisedVersion() != null) {
            sb.append("retrieving revision ");
            sb.append(this.getRevisedVersion());
            sb.append(this.getEOL());
        }
        sb.append("diff -u");
        if (this.getOriginalVersion() != null) {
            sb.append(" -r");
            sb.append(this.getOriginalVersion());
        }
        if (this.getRevisedVersion() != null) {
            sb.append(" -r");
            sb.append(this.getRevisedVersion());
        }
        sb.append(" ");
        String shortFileName = this.getFileName();
        int pos = shortFileName.lastIndexOf(47);
        if (pos >= 0) {
            shortFileName = shortFileName.substring(pos + 1);
        }
        sb.append(shortFileName);
        sb.append(this.getEOL());
        SimpleDateFormat df = new SimpleDateFormat("d MMM yyyy HH:mm:ss -0000", Locale.US);
        sb.append("--- ");
        sb.append(this.getFileName());
        if (this.getOriginalModifDate() != null) {
            sb.append('\t');
            sb.append(df.format(this.getOriginalModifDate()));
            if (this.getOriginalVersion() != null) {
                sb.append('\t');
                sb.append(this.getOriginalVersion());
            }
        }
        sb.append(this.getEOL());
        sb.append("+++ ");
        sb.append(this.getFileName());
        if (this.getRevisedModifDate() != null) {
            sb.append('\t');
            sb.append(df.format(this.getRevisedModifDate()));
            if (this.getRevisedVersion() != null) {
                sb.append('\t');
                sb.append(this.getRevisedVersion());
            }
        }
        sb.append(this.getEOL());
    }

    public void visit(AddDelta delta) {
        super.visit(delta);
        ChangeBlock lastChangeBlock = this.getLastChangeBlock(delta);
        lastChangeBlock.addChange(delta);
    }

    public void visit(ChangeDelta delta) {
        super.visit(delta);
        ChangeBlock lastChangeBlock = this.getLastChangeBlock(delta);
        lastChangeBlock.addChange(delta);
    }

    public void visit(DeleteDelta delta) {
        super.visit(delta);
        ChangeBlock lastChangeBlock = this.getLastChangeBlock(delta);
        lastChangeBlock.addChange(delta);
    }

    protected Object[] getOriginal() {
        return this.original;
    }

    protected Object[] getRevision() {
        return this.revision;
    }

    private ChangeBlock getLastChangeBlock(Delta delta) {
        ChangeBlock lastChangeBlock = null;
        if (!this.changeBlocks.isEmpty()) {
            lastChangeBlock = (ChangeBlock)this.changeBlocks.peek();
        }
        if (lastChangeBlock == null || lastChangeBlock.getLastChangedLine() < delta.getOriginal().anchor() - this.getNbContextLines() * 2) {
            if (lastChangeBlock != null) {
                lastChangeBlock.fillEndBlock();
            }
            lastChangeBlock = new ChangeBlock();
            this.changeBlocks.add(lastChangeBlock);
        }
        return lastChangeBlock;
    }

    private static final String[] loadFile(String name) throws IOException {
        String s;
        BufferedReader data = new BufferedReader(new FileReader(name));
        ArrayList<String> lines = new ArrayList<String>();
        while ((s = data.readLine()) != null) {
            lines.add(s);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static void main(String[] args) {
        try {
            Object[] s1 = UnifiedPrint.loadFile("c:/dev/CVSGrabTask.1.6.java");
            Object[] s2 = UnifiedPrint.loadFile("c:/dev/CVSGrabTask.1.7.java");
            MyersDiff diff2 = new MyersDiff();
            Revision revision = diff2.diff(s1, s2);
            StringBuffer sb = new StringBuffer();
            UnifiedPrint print = new UnifiedPrint(sb, s1, s2);
            print.setFileName("src/java/net/sourceforge/cvsgrab/CVSGrabTask.java");
            print.setRCSFileName("/cvsroot/cvsgrab/cvsgrab/src/java/net/sourceforge/cvsgrab/CVSGrabTask.java,v");
            SimpleDateFormat df = new SimpleDateFormat("d MMM yyyy HH:mm:ss", Locale.US);
            print.setOriginalModifDate(df.parse("31 Oct 2003 00:26:54"));
            print.setOriginalVersion("1.6");
            print.setRevisedModifDate(df.parse("31 Jan 2004 17:37:47"));
            revision.accept(print);
            print.close();
            System.out.println(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ChangeBlock {
        private List deltas = new ArrayList();
        private List changes = new ArrayList();
        private int origNbLines = 0;
        private int revNbLines = 0;
        private int startOrig = 0;
        private int startRev = 0;

        private ChangeBlock() {
        }

        public int getLastChangedLine() {
            Delta delta = (Delta)this.deltas.get(this.deltas.size() - 1);
            return delta.getOriginal().last();
        }

        public void addChange(AddDelta delta) {
            this.initChangesBefore(delta);
            this.deltas.add(delta);
            for (int l = delta.getRevised().first(); l <= delta.getRevised().last(); ++l) {
                this.changes.add("+" + UnifiedPrint.this.getRevision()[l]);
                ++this.revNbLines;
            }
        }

        public void addChange(DeleteDelta delta) {
            this.initChangesBefore(delta);
            this.deltas.add(delta);
            for (int l = delta.getOriginal().first(); l <= delta.getOriginal().last(); ++l) {
                this.changes.add("-" + UnifiedPrint.this.getOriginal()[l]);
                ++this.origNbLines;
            }
        }

        public void addChange(ChangeDelta delta) {
            int l;
            this.initChangesBefore(delta);
            this.deltas.add(delta);
            for (l = delta.getOriginal().first(); l <= delta.getOriginal().last(); ++l) {
                this.changes.add("-" + UnifiedPrint.this.getOriginal()[l]);
                ++this.origNbLines;
            }
            for (l = delta.getRevised().first(); l <= delta.getRevised().last(); ++l) {
                this.changes.add("+" + UnifiedPrint.this.getRevision()[l]);
                ++this.revNbLines;
            }
        }

        public void print(StringBuffer sb) {
            sb.append("@@ -");
            sb.append(this.startOrig);
            sb.append(",");
            sb.append(this.origNbLines);
            sb.append(" +");
            sb.append(this.startRev);
            sb.append(",");
            sb.append(this.revNbLines);
            sb.append(" @@");
            sb.append(UnifiedPrint.this.getEOL());
            Iterator i = this.changes.iterator();
            while (i.hasNext()) {
                String line = (String)i.next();
                sb.append(line);
                sb.append(UnifiedPrint.this.getEOL());
            }
        }

        public void fillEndBlock() {
            Delta lastDelta = (Delta)this.deltas.get(this.deltas.size() - 1);
            int l = lastDelta.getOriginal().last();
            for (int i = l + 1; i <= l + UnifiedPrint.this.getNbContextLines() && i < UnifiedPrint.this.getOriginal().length; ++i) {
                this.changes.add(" " + UnifiedPrint.this.getOriginal()[i]);
                ++this.origNbLines;
                ++this.revNbLines;
            }
        }

        private void initChangesBefore(Delta delta) {
            int border;
            int anchor = delta.getOriginal().anchor();
            int lastChange = 0;
            boolean firstChange = this.changes.isEmpty();
            int n = border = firstChange ? UnifiedPrint.this.getNbContextLines() : UnifiedPrint.this.getNbContextLines() * 2;
            if (firstChange) {
                this.startOrig = delta.getOriginal().rcsfrom();
                this.startRev = delta.getRevised().rcsfrom();
            } else {
                Delta previousDelta = (Delta)this.deltas.get(this.deltas.size() - 1);
                lastChange = previousDelta.getOriginal().last();
            }
            for (int i = border; i > 0; --i) {
                if (anchor - i <= lastChange || anchor < i) continue;
                this.changes.add(" " + UnifiedPrint.this.getOriginal()[anchor - i]);
                ++this.origNbLines;
                ++this.revNbLines;
                if (!firstChange) continue;
                --this.startOrig;
                --this.startRev;
            }
        }
    }
}

