/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.web;

import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.InvalidVersionException;
import net.sourceforge.cvsgrab.MarkerNotFoundException;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.web.ViewCvsInterface;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Document;

public class ViewVC1_0Interface
extends ViewCvsInterface {
    private String _root;

    public ViewVC1_0Interface(CVSGrab grabber) {
        super(grabber);
        this.setWebInterfaceType("viewvc");
        this.setFileVersionXpath("TD/A/STRONG");
        this.setFilesXpath("//TR[TD/A/IMG/@alt = '(file)' or contains(TD/A/IMG/@src, 'text')]");
        this.setDirectoriesXpath("//TR[TD/A/IMG/@alt = '(dir)' or contains(TD/A/IMG/@src, 'dir')][TD/A/@name != 'Attic']");
        this.setTagParam("pathrev");
    }

    public void detect(Document htmlPage) throws MarkerNotFoundException, InvalidVersionException {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        Iterator viewCvsTexts = context.iterate("//META[@name = 'generator']/@content[starts-with(.,'ViewVC')] | //A[@href]/text()[starts-with(.,'ViewVC')]");
        this.setType(null);
        String viewCvsVersion = null;
        while (viewCvsTexts.hasNext()) {
            viewCvsVersion = (String)viewCvsTexts.next();
            if (!viewCvsVersion.startsWith(this.getVersionMarker())) continue;
            this.setType(viewCvsVersion);
            break;
        }
        if (this.getType() == null) {
            throw new MarkerNotFoundException("Expected marker " + this.getVersionMarker() + ", found " + viewCvsVersion);
        }
        if (this._root == null) {
            context.setLenient(true);
            String strong = (String)context.getValue("//STRONG");
            if (strong == null) {
                CVSGrab.getLog().info("CVS Root not found, there may be issues if ViewCvs is used with multiple repositories");
                CVSGrab.getLog().info("Use the parameter -projectRoot <root> to remove this warning");
            } else {
                int start = strong.indexOf(91) + 1;
                int end = strong.indexOf(93);
                this._root = strong.substring(start, end);
            }
        }
    }

    public String getDirectoryUrl(String rootUrl, String directoryName) {
        try {
            String tag2 = this.getVersionTag();
            String url = WebBrowser.forceFinalSlash(rootUrl);
            if (this.getRoot() != null) {
                url = url + WebBrowser.forceFinalSlash(this.quote(this.getRoot()));
            }
            url = url + WebBrowser.forceFinalSlash(this.quote(directoryName));
            url = WebBrowser.addQueryParam(url, this.getTagParam(), tag2);
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public String getDownloadUrl(RemoteFile file) {
        try {
            String url = WebBrowser.forceFinalSlash(file.getDirectory().getRemoteRepository().getRootUrl());
            String dir = file.getDirectory().getDirectoryPath();
            url = url + this.getCheckoutPath();
            if (this.getRoot() != null) {
                url = url + WebBrowser.forceFinalSlash(this.quote(this.getRoot()));
            }
            url = url + WebBrowser.forceFinalSlash(this.quote(dir));
            url = url + this.quote(file.getName());
            url = WebBrowser.addQueryParam(url, "revision", file.getVersion());
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public Properties guessWebProperties(String url) {
        if (url.toLowerCase().indexOf(".cvs.sourceforge.net") > 0) {
            return this.guessSourceforgeWebProperties(url);
        }
        return this.guessGenericWebProperties(url);
    }

    protected Properties guessGenericWebProperties(String url) {
        return super.guessWebProperties(url);
    }

    private Properties guessSourceforgeWebProperties(String url) {
        int endOfHostPosition = url.toLowerCase().indexOf(".cvs.sourceforge.net") + ".cvs.sourceforge.net".length();
        int rootUrlPosition = url.indexOf(47, endOfHostPosition) + 1;
        int projectRootEndPosition = url.indexOf(47, rootUrlPosition);
        int nextSlashPos = projectRootEndPosition + 1;
        String guessedRootUrl = url.substring(0, rootUrlPosition);
        String guessedProjectPath = url.substring(rootUrlPosition, projectRootEndPosition);
        String guessedPackagePath = url.substring(nextSlashPos);
        String versionTag = null;
        String query = null;
        int queryPos = guessedPackagePath.indexOf(63);
        if (queryPos >= 0) {
            query = guessedPackagePath.substring(queryPos + 1);
            guessedPackagePath = guessedPackagePath.substring(0, queryPos);
            Properties queryItems = WebBrowser.getQueryParams(query);
            versionTag = (String)queryItems.remove(this.getTagParam());
            query = WebBrowser.toQueryParams(queryItems);
        }
        Properties properties = new Properties();
        properties.put("rootUrl", guessedRootUrl);
        properties.put("projectRoot", guessedProjectPath);
        properties.put("packagePath", guessedPackagePath);
        if (versionTag != null && versionTag.trim().length() > 0) {
            properties.put("tag", versionTag);
        }
        if (query != null && query.trim().length() > 0) {
            properties.put("queryParams", query);
        }
        return properties;
    }

    public String getRoot() {
        if (this._root == null) {
            this.setRoot(this.getGrabber().getProjectRoot());
        }
        return this._root;
    }

    public void setRoot(String root) {
        this._root = root;
    }

    protected String getVersionMarker() {
        return "ViewVC 1.0";
    }
}

