/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.web;

import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.InvalidVersionException;
import net.sourceforge.cvsgrab.MarkerNotFoundException;
import net.sourceforge.cvsgrab.web.ViewCvsInterface;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Document;

public class Sourcecast3_0Interface
extends ViewCvsInterface {
    public Sourcecast3_0Interface(CVSGrab grabber) {
        super(grabber);
        this.setFilesXpath("//TABLE[@class = 'filebrowse']//TD/DIV[@class = 'leaf']");
        this.setFileNameXpath("@id");
        this.setFileVersionXpath("../following::node()/text()");
        this.setDirectoriesXpath("//TABLE[@class = 'filebrowse']//TD/DIV[@class = 'leafnode'][@id != 'Attic']");
        this.setDirectoryXpath("@id");
        this.setWebInterfaceType("browse");
    }

    public boolean presetMatch(String rootUrl, String packagePath) {
        if (rootUrl.indexOf("dev.java.net") > 0) {
            this.setType("SourceCast 3.0 on dev.java.net");
            return true;
        }
        return false;
    }

    public void detect(Document htmlPage) throws MarkerNotFoundException, InvalidVersionException {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        context.setLenient(true);
        String keywords = (String)context.getValue("//META[@name = 'keywords']/@content");
        String description = (String)context.getValue("//META[@name = 'description']/@content");
        String version = (String)context.getValue("//META[@name = 'version']/@content");
        if (version == null) {
            version = (String)context.getValue("//META[@name = 'SourceCastVersion']/@content");
        }
        if (version == null) {
            throw new InvalidVersionException("Invalid version " + version);
        }
        boolean sourcecastKeyword = false;
        boolean collabnetKeyword = false;
        boolean poweredByCollabnet = false;
        if (keywords != null) {
            sourcecastKeyword = keywords.toLowerCase().indexOf("sourcecast") >= 0;
            boolean bl = collabnetKeyword = keywords.toLowerCase().indexOf("collabnet") >= 0;
        }
        if (description != null) {
            sourcecastKeyword |= description.toLowerCase().indexOf("sourcecast") >= 0;
            collabnetKeyword |= description.toLowerCase().indexOf("collabnet") >= 0;
        }
        if (!sourcecastKeyword && !collabnetKeyword && version != null) {
            boolean bl = poweredByCollabnet = context.getValue("//A[contains(@href, 'www.collab.net')][IMG/@id='poweredby']") != null;
        }
        if (!(sourcecastKeyword || collabnetKeyword || poweredByCollabnet)) {
            CVSGrab.getLog().warn("Might not be SourceCast/CollabNet, meta keywords was '" + keywords + "', description was '" + description + "'");
        }
        if (version != null && version.startsWith("2.")) {
            int minorVersion = Integer.parseInt(version.substring(2, version.indexOf(46, 2)));
            if (minorVersion < 6) {
                throw new InvalidVersionException("Version 2.5 and earlier are not supported");
            }
        } else if (version == null || !version.startsWith("3.")) {
            throw new InvalidVersionException("Invalid version " + version);
        }
        this.setType("SourceCast " + version);
    }

    protected String getVersionMarker() {
        return null;
    }
}

