/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.web;

import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.InvalidVersionException;
import net.sourceforge.cvsgrab.MarkerNotFoundException;
import net.sourceforge.cvsgrab.web.ViewCvsInterface;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Document;

public class Sourcecast2_0Interface
extends ViewCvsInterface {
    public Sourcecast2_0Interface(CVSGrab grabber) {
        super(grabber);
        this.setWebInterfaceType("browse");
    }

    public void detect(Document htmlPage) throws MarkerNotFoundException, InvalidVersionException {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        context.setLenient(true);
        String keywords = (String)context.getValue("//META[@name = 'keywords']/@content");
        String description = (String)context.getValue("//META[@name = 'description']/@content");
        String version = (String)context.getValue("//META[@name = 'version']/@content");
        if (version == null) {
            version = (String)context.getValue("//META[@name = 'SourceCastVersion']/@content");
        }
        boolean sourcecastKeyword = false;
        boolean collabnetKeyword = false;
        if (keywords != null) {
            sourcecastKeyword = keywords.toLowerCase().indexOf("sourcecast") >= 0;
            boolean bl = collabnetKeyword = keywords.toLowerCase().indexOf("collabnet") >= 0;
        }
        if (description != null) {
            sourcecastKeyword |= description.toLowerCase().indexOf("sourcecast") >= 0;
            collabnetKeyword |= description.toLowerCase().indexOf("collabnet") >= 0;
        }
        if (!sourcecastKeyword && !collabnetKeyword) {
            throw new MarkerNotFoundException("Not SourceCast/CollabNet, meta keywords was '" + keywords + "', description was '" + description + "'");
        }
        if (version == null || !version.startsWith("2.")) {
            throw new InvalidVersionException("Invalid version " + version);
        }
        int minorVersion = Integer.parseInt(version.substring(2, version.indexOf(46, 2)));
        if (minorVersion >= 6) {
            throw new InvalidVersionException("Version 2.6 and later are not supported, as they are similar to version 3.0");
        }
        this.setType("SourceCast " + version);
    }

    protected String getVersionMarker() {
        return null;
    }
}

