/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.InvalidVersionException;
import net.sourceforge.cvsgrab.MarkerNotFoundException;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.web.ViewCvsInterface;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.w3c.dom.Document;

public class FishEye1_0Interface
extends ViewCvsInterface {
    public FishEye1_0Interface(CVSGrab grabber) {
        super(grabber);
        this.setFilesXpath("//TABLE[@id='fileTable']//TR[@class='ftFileRow' or @class='ftFileRowDeleted']");
        this.setFileNameXpath("TD/A[@class='ftFileName']/text()");
        this.setFileVersionXpath("TD/A[@class='ftRev'][@title='view' or @title='history' or @title='download']/text()");
        this.setDirectoriesXpath("//DIV[@class='dirPane']/UL/LI/SPAN[@class='folder'][A/SPAN/@class='folderPlain' or A/SPAN/@class='folderEmpty']");
        this.setDirectoryXpath("A/SPAN[@class='folderPlain' or @class='folderEmpty']/text()");
        this.setWebInterfaceType("viewrep");
    }

    public void detect(Document htmlPage) throws MarkerNotFoundException, InvalidVersionException {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        context.setLenient(false);
        context.getValue("//DIV[@id='footer']//A[starts-with(@href,'http://www.cenqua.com/fisheye/')]");
        String type = "FishEye";
        context.setLenient(true);
        String version = (String)context.getValue("//DIV[@id='footer']/P[A/@href='http://www.cenqua.com/fisheye/']/text()");
        if (version == null) {
            version = (String)context.getValue("//DIV[@id='footer']/text()[string-length(.) > 0]");
        }
        if (version == null) {
            version = "Unknown version";
        }
        this.setType(type + " " + version);
    }

    public String getDirectoryUrl(String rootUrl, String directoryName) {
        try {
            String url = WebBrowser.forceFinalSlash(rootUrl);
            if (this.getVersionTag() != null) {
                url = url + "~br=" + this.getVersionTag() + "/";
            }
            url = url + WebBrowser.forceFinalSlash(this.quote(directoryName));
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public String[] getDirectories(Document htmlPage) {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        ArrayList<String> directories = new ArrayList<String>();
        Iterator i = context.iteratePointers(this.getDirectoriesXpath());
        while (i.hasNext()) {
            Pointer pointer = (Pointer)i.next();
            JXPathContext nodeContext = context.getRelativeContext(pointer);
            String dir = (String)nodeContext.getValue(this.getDirectoryXpath());
            dir = WebBrowser.removeFinalSlash(dir);
            dir = dir.substring(dir.lastIndexOf(47) + 1);
            directories.add(dir);
        }
        return directories.toArray(new String[directories.size()]);
    }

    public String getDownloadUrl(RemoteFile file) {
        try {
            String url = WebBrowser.forceFinalSlash(file.getDirectory().getRemoteRepository().getRootUrl());
            url = url + "~raw,r=" + file.getVersion();
            url = WebBrowser.forceFinalSlash(url);
            String dir = file.getDirectory().getDirectoryPath();
            url = url + WebBrowser.forceFinalSlash(this.quote(dir));
            url = url + this.quote(file.getName());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public Properties guessWebProperties(String url) {
        Properties properties = new Properties();
        int keywordPosition = url.toLowerCase().indexOf(this.getWebInterfaceType());
        if (keywordPosition > 0) {
            int queryPos;
            int rootUrlPosition;
            String versionTag = null;
            String query = null;
            int startPackagePath = rootUrlPosition = url.indexOf(47, keywordPosition) + 1;
            if ('~' == url.charAt(rootUrlPosition)) {
                startPackagePath = url.indexOf(47, rootUrlPosition) + 1;
                int eqPos = url.indexOf(61, rootUrlPosition);
                if ("br".equals(url.substring(rootUrlPosition + 1, eqPos))) {
                    int endVersionTag = startPackagePath - 1;
                    int commaPos = url.indexOf(44, eqPos);
                    if (commaPos > 0) {
                        endVersionTag = commaPos;
                    }
                    versionTag = url.substring(eqPos + 1, endVersionTag);
                }
            }
            String guessedRootUrl = url.substring(0, rootUrlPosition);
            String guessedPackagePath = url.substring(startPackagePath);
            properties.put("rootUrl", guessedRootUrl);
            properties.put("packagePath", guessedPackagePath);
            if (versionTag != null && versionTag.trim().length() > 0) {
                properties.put("tag", versionTag);
            }
            if ((queryPos = guessedPackagePath.indexOf(63)) >= 0) {
                query = guessedPackagePath.substring(queryPos + 1);
                guessedPackagePath = guessedPackagePath.substring(0, queryPos);
            } else {
                query = "hideDeletedFiles=Y";
            }
            properties.put("rootUrl", guessedRootUrl);
            properties.put("packagePath", guessedPackagePath);
            if (versionTag != null && versionTag.trim().length() > 0) {
                properties.put("tag", versionTag);
            }
            if (query != null && query.trim().length() > 0) {
                properties.put("queryParams", query);
            }
        }
        return properties;
    }

    protected String quote(String original) throws URIException {
        return URIUtil.encodePath(original, "ISO-8859-1");
    }

    protected String getVersionMarker() {
        return null;
    }

    protected void adjustFile(RemoteFile file, JXPathContext nodeContext) {
        if ("ftFileRowDeleted".equals(nodeContext.getValue("@class"))) {
            file.setInAttic(true);
        }
    }
}

