/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.InvalidVersionException;
import net.sourceforge.cvsgrab.MarkerNotFoundException;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.web.ViewCvsInterface;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.w3c.dom.Document;

public class Chora2_0Interface
extends ViewCvsInterface {
    private String _browsePath = "cvs.php";

    public Chora2_0Interface(CVSGrab grabber) {
        super(grabber);
        this.setFilesXpath("//TR[TD/A/IMG/@alt = 'File']");
        this.setFileNameXpath("TD[1]/A/@href");
        this.setFileVersionXpath("TD[2]/B/A");
        this.setDirectoriesXpath("//TR[TD/A/IMG/@alt = 'Directory']");
        this.setDirectoryXpath("TD[1]/A/@href");
        this.setCheckoutPath("co.php");
        this.setWebInterfaceType("cvs.php/");
    }

    protected String getBrowsePath() {
        return this._browsePath;
    }

    protected void setBrowsePath(String browsePath) {
        this._browsePath = browsePath;
    }

    public void detect(Document htmlPage) throws MarkerNotFoundException, InvalidVersionException {
        String rootUrl = WebBrowser.removeFinalSlash(this.getGrabber().getRootUrl());
        if (!rootUrl.endsWith(this.getBrowsePath())) {
            throw new MarkerNotFoundException("Root url should end with " + this.getBrowsePath());
        }
        JXPathContext context = JXPathContext.newContext(htmlPage);
        String type = (String)context.getValue("//IMG[contains(@src,'chora.gif')]");
        if (type == null) {
            throw new MarkerNotFoundException("Expected marker 'chora.gif', found none");
        }
        this.setType("Chora 2.x");
        if (this.getGrabber().getVersionTag() != null) {
            throw new InvalidVersionException("Chora 2.0 doesn't support version tags");
        }
    }

    public String getDirectoryUrl(String rootUrl, String directoryName) {
        try {
            String url = WebBrowser.forceFinalSlash(rootUrl);
            url = url + WebBrowser.forceFinalSlash(this.quote(directoryName));
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    public String[] getDirectories(Document htmlPage) {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        ArrayList<String> directories = new ArrayList<String>();
        Iterator i = context.iteratePointers(this.getDirectoriesXpath());
        while (i.hasNext()) {
            Pointer pointer = (Pointer)i.next();
            JXPathContext nodeContext = context.getRelativeContext(pointer);
            String dir = (String)nodeContext.getValue(this.getDirectoryXpath());
            dir = WebBrowser.removeFinalSlash(dir);
            dir = dir.substring(dir.lastIndexOf(47) + 1);
            directories.add(dir);
        }
        return directories.toArray(new String[directories.size()]);
    }

    public RemoteFile[] getFiles(Document htmlPage) {
        JXPathContext context = JXPathContext.newContext(htmlPage);
        ArrayList<RemoteFile> files = new ArrayList<RemoteFile>();
        Iterator i = context.iteratePointers(this.getFilesXpath());
        while (i.hasNext()) {
            Pointer pointer = (Pointer)i.next();
            JXPathContext nodeContext = context.getRelativeContext(pointer);
            String fileName = (String)nodeContext.getValue(this.getFileNameXpath());
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            String version = (String)nodeContext.getValue(this.getFileVersionXpath());
            RemoteFile file = new RemoteFile(fileName, version);
            files.add(file);
        }
        return files.toArray(new RemoteFile[files.size()]);
    }

    public String getDownloadUrl(RemoteFile file) {
        try {
            String url = WebBrowser.forceFinalSlash(file.getDirectory().getRemoteRepository().getRootUrl());
            if (this.getBrowsePath().length() > 0) {
                url = url.substring(0, url.length() - this.getBrowsePath().length() - 1);
            }
            url = WebBrowser.forceFinalSlash(url + this.getCheckoutPath());
            String dir = file.getDirectory().getDirectoryPath();
            url = url + WebBrowser.forceFinalSlash(this.quote(dir));
            url = url + this.quote(file.getName());
            url = WebBrowser.addQueryParam(url, "r", file.getVersion());
            url = WebBrowser.addQueryParam(url, "p", "1");
            url = WebBrowser.addQueryParam(url, this.getQueryParams());
            return url;
        }
        catch (URIException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Cannot create URI");
        }
    }

    protected String quote(String original) throws URIException {
        return URIUtil.encodePath(original, "ISO-8859-1");
    }

    protected String getVersionMarker() {
        return null;
    }

    protected void adjustFile(RemoteFile file, JXPathContext nodeContext) {
    }

    public boolean presetMatch(String rootUrl, String packagePath) {
        if (rootUrl.indexOf("cvs.php.net") > 0) {
            this.setType("Chora 2.0 on php.net");
            this._browsePath = "";
            return true;
        }
        return false;
    }

    public Properties guessWebProperties(String url) {
        if (url.startsWith("http://cvs.php.net/")) {
            Properties properties = new Properties();
            properties.put("rootUrl", "http://cvs.php.net/");
            properties.put("packagePath", url.substring("http://cvs.php.net/".length()));
            this._browsePath = "";
            return properties;
        }
        return super.guessWebProperties(url);
    }
}

