/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab;

import java.util.Properties;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.WebBrowser;

public class WebOptions {
    private HttpProxy _httpProxy;
    private WebAuthentification _webAuthentification;
    private String _rootUrl;
    private String _packagePath;
    private String _projectRoot;
    private String _versionTag;
    private String _queryParams;
    private String _webInterfaceId;

    public void setupConnectionSettings() {
        if (this._httpProxy != null) {
            this._httpProxy.setup();
        }
        if (this._webAuthentification != null) {
            this._webAuthentification.setup();
        }
    }

    public void readProperties(Properties properties) {
        this.setRootUrl(properties.getProperty("rootUrl"));
        this.setPackagePath(properties.getProperty("packagePath"));
        this.setProjectRoot(properties.getProperty("projectRoot"));
        this.setVersionTag(properties.getProperty("tag"));
        this.setQueryParams(properties.getProperty("queryParams"));
        this.setWebInterfaceId(properties.getProperty("webInterface"));
        if (CVSGrab.getLog().isDebugEnabled()) {
            CVSGrab.getLog().debug("Web option/root url = " + this.getRootUrl());
            CVSGrab.getLog().debug("Web option/package path = " + this.getPackagePath());
            CVSGrab.getLog().debug("Web option/project root = " + this.getProjectRoot());
            CVSGrab.getLog().debug("Web option/version tag = " + this.getVersionTag());
            CVSGrab.getLog().debug("Web option/query params = " + this.getQueryParams());
            CVSGrab.getLog().debug("Web option/web interface = " + this.getWebInterfaceId());
        }
        if (properties.containsKey("proxyHost")) {
            if (this._httpProxy == null) {
                this._httpProxy = new HttpProxy();
            }
            this._httpProxy.readProperties(properties);
        }
        if (properties.containsKey("webUser")) {
            if (this._webAuthentification == null) {
                this._webAuthentification = new WebAuthentification();
            }
            this._webAuthentification.readProperties(properties);
        }
    }

    public void writeProperties(Properties properties) {
        if (this.getRootUrl() != null) {
            properties.setProperty("rootUrl", this.getRootUrl());
        }
        if (this.getPackagePath() != null) {
            properties.setProperty("packagePath", this.getPackagePath());
        }
        if (this.getProjectRoot() != null) {
            properties.setProperty("projectRoot", this.getProjectRoot());
        }
        if (this.getVersionTag() != null) {
            properties.setProperty("tag", this.getVersionTag());
        }
        if (this.getQueryParams() != null) {
            properties.setProperty("queryParams", this.getQueryParams());
        }
        if (this.getWebInterfaceId() != null) {
            properties.setProperty("webInterface", this.getWebInterfaceId());
        }
        if (this._httpProxy != null) {
            this._httpProxy.writeProperties(properties);
        }
        if (this._webAuthentification != null) {
            this._webAuthentification.writeProperties(properties);
        }
    }

    public String getRootUrl() {
        return this._rootUrl;
    }

    public void setRootUrl(String rootUrl) {
        if (rootUrl != null) {
            this._rootUrl = WebBrowser.forceFinalSlash(rootUrl);
        }
    }

    public String getPackagePath() {
        return this._packagePath;
    }

    public void setPackagePath(String packagePath) {
        if (packagePath != null) {
            this._packagePath = WebBrowser.forceFinalSlash(packagePath);
        }
    }

    public String getProjectRoot() {
        return this._projectRoot;
    }

    public void setProjectRoot(String projectRoot) {
        if (projectRoot != null) {
            this._projectRoot = projectRoot;
        }
    }

    public String getVersionTag() {
        return this._versionTag;
    }

    public void setVersionTag(String versionTag) {
        if (versionTag != null) {
            this._versionTag = versionTag;
        }
    }

    public String getQueryParams() {
        return this._queryParams;
    }

    public void setQueryParams(String queryParams) {
        if (queryParams != null) {
            this._queryParams = queryParams;
        }
    }

    public String getWebInterfaceId() {
        return this._webInterfaceId;
    }

    public void setWebInterfaceId(String webInterfaceId) {
        if (webInterfaceId != null) {
            this._webInterfaceId = webInterfaceId;
        }
    }

    public HttpProxy getHttpProxy() {
        return this._httpProxy;
    }

    public void setHttpProxy(HttpProxy httpProxy) {
        this._httpProxy = httpProxy;
    }

    public WebAuthentification getWebAuthentification() {
        return this._webAuthentification;
    }

    public void setWebAuthentification(WebAuthentification webAuthentification) {
        this._webAuthentification = webAuthentification;
    }

    public void clearLocation() {
        this._rootUrl = null;
        this._packagePath = null;
        this._projectRoot = null;
        this._versionTag = null;
        this._queryParams = null;
        this._webInterfaceId = null;
    }

    public class WebAuthentification {
        private String _user = null;
        private String _password = null;

        public void setup() {
            WebBrowser.getInstance().useWebAuthentification(this._user, this._password);
        }

        public void writeProperties(Properties properties) {
            if (this.getUsername() != null) {
                properties.setProperty("webUser", this.getUsername());
            }
            if (this.getPassword() != null) {
                properties.setProperty("webPassword", this.getPassword());
            }
        }

        public void readProperties(Properties properties) {
            this.setUsername(properties.getProperty("webUser"));
            this.setPassword(properties.getProperty("webPassword"));
        }

        public String getPassword() {
            return this._password;
        }

        public String getUsername() {
            return this._user;
        }

        public void setUsername(String value) {
            this._user = value;
        }

        public void setPassword(String value) {
            this._password = value;
        }
    }

    public class HttpProxy {
        private String _host = null;
        private int _port = 0;
        private String _ntDomain = null;
        private String _username = null;
        private String _password = null;

        public void setup() {
            if (this._host != null && this._port == 0) {
                throw new IllegalArgumentException("port argument is not specified in the proxy");
            }
            WebBrowser.getInstance().useProxy(this._host, this._port, this._ntDomain, this._username, this._password);
        }

        public void writeProperties(Properties properties) {
            if (this.getHost() != null) {
                properties.setProperty("proxyHost", this.getHost());
            }
            if (this.getPort() != 0) {
                properties.setProperty("proxyPort", String.valueOf(this.getPort()));
            }
            if (this.getNtdomain() != null) {
                properties.setProperty("proxyNTDomain", this.getNtdomain());
            }
            if (this.getUsername() != null) {
                properties.setProperty("proxyUser", this.getUsername());
            }
            if (this.getPassword() != null) {
                properties.setProperty("proxyPassword", this.getPassword());
            }
        }

        public void readProperties(Properties properties) {
            this.setHost(properties.getProperty("proxyHost"));
            try {
                this.setPort(Integer.parseInt(properties.getProperty("proxyPort")));
            }
            catch (NumberFormatException ex) {
                CVSGrab.getLog().error("Parameter proxyPort must be a number");
                throw ex;
            }
            this.setNtdomain(properties.getProperty("proxyNTDomain"));
            this.setUsername(properties.getProperty("proxyUser"));
            this.setPassword(properties.getProperty("proxyPassword"));
        }

        public String getHost() {
            return this._host;
        }

        public String getNtdomain() {
            return this._ntDomain;
        }

        public String getPassword() {
            return this._password;
        }

        public int getPort() {
            return this._port;
        }

        public String getUsername() {
            return this._username;
        }

        public void setHost(String value) {
            this._host = value;
        }

        public void setPort(int value) {
            this._port = value;
        }

        public void setNtdomain(String ntDomain) {
            this._ntDomain = ntDomain;
        }

        public void setUsername(String value) {
            this._username = value;
        }

        public void setPassword(String value) {
            this._password = value;
        }
    }
}

