/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.util.PasswordField;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.w3c.dom.Document;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class WebBrowser {
    private static WebBrowser _instance = new WebBrowser();
    private HttpClient _client;
    private DOMParser _htmlParser;

    public static WebBrowser getInstance() {
        return _instance;
    }

    public static String forceFinalSlash(String s) {
        if (!s.endsWith("/")) {
            return s + "/";
        }
        return s;
    }

    public static String removeFinalSlash(String s) {
        if (s != null && s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String addQueryParam(String url, String queryParam) {
        String newUrl = url;
        if (queryParam != null) {
            newUrl = newUrl.indexOf(63) > 0 ? newUrl + "&" : newUrl + "?";
            newUrl = newUrl + queryParam;
        }
        return newUrl;
    }

    public static String addQueryParam(String url, String paramName, String paramValue) {
        String newUrl = url;
        if (paramName != null && paramValue != null) {
            newUrl = newUrl.indexOf(63) > 0 ? newUrl + "&" : newUrl + "?";
            try {
                newUrl = newUrl + paramName + "=" + URIUtil.encodeQuery(paramValue);
            }
            catch (URIException e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot encode parameter value " + paramValue);
            }
        }
        return newUrl;
    }

    public static Properties getQueryParams(String urlQuery) {
        Properties p = new Properties();
        StringTokenizer st = new StringTokenizer(urlQuery, "?&;");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            String key = part.substring(0, part.indexOf(61));
            String value = part.substring(part.indexOf(61) + 1);
            p.put(key, value);
        }
        return p;
    }

    public static String toQueryParams(Properties queryItems) {
        StringBuffer sb = new StringBuffer();
        Iterator<Object> i = queryItems.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = queryItems.getProperty(key);
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    public WebBrowser() {
        CookiePolicy.setDefaultPolicy(0);
        this._client = new HttpClient();
        this._client.setConnectionTimeout(5000);
        this._htmlParser = new DOMParser(new HTMLConfiguration());
        try {
            this._htmlParser.setProperty("http://cyberneko.org/html/properties/names/elems", "upper");
            this._htmlParser.setProperty("http://cyberneko.org/html/properties/names/attrs", "lower");
            this._htmlParser.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
            this._htmlParser.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
            this._htmlParser.setFeature("http://xml.org/sax/features/namespaces", false);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void useProxy(String proxyHost, int proxyPort, String ntDomain, String userName, String password) {
        CVSGrab.getLog().info("Using proxy " + proxyHost + ":" + proxyPort);
        this._client.getHostConfiguration().setProxy(proxyHost, proxyPort);
        if (userName != null) {
            if (password == null) {
                PasswordField pwdField = new PasswordField();
                try {
                    password = pwdField.getPassword("Enter the password for the proxy: ");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (ntDomain == null) {
                CVSGrab.getLog().info("Login on the proxy with user name " + userName);
                this._client.getState().setProxyCredentials(null, proxyHost, new UsernamePasswordCredentials(userName, password));
            } else {
                try {
                    String host = InetAddress.getLocalHost().getHostName();
                    CVSGrab.getLog().info("Login on the NT proxy with user name " + userName + ", host " + host + ", NT domain " + ntDomain);
                    this._client.getState().setProxyCredentials(null, proxyHost, new NTCredentials(userName, password, host, ntDomain));
                }
                catch (UnknownHostException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void useWebAuthentification(String userName, String password) {
        CVSGrab.getLog().info("Login on the web server with user name " + userName + " and password " + password);
        if (password == null) {
            PasswordField pwdField = new PasswordField();
            try {
                password = pwdField.getPassword("Enter the password for the web server: ");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this._client.getState().setCredentials(null, null, new UsernamePasswordCredentials(userName, password));
    }

    public void useMultithreading() {
        this._client = new HttpClient(new MultiThreadedHttpConnectionManager());
    }

    public HttpMethod executeMethod(HttpMethod method, String url) {
        int statusCode = -1;
        int attempt = 0;
        try {
            method.setRequestHeader("User-Agent", "cvsgrab (http://cvsgrab.sourceforge.net)");
            method.setRequestHeader("Cache-Control", "no-cache");
            method.setRequestHeader("Accept-Encoding", "gzip");
            while (statusCode == -1 && attempt < 3) {
                try {
                    statusCode = this._client.executeMethod(method);
                    CVSGrab.getLog().trace("Executed method " + url + " with status code " + statusCode);
                }
                catch (HttpRecoverableException e) {
                    CVSGrab.getLog().warn("A recoverable exception occurred, retrying. " + e.getMessage());
                }
                catch (IOException e) {
                    CVSGrab.getLog().error("Failed to download file " + url);
                    e.printStackTrace();
                    throw new RuntimeException("Failed to download file " + url);
                }
            }
            if (statusCode == -1) {
                CVSGrab.getLog().error("Failed to recover from exception.");
                throw new RuntimeException("Error when reading " + url);
            }
            if (statusCode >= 400) {
                CVSGrab.getLog().debug("Page not found (error " + statusCode + ")");
                throw new RuntimeException("Error " + statusCode + " when reading " + url);
            }
            if (statusCode >= 300 && statusCode < 400) {
                Header locationHeader = method.getResponseHeader("location");
                if (locationHeader != null) {
                    String redirectLocation = locationHeader.getValue();
                    method.releaseConnection();
                    CVSGrab.getLog().debug("Redirect to " + redirectLocation);
                    GetMethod redirectMethod = new GetMethod(redirectLocation);
                    this.executeMethod(redirectMethod, redirectLocation);
                    return redirectMethod;
                }
                CVSGrab.getLog().error("Page not found");
                throw new RuntimeException("Error when reading " + url);
            }
        }
        catch (RuntimeException e) {
            method.releaseConnection();
            throw e;
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse(HttpMethod method, String url) {
        String response;
        block10: {
            HttpMethod lastMethod = this.executeMethod(method, url);
            response = null;
            try {
                String contentEncoding = null;
                if (lastMethod.getResponseHeader("Content-Encoding") != null) {
                    contentEncoding = lastMethod.getResponseHeader("Content-Encoding").getValue();
                }
                if (contentEncoding != null && contentEncoding.toLowerCase().indexOf("gzip") >= 0) {
                    try {
                        InputStream inStream = lastMethod.getResponseBodyAsStream();
                        if (inStream != null && (inStream = new GZIPInputStream(lastMethod.getResponseBodyAsStream())) != null) {
                            response = this.getResponseContent(lastMethod, inStream);
                        }
                        break block10;
                    }
                    catch (IOException e) {
                        CVSGrab.getLog().error("I/O failure reading response body", e);
                    }
                    break block10;
                }
                try {
                    response = this.getResponseContent(lastMethod, lastMethod.getResponseBodyAsStream());
                }
                catch (IOException e) {
                    CVSGrab.getLog().error("I/O failure reading response body", e);
                }
            }
            finally {
                lastMethod.releaseConnection();
            }
        }
        return response;
    }

    private String getResponseContent(HttpMethod lastMethod, InputStream inStream) throws IOException {
        int len;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = inStream.read(buffer)) > 0) {
            outstream.write(buffer, 0, len);
        }
        outstream.close();
        String response = new String(outstream.toByteArray(), ((HttpMethodBase)lastMethod).getResponseCharSet());
        return response;
    }

    public Document getDocument(String url) throws Exception {
        if (url.endsWith("/browse/")) {
            if (url.indexOf("netbeans.org") >= 0) {
                throw new Exception("This url " + url + " doesn't work on Netbeans.org");
            }
            if (url.indexOf("dev.java.net") >= 0) {
                throw new Exception("This url " + url + " doesn't work on dev.java.net");
            }
        }
        return this.getDocument(new GetMethod(url), url);
    }

    public Document getDocument(HttpMethod method, String url) throws Exception {
        String response = this.getResponse(method, url);
        return this.getDocumentFromSource(response);
    }

    public Document getDocumentFromSource(String docSource) throws Exception {
        int pos = 0;
        do {
            if ((pos = docSource.indexOf("xmlns", pos)) <= 0) continue;
            int eq = docSource.indexOf(61, pos);
            int lt = docSource.indexOf(60, pos);
            int gt = docSource.indexOf(62, pos);
            if (eq <= 0 || eq >= gt || gt >= lt) continue;
            docSource = docSource.substring(0, pos) + docSource.substring(gt);
        } while (pos > 0);
        XMLInputSource source = new XMLInputSource(null, null, null, new StringReader(docSource), null);
        this._htmlParser.parse(source);
        Document doc = this._htmlParser.getDocument();
        return doc;
    }

    public void loadFile(String url, File destFile) throws Exception {
        this.loadFile(new GetMethod(url), destFile, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(HttpMethod method, File destFile, String url) throws Exception {
        HttpMethod lastMethod = this.executeMethod(method, url);
        String contentEncoding = null;
        if (lastMethod.getResponseHeader("Content-Encoding") != null) {
            contentEncoding = lastMethod.getResponseHeader("Content-Encoding").getValue();
        }
        try {
            FileOutputStream out = null;
            FilterInputStream in = new BufferedInputStream(lastMethod.getResponseBodyAsStream());
            if (contentEncoding != null && contentEncoding.toLowerCase().indexOf("gzip") >= 0) {
                in = new GZIPInputStream(lastMethod.getResponseBodyAsStream());
            }
            try {
                out = new FileOutputStream(destFile);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = ((InputStream)in).read(buffer, 0, buffer.length)) != -1);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
        finally {
            lastMethod.releaseConnection();
        }
    }
}

