/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab;

import java.util.Iterator;
import java.util.Vector;
import net.sourceforge.cvsgrab.CvsWebInterface;
import net.sourceforge.cvsgrab.LocalRepository;
import net.sourceforge.cvsgrab.RemoteDirectory;
import net.sourceforge.cvsgrab.RemoteFile;

public class RemoteRepository {
    private Vector _remoteDirectories = new Vector();
    private Vector _directoriesToProcess = new Vector();
    private String _rootUrl;
    private LocalRepository _localRepository;
    private CvsWebInterface _webInterface;

    public RemoteRepository(String rootUrl, LocalRepository localRepository) {
        this._rootUrl = rootUrl;
        this._localRepository = localRepository;
    }

    public String getRootUrl() {
        return this._rootUrl;
    }

    public LocalRepository getLocalRepository() {
        return this._localRepository;
    }

    public RemoteDirectory getRemoteDirectory(String dirPath) {
        Iterator i = this._remoteDirectories.iterator();
        while (i.hasNext()) {
            RemoteDirectory remoteDir = (RemoteDirectory)i.next();
            if (!remoteDir.getDirectoryPath().equals(dirPath)) continue;
            return remoteDir;
        }
        return null;
    }

    public CvsWebInterface getWebInterface() {
        return this._webInterface;
    }

    public void setWebInterface(CvsWebInterface webInterface) {
        this._webInterface = webInterface;
    }

    public void registerDirectoryToProcess(RemoteDirectory remoteDir) {
        if (this.getRemoteDirectory(remoteDir.getDirectoryPath()) != null) {
            return;
        }
        this._remoteDirectories.add(remoteDir);
        this._directoriesToProcess.add(remoteDir);
        this._localRepository.add(remoteDir);
    }

    public boolean hasDirectoryToProcess() {
        return this._directoriesToProcess.size() > 0;
    }

    public RemoteDirectory nextDirectoryToProcess() {
        if (!this._directoriesToProcess.isEmpty()) {
            RemoteDirectory rDir = (RemoteDirectory)this._directoriesToProcess.get(0);
            this._directoriesToProcess.remove(0);
            return rDir;
        }
        return null;
    }

    public String getDirectoryUrl(String directoryName) {
        String url = this._webInterface.getDirectoryUrl(this.getRootUrl(), directoryName);
        return url;
    }

    public String getDownloadUrl(RemoteFile file) {
        String url = this._webInterface.getDownloadUrl(file);
        return url;
    }
}

