/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab;

import java.io.PrintWriter;
import java.util.Vector;
import net.sourceforge.cvsgrab.CVSGrab;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.RemoteRepository;
import net.sourceforge.cvsgrab.WebBrowser;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class RemoteDirectory {
    private Vector _remoteFiles = new Vector();
    private RemoteRepository _remoteRepository;
    private String _dirPath;
    private String _localDir;

    public RemoteDirectory(RemoteRepository repository, String dirPath, String localDir) {
        this._remoteRepository = repository;
        this._dirPath = WebBrowser.forceFinalSlash(dirPath);
        this._localDir = WebBrowser.forceFinalSlash(localDir);
    }

    public RemoteDirectory(RemoteDirectory parentDirectory, String name) {
        this._remoteRepository = parentDirectory.getRemoteRepository();
        this._dirPath = WebBrowser.forceFinalSlash(parentDirectory.getDirectoryPath() + name);
        this._localDir = WebBrowser.forceFinalSlash(parentDirectory.getLocalDir() + name);
    }

    public String getUrl() {
        return this._remoteRepository.getDirectoryUrl(this._dirPath);
    }

    public String getDirectoryPath() {
        return this._dirPath;
    }

    public String getLocalDir() {
        return this._localDir;
    }

    public RemoteFile[] getRemoteFiles() {
        return this._remoteFiles.toArray(new RemoteFile[this._remoteFiles.size()]);
    }

    public RemoteRepository getRemoteRepository() {
        return this._remoteRepository;
    }

    public void registerRemoteFile(RemoteFile file) {
        this._remoteFiles.add(file);
    }

    public void unregisterRemoteFile(RemoteFile file) {
        this._remoteFiles.remove(file);
    }

    public void loadContents() throws Exception {
        String url = this.getUrl();
        Log log2 = CVSGrab.getLog();
        log2.info("cvs update: Updating " + this.getDirectoryPath());
        log2.debug("Loading url " + url);
        Document doc = WebBrowser.getInstance().getDocument(url);
        RemoteFile[] files = this._remoteRepository.getWebInterface().getFiles(doc);
        for (int i = 0; i < files.length; ++i) {
            RemoteFile file = files[i];
            file.setDirectory(this);
            file.grab(this._remoteRepository.getLocalRepository());
        }
        String[] directories = this._remoteRepository.getWebInterface().getDirectories(doc);
        for (int i = 0; i < directories.length; ++i) {
            this._remoteRepository.registerDirectoryToProcess(new RemoteDirectory(this, directories[i]));
        }
    }

    public void diffContents(PrintWriter writer) throws Exception {
        String url = this.getUrl();
        Log log2 = CVSGrab.getLog();
        log2.info("cvs update: Updating " + this.getDirectoryPath());
        Document doc = WebBrowser.getInstance().getDocument(url);
        RemoteFile[] files = this._remoteRepository.getWebInterface().getFiles(doc);
        for (int i = 0; i < files.length; ++i) {
            RemoteFile file = files[i];
            file.setDirectory(this);
            file.diff(this._remoteRepository.getLocalRepository(), writer, this._remoteRepository.getWebInterface().getGrabber());
        }
        String[] directories = this._remoteRepository.getWebInterface().getDirectories(doc);
        for (int i = 0; i < directories.length; ++i) {
            this._remoteRepository.registerDirectoryToProcess(new RemoteDirectory(this, directories[i]));
        }
    }

    public String toString() {
        return this.getDirectoryPath();
    }
}

