/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cvsgrab;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.cvsgrab.CvsWebInterface;
import net.sourceforge.cvsgrab.LocalRepository;
import net.sourceforge.cvsgrab.RemoteDirectory;
import net.sourceforge.cvsgrab.RemoteFile;
import net.sourceforge.cvsgrab.RemoteRepository;
import net.sourceforge.cvsgrab.WebBrowser;
import net.sourceforge.cvsgrab.WebOptions;
import net.sourceforge.cvsgrab.util.ThreadPool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVSGrab {
    public static final String DUMMY_ROOT = ":pserver:anonymous@dummyhost:/dummyroot";
    public static final String CONNECTIONS_OPTION = "connections";
    public static final String WEB_PASSWORD_OPTION = "webPassword";
    public static final String WEB_USER_OPTION = "webUser";
    public static final String PROXY_PASSWORD_OPTION = "proxyPassword";
    public static final String PROXY_USER_OPTION = "proxyUser";
    public static final String PROXY_NTDOMAIN_OPTION = "proxyNTDomain";
    public static final String PROXY_PORT_OPTION = "proxyPort";
    public static final String PROXY_HOST_OPTION = "proxyHost";
    public static final String PRUNE_OPTION = "prune";
    public static final String QUIET_OPTION = "quiet";
    public static final String VERBOSE_OPTION = "verbose";
    public static final String DEBUG_WIRE_OPTION = "debugWire";
    public static final String DEBUG_OPTION = "debug";
    public static final String CVS_ROOT_OPTION = "cvsRoot";
    public static final String WEB_INTERFACE_OPTION = "webInterface";
    public static final String PROJECT_ROOT_OPTION = "projectRoot";
    public static final String QUERY_PARAMS_OPTION = "queryParams";
    public static final String TAG_OPTION = "tag";
    public static final String PACKAGE_DIR_OPTION = "packageDir";
    public static final String DEST_DIR_OPTION = "destDir";
    public static final String PACKAGE_PATH_OPTION = "packagePath";
    public static final String ROOT_URL_OPTION = "rootUrl";
    public static final String URL_OPTION = "url";
    public static final String CLEAN_UPDATE_OPTION = "clean";
    public static final String LIST_WEB_INTERFACES_CMD = "listWebInterfaces";
    public static final String DIFF_CMD = "diff";
    public static final String EXPORT_CMD = "export";
    public static final String HELP_CMD = "help";
    private static final String[] WEB_OPTIONS = new String[]{"rootUrl", "packagePath", "projectRoot", "tag", "queryParams", "webInterface", "proxyHost", "proxyPort", "proxyNTDomain", "proxyUser", "proxyPassword", "webUser", "webPassword"};
    private static final String FORUM_URL = "http://sourceforge.net/forum/forum.php?forum_id=174128";
    private static final String VERSION = "2.3";
    private static final String DEFAULT_DEST_DIR = ".";
    private static Log LOG;
    private boolean _pruneEmptyDirs = false;
    private boolean _cleanUpdate;
    private boolean _export;
    private boolean _error = false;
    private String _packageDir;
    private String _destDir = ".";
    private String _cvsRoot = ":pserver:anonymous@dummyhost:/dummyroot";
    private Options _options;
    private WebOptions _webOptions = new WebOptions();
    private CvsWebInterface _webInterface;
    static /* synthetic */ Class class$net$sourceforge$cvsgrab$CVSGrab;
    static /* synthetic */ Class class$net$sourceforge$cvsgrab$util$CVSGrabLog;
    static /* synthetic */ Class class$java$lang$String;

    public static Log getLog() {
        if (LOG == null) {
            LOG = LogFactory.getLog(class$net$sourceforge$cvsgrab$CVSGrab == null ? (class$net$sourceforge$cvsgrab$CVSGrab = CVSGrab.class$("net.sourceforge.cvsgrab.CVSGrab")) : class$net$sourceforge$cvsgrab$CVSGrab);
        }
        return LOG;
    }

    public static void setLog(Log log2) {
        LOG = log2;
    }

    public CVSGrab() {
        this.initOptions();
    }

    private void initOptions() {
        this._options = new Options();
        this._options.addOption(HELP_CMD, false, "[Command] Prints this help message");
        this._options.addOption(LIST_WEB_INTERFACES_CMD, false, "[Command] Lists the web interfaces to the CVS repository that are\t supported by this tool");
        this._options.addOption(new OptionBuilder().withDescription("[Command] Builds the differences against the same remote version. Result is stored in the file patch.txt").create(DIFF_CMD));
        this._options.addOption(new OptionBuilder().withDescription("[Command] Exports the repository. CVS directories are not created.").create(EXPORT_CMD));
        this._options.addOption(new OptionBuilder().withArgName(URL_OPTION).hasArg().withDescription("The full url used to access the CVS repository from a web browser").create(URL_OPTION));
        this._options.addOption(new OptionBuilder().withArgName(URL_OPTION).hasArg().withDescription("[if full url not used] The root url used to access the CVS repository from a web browser").create(ROOT_URL_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("path").hasArg().withDescription("[if full url not used] The path relative to rootUrl of the package or module to download").create(PACKAGE_PATH_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("root").hasArg().withDescription("[optional] The project root, for cvs with multiple repositories").create(PROJECT_ROOT_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("version tag").hasArg().withDescription("[optional] The version tag of the files to download").create(TAG_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("query params").hasArg().withDescription("[optional] Additional query parameters").create(QUERY_PARAMS_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("web interface id").hasArg().withDescription("[optional] The id for the web interface for the CVS repository to use. If this option is not set, autodetect the web interface.Call cvsgrab -listWebInterfaces to get a list of valid values for this option.").create(WEB_INTERFACE_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("dir").hasArg().withDescription("[optional] The destination directory.").create(DEST_DIR_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("dir").hasArg().withDescription("The name of the package to use locally, relative to destDir, overrides packagePath").create(PACKAGE_DIR_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("cvs root").hasArg().withDescription("[optional] The original cvs root, used to maintain compatibility with a standard CVS client").create(CVS_ROOT_OPTION));
        this._options.addOption(new OptionBuilder().withDescription("[optional] Prune (remove) the empty directories.").create(PRUNE_OPTION));
        this._options.addOption(new OptionBuilder().withDescription("[optional] Clean update. Backup locally modified files and download anyway the latest version of the file.").create(CLEAN_UPDATE_OPTION));
        Option debugOption = new OptionBuilder().withDescription("[optional] Turn debugging on.").create(DEBUG_OPTION);
        Option debugWireOption = new OptionBuilder().withDescription("[optional] Turn debugging on, including very verbose network traffic.").create(DEBUG_WIRE_OPTION);
        Option verboseOption = new OptionBuilder().withDescription("[optional] Turn verbosity on.").create(VERBOSE_OPTION);
        Option quietOption = new OptionBuilder().withDescription("[optional] Be extra quiet.").create(QUIET_OPTION);
        this._options.addOptionGroup(new OptionGroup().addOption(debugOption).addOption(debugWireOption).addOption(verboseOption).addOption(quietOption));
        this._options.addOption(new OptionBuilder().withArgName("nb of connections").hasArg().withDescription("[optional] The number of simultaneous connections to use for downloads, default 1").create(CONNECTIONS_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("host").hasArg().withDescription("[optional] Proxy host").create(PROXY_HOST_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("port").hasArg().withDescription("[optional] Proxy port").create(PROXY_PORT_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("domain").hasArg().withDescription("[optional] NT Domain for the authentification on a MS proxy").create(PROXY_NTDOMAIN_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("user").hasArg().withDescription("[optional] Username for the proxy").create(PROXY_USER_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("password").hasArg().withDescription("[optional] Password for the proxy. If this option is omitted, then cvsgrab will prompt securely for the password.").create(PROXY_PASSWORD_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("user").hasArg().withDescription("[optional] Username for the web server").create(WEB_USER_OPTION));
        this._options.addOption(new OptionBuilder().withArgName("password").hasArg().withDescription("[optional] Password for the web server. If this option is omitted, then cvsgrab will prompt securely for the password.").create(WEB_PASSWORD_OPTION));
    }

    public static void main(String[] args) {
        System.setProperty("org.apache.commons.logging.Log", (class$net$sourceforge$cvsgrab$util$CVSGrabLog == null ? (class$net$sourceforge$cvsgrab$util$CVSGrabLog = CVSGrab.class$("net.sourceforge.cvsgrab.util.CVSGrabLog")) : class$net$sourceforge$cvsgrab$util$CVSGrabLog).getName());
        CVSGrab grabber = new CVSGrab();
        try {
            grabber.run(args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            grabber.printHelp();
        }
    }

    private void run(String[] args) throws ParseException {
        int connections;
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(this._options, args);
        if (cmd.hasOption(HELP_CMD)) {
            this.printHelp();
            return;
        }
        if (cmd.hasOption(LIST_WEB_INTERFACES_CMD)) {
            CVSGrab.printWebInterfaces();
            return;
        }
        CVSGrab.cvsgrabLogLevel("info", "WARNING");
        CVSGrab.httpclientLogLevel("error", "SEVERE");
        if (cmd.hasOption(DEBUG_OPTION)) {
            CVSGrab.cvsgrabLogLevel("trace", "FINEST");
            CVSGrab.httpclientLogLevel("info", "INFO");
        }
        if (cmd.hasOption(DEBUG_WIRE_OPTION)) {
            CVSGrab.httpclientLogLevel("trace", "FINEST");
            CVSGrab.logLevel("httpclient.wire", "trace", "FINE");
        }
        if (cmd.hasOption(VERBOSE_OPTION)) {
            CVSGrab.cvsgrabLogLevel(DEBUG_OPTION, "INFO");
            CVSGrab.httpclientLogLevel("error", "SEVERE");
        }
        if (cmd.hasOption(QUIET_OPTION)) {
            CVSGrab.cvsgrabLogLevel("warn", "INFO");
            CVSGrab.httpclientLogLevel("error", "SEVERE");
        }
        Properties webProperties = new Properties();
        for (int i = 0; i < WEB_OPTIONS.length; ++i) {
            String option = WEB_OPTIONS[i];
            if (!cmd.hasOption(option)) continue;
            webProperties.put(option, cmd.getOptionValue(option));
        }
        this._webOptions.readProperties(webProperties);
        if (cmd.hasOption(PROJECT_ROOT_OPTION)) {
            this.setCvsRoot(cmd.getOptionValue(PROJECT_ROOT_OPTION));
        }
        if (cmd.hasOption(CVS_ROOT_OPTION)) {
            this.setCvsRoot(cmd.getOptionValue(CVS_ROOT_OPTION));
        }
        if (cmd.hasOption(DEST_DIR_OPTION)) {
            this.setDestDir(cmd.getOptionValue(DEST_DIR_OPTION));
        }
        if (cmd.hasOption(PACKAGE_DIR_OPTION)) {
            this.setPackageDir(cmd.getOptionValue(PACKAGE_DIR_OPTION));
        }
        if (cmd.hasOption(PRUNE_OPTION)) {
            this.setPruneEmptyDirs(true);
        }
        if (cmd.hasOption(CLEAN_UPDATE_OPTION)) {
            this.setCleanUpdate(true);
        }
        this._webOptions.setupConnectionSettings();
        if (cmd.hasOption(CONNECTIONS_OPTION) && (connections = Integer.parseInt(cmd.getOptionValue(CONNECTIONS_OPTION))) > 1) {
            ThreadPool.init(connections);
            WebBrowser.getInstance().useMultithreading();
        }
        String cvsGrabHome = System.getProperty("cvsgrab.home");
        File file = new File(cvsGrabHome, "FileTypes.properties");
        try {
            Properties fileTypes = new Properties();
            FileInputStream is = new FileInputStream(file);
            fileTypes.load(is);
            RemoteFile.setFileTypes(fileTypes);
        }
        catch (IOException ex) {
            CVSGrab.getLog().error("Cannot read the file " + file.getPath());
        }
        if (cmd.hasOption(URL_OPTION)) {
            this.setUrl(cmd.getOptionValue(URL_OPTION));
        }
        if (cmd.hasOption(EXPORT_CMD)) {
            this.setExport(true);
        }
        if (cmd.hasOption(DIFF_CMD)) {
            this.diffCVSRepository();
        } else {
            this.grabCVSRepository();
        }
    }

    private static void cvsgrabLogLevel(String simpleLevel, String jdk14Level) {
        CVSGrab.logLevel("net.sourceforge.cvsgrab", simpleLevel, jdk14Level);
    }

    private static void httpclientLogLevel(String simpleLevel, String jdk14Level) {
        CVSGrab.logLevel("org.apache.commons.httpclient", simpleLevel, jdk14Level);
    }

    private static void logLevel(String packageName, String simpleLevel, String jdk14Level) {
        if (SystemUtils.isJavaVersionAtLeast(1.4f)) {
            CVSGrab.setJdk14LogLevel(packageName + ".level", jdk14Level);
        }
        System.setProperty("org.apache.commons.logging.simplelog.log." + packageName, simpleLevel);
    }

    private static void setJdk14LogLevel(String className, String level) {
        try {
            Class<?> loggerClass = Class.forName("java.util.logging.Logger");
            Class<?> levelClass = Class.forName("java.util.logging.Level");
            Object logger = loggerClass.getMethod("getLogger", class$java$lang$String == null ? (class$java$lang$String = CVSGrab.class$("java.lang.String")) : class$java$lang$String).invoke(null, className);
            Object levelObj = levelClass.getField(level).get(null);
            loggerClass.getMethod("setLevel", levelClass).invoke(logger, levelObj);
        }
        catch (Exception ex) {
            System.err.println("Cannot change the configuration of the Java 1.4 logger");
            ex.printStackTrace();
        }
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(74, "cvsgrab", "where options are", this._options, "CVSGrab version 2.3, copyright (c) 2002-2004 - Ludovic Claude.", false);
    }

    public static void printWebInterfaces() {
        System.out.println("CVSGrab version 2.3");
        System.out.println("Currently supporting the following web interfaces:");
        String[] webInterfaces = CvsWebInterface.getInterfaceIds(new CVSGrab());
        for (int i = 0; i < webInterfaces.length; ++i) {
            System.out.println("\t" + webInterfaces[i]);
        }
        System.out.println("Those ids can be use with the -webInterface option to force cvsgrab to use a specific web interface.");
    }

    public boolean getPruneEmptyDirs() {
        return this._pruneEmptyDirs;
    }

    public void setPruneEmptyDirs(boolean value) {
        this._pruneEmptyDirs = value;
    }

    public boolean isCleanUpdate() {
        return this._cleanUpdate;
    }

    public void setCleanUpdate(boolean cleanUpdate) {
        this._cleanUpdate = cleanUpdate;
    }

    public boolean isExport() {
        return this._export;
    }

    public void setExport(boolean export2) {
        this._export = export2;
    }

    public String getRootUrl() {
        return this._webOptions.getRootUrl();
    }

    public String getPackagePath() {
        return this._webOptions.getPackagePath();
    }

    public String getDestDir() {
        return this._destDir;
    }

    public void setDestDir(String destDir) {
        this._destDir = WebBrowser.forceFinalSlash(destDir);
    }

    public String getPackageDir() {
        if (this._packageDir == null) {
            return this.getPackagePath();
        }
        return this._packageDir;
    }

    public void setPackageDir(String packageDir) {
        this._packageDir = WebBrowser.forceFinalSlash(packageDir);
    }

    public String getCvsRoot() {
        return this._cvsRoot;
    }

    public void setCvsRoot(String cvsRoot) {
        this._cvsRoot = WebBrowser.forceFinalSlash(cvsRoot);
    }

    public String getProjectRoot() {
        return this._webOptions.getProjectRoot();
    }

    public String getVersionTag() {
        return this._webOptions.getVersionTag();
    }

    public String getQueryParams() {
        return this._webOptions.getQueryParams();
    }

    public String getWebInterfaceId() {
        if (this._webInterface != null) {
            return this._webInterface.getId();
        }
        return this._webOptions.getWebInterfaceId();
    }

    public WebOptions getWebOptions() {
        return this._webOptions;
    }

    public void setUrl(String url) {
        Properties webProperties;
        if (this.getWebInterfaceId() != null) {
            try {
                webProperties = this.getWebInterface().guessWebProperties(url);
            }
            catch (Exception e) {
                CVSGrab.getLog().error(e.getMessage());
                this._error = true;
                return;
            }
        } else {
            webProperties = CvsWebInterface.getWebProperties(this, url);
            this._webInterface = (CvsWebInterface)webProperties.get("detectedWebInterface");
        }
        this._webOptions.readProperties(webProperties);
    }

    public void grabCVSRepository() {
        this.printHeader();
        this.loadExistingAdminFiles();
        if (!this.checkMandatoryParameters()) {
            return;
        }
        try {
            this.checkDestDir();
            this.checkWebConnection();
            CvsWebInterface webInterface = this.getWebInterface();
            LocalRepository localRepository = new LocalRepository(this);
            RemoteRepository remoteRepository = new RemoteRepository(this.getRootUrl(), localRepository);
            remoteRepository.setWebInterface(webInterface);
            RemoteDirectory remoteDir = new RemoteDirectory(remoteRepository, this.getPackagePath(), this.getPackageDir());
            remoteRepository.registerDirectoryToProcess(remoteDir);
            while (remoteRepository.hasDirectoryToProcess()) {
                try {
                    remoteDir = remoteRepository.nextDirectoryToProcess();
                    remoteDir.loadContents();
                    localRepository.cleanRemovedFiles(remoteDir);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    CVSGrab.getLog().error("Error while getting files from " + remoteDir.getUrl());
                    this._error = true;
                }
            }
            if (this._pruneEmptyDirs) {
                localRepository.pruneEmptyDirectories();
            }
            int newFileCount = localRepository.getNewFileCount();
            int updatedFileCount = localRepository.getUpdatedFileCount();
            int removedFileCount = localRepository.getRemovedFileCount();
            int failedUpdateCount = localRepository.getFailedUpdateCount();
            CVSGrab.getLog().info("-----");
            if (newFileCount > 0) {
                CVSGrab.getLog().info(newFileCount + " new files");
            }
            if (updatedFileCount > 0) {
                CVSGrab.getLog().info(updatedFileCount + " updated files");
            }
            if (removedFileCount > 0) {
                CVSGrab.getLog().info(removedFileCount + " removed files");
            }
            if (failedUpdateCount > 0) {
                CVSGrab.getLog().error(failedUpdateCount + " files could not be downloaded");
            }
        }
        catch (Exception ex) {
            CVSGrab.getLog().error(ex.getMessage());
            this._error = true;
        }
        if (ThreadPool.getInstance() != null) {
            ThreadPool.getInstance().destroy();
        }
        if (this._error) {
            CVSGrab.getLog().error("There were some errors.");
            CVSGrab.getLog().error("If you cannot find an obvious answer, report the problem to http://sourceforge.net/forum/forum.php?forum_id=174128");
        }
    }

    public void diffCVSRepository() {
        this.printHeader();
        this.loadExistingAdminFiles();
        if (!this.checkMandatoryParameters()) {
            return;
        }
        try {
            this.checkDestDir();
            this.checkWebConnection();
            CvsWebInterface webInterface = this.getWebInterface();
            File diffFile = new File("patch.txt");
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(diffFile)));
            LocalRepository localRepository = new LocalRepository(this);
            RemoteRepository remoteRepository = new RemoteRepository(this.getRootUrl(), localRepository);
            remoteRepository.setWebInterface(webInterface);
            RemoteDirectory remoteDir = new RemoteDirectory(remoteRepository, this.getPackagePath(), this.getPackageDir());
            remoteRepository.registerDirectoryToProcess(remoteDir);
            while (remoteRepository.hasDirectoryToProcess()) {
                try {
                    remoteDir = remoteRepository.nextDirectoryToProcess();
                    remoteDir.diffContents(writer);
                    writer.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    CVSGrab.getLog().error("Error while getting files from " + remoteDir.getUrl());
                    this._error = true;
                }
            }
            writer.close();
            int newFileCount = localRepository.getNewFileCount();
            int updatedFileCount = localRepository.getUpdatedFileCount();
            int removedFileCount = localRepository.getRemovedFileCount();
            int failedUpdateCount = localRepository.getFailedUpdateCount();
            CVSGrab.getLog().info("-----");
            if (newFileCount > 0) {
                CVSGrab.getLog().info(newFileCount + " new files");
            }
            if (updatedFileCount > 0) {
                CVSGrab.getLog().info(updatedFileCount + " updated files");
            }
            if (removedFileCount > 0) {
                CVSGrab.getLog().info(removedFileCount + " removed files");
            }
            if (failedUpdateCount > 0) {
                CVSGrab.getLog().error(failedUpdateCount + " files could not be downloaded");
            }
            CVSGrab.getLog().info("Differences stored in " + diffFile.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CVSGrab.getLog().error(ex.getMessage());
            this._error = true;
        }
        if (ThreadPool.getInstance() != null) {
            ThreadPool.getInstance().destroy();
        }
        if (this._error) {
            CVSGrab.getLog().error("There were some errors.");
            CVSGrab.getLog().error("If you cannot find an obvious answer, report the problem to http://sourceforge.net/forum/forum.php?forum_id=174128");
        }
    }

    private CvsWebInterface getWebInterface() throws Exception {
        if (this._webInterface == null) {
            this._webInterface = this.getWebInterfaceId() != null ? CvsWebInterface.getInterface(this, this.getWebInterfaceId()) : this.detectWebInterface();
        }
        if (this._webInterface == null) {
            CVSGrab.getLog().error("Could not detect the type of the web interface");
            throw new RuntimeException("Could not detect the type of the web interface");
        }
        CVSGrab.getLog().info("Detected cvs web interface: " + this._webInterface.getType());
        this._webInterface.setQueryParams(this.getQueryParams());
        if (this.getVersionTag() != null) {
            this._webInterface.setVersionTag(this.getVersionTag());
        }
        return this._webInterface;
    }

    private void checkWebConnection() throws Exception {
        String[] urls = CvsWebInterface.getBaseUrls(this);
        HashMap<String, String> errors = new HashMap<String, String>();
        for (int i = 0; i < urls.length; ++i) {
            try {
                CVSGrab.getLog().debug("Connecting to " + urls[i]);
                GetMethod connectMethod = new GetMethod(urls[i]);
                WebBrowser.getInstance().executeMethod(connectMethod, urls[i]);
                CVSGrab.getLog().debug("Connection successful");
                return;
            }
            catch (Exception ex) {
                errors.put(urls[i], ex.getMessage());
                continue;
            }
        }
        Iterator i = errors.keySet().iterator();
        while (i.hasNext()) {
            String url = (String)i.next();
            System.err.println("When attempting to connect to " + url + ", got error: " + errors.get(url));
        }
        throw new Exception("Cannot connect to the website, check your proxy settings");
    }

    private void checkDestDir() {
        File dd = new File(this._destDir);
        if (!dd.exists()) {
            throw new RuntimeException("Destination directory " + this._destDir + " doesn't exist");
        }
        if (!dd.isDirectory()) {
            throw new RuntimeException("Destination " + this._destDir + " is not a directory");
        }
        try {
            this._destDir = dd.getCanonicalPath().replace(File.separatorChar, '/');
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not locate the destination directory " + this._destDir + ", error was " + ex.getMessage());
        }
    }

    private boolean checkMandatoryParameters() {
        if (this.getRootUrl() == null || this.getPackagePath() == null) {
            if (this.getRootUrl() == null) {
                System.out.println("Error: rootUrl parameter is mandatory");
            }
            if (this.getPackagePath() == null) {
                System.out.println("Error: packagePath parameter is mandatory");
            }
            this.printHelp();
            return false;
        }
        return true;
    }

    private void loadExistingAdminFiles() {
        File rootAdmin;
        File webRepositoryAdmin = new File(this._destDir, "CVS/WebRepository");
        if (webRepositoryAdmin.exists()) {
            Properties webProperties = new Properties();
            try {
                webProperties.load(new FileInputStream(webRepositoryAdmin));
                this._webOptions.writeProperties(webProperties);
                this._webOptions.readProperties(webProperties);
                if (this.getDestDir().equals(DEFAULT_DEST_DIR)) {
                    File currentDir = new File(DEFAULT_DEST_DIR);
                    currentDir = currentDir.getAbsoluteFile();
                    this.setPackageDir(currentDir.getName());
                }
            }
            catch (IOException e) {
                CVSGrab.getLog().warn("Cannot read file " + webRepositoryAdmin.getAbsolutePath(), e);
            }
        }
        if ((rootAdmin = new File(this._destDir, "CVS/Root")).exists() && this._cvsRoot.equals(DUMMY_ROOT)) {
            try {
                FileReader reader = new FileReader(rootAdmin);
                LineNumberReader lnReader = new LineNumberReader(reader);
                this._cvsRoot = lnReader.readLine();
            }
            catch (IOException e) {
                CVSGrab.getLog().warn("Cannot read file " + rootAdmin.getAbsolutePath(), e);
            }
        }
    }

    private void printHeader() {
        if (CVSGrab.getLog().isInfoEnabled()) {
            CVSGrab.getLog().info("CVSGrab version 2.3 starting...");
        } else {
            System.out.println("CVSGrab version 2.3 starting...");
        }
    }

    private CvsWebInterface detectWebInterface() {
        CvsWebInterface webInterface = null;
        try {
            webInterface = CvsWebInterface.findInterface(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return webInterface;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

