require "spec"
require "crystal/compiler_rt/shift"
require "./spec_helper"

# Ported from https://github.com/llvm/llvm-project/blob/ce59ccd04023cab3a837da14079ca2dcbfebb70c/compiler-rt/test/builtins/Unit/ashlti3_test.c

it ".__ashlti3" do
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 0).should eq make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 1).should eq make_ti(0xFDB97530ECA8642B, 0xFDB97530ECA8642A)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 2).should eq make_ti(0xFB72EA61D950C857, 0xFB72EA61D950C854)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 3).should eq make_ti(0xF6E5D4C3B2A190AF, 0xF6E5D4C3B2A190A8)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 4).should eq make_ti(0xEDCBA9876543215F, 0xEDCBA98765432150)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 28).should eq make_ti(0x876543215FEDCBA9, 0x8765432150000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 29).should eq make_ti(0x0ECA8642BFDB9753, 0x0ECA8642A0000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 30).should eq make_ti(0x1D950C857FB72EA6, 0x1D950C8540000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 31).should eq make_ti(0x3B2A190AFF6E5D4C, 0x3B2A190A80000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 32).should eq make_ti(0x76543215FEDCBA98, 0x7654321500000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 33).should eq make_ti(0xECA8642BFDB97530, 0xECA8642A00000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 34).should eq make_ti(0xD950C857FB72EA61, 0xD950C85400000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 35).should eq make_ti(0xB2A190AFF6E5D4C3, 0xB2A190A800000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 36).should eq make_ti(0x6543215FEDCBA987, 0x6543215000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 60).should eq make_ti(0x5FEDCBA987654321, 0x5000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 61).should eq make_ti(0xBFDB97530ECA8642, 0xA000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 62).should eq make_ti(0x7FB72EA61D950C85, 0x4000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 63).should eq make_ti(0xFF6E5D4C3B2A190A, 0x8000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 64).should eq make_ti(0xFEDCBA9876543215, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 65).should eq make_ti(0xFDB97530ECA8642A, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 66).should eq make_ti(0xFB72EA61D950C854, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 67).should eq make_ti(0xF6E5D4C3B2A190A8, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 68).should eq make_ti(0xEDCBA98765432150, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 92).should eq make_ti(0x8765432150000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 93).should eq make_ti(0x0ECA8642A0000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 94).should eq make_ti(0x1D950C8540000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 95).should eq make_ti(0x3B2A190A80000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 96).should eq make_ti(0x7654321500000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 97).should eq make_ti(0xECA8642A00000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 98).should eq make_ti(0xD950C85400000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 99).should eq make_ti(0xB2A190A800000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 100).should eq make_ti(0x6543215000000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 124).should eq make_ti(0x5000000000000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 125).should eq make_ti(0xA000000000000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 126).should eq make_ti(0x4000000000000000, 0x0000000000000000)
  __ashlti3(make_ti(0xFEDCBA9876543215, 0xFEDCBA9876543215), 127).should eq make_ti(0x8000000000000000, 0x0000000000000000)
end
