/*
* Copyright (c) 2021-2023 Golubchikov Mihail <https://github.com/rue-ryuzaki>
*/

#include <argparse/argparse.hpp>

#include "./catch-define.h"

TEST_CASE("1. split to args", "[detail]")
{
    SECTION("1.1. without quotes") {
        REQUIRE(argparse::detail::_split_to_args("").empty());
        REQUIRE(argparse::detail::_split_to_args("abc").size() == 1);
        REQUIRE(argparse::detail::_split_to_args("abc xyz").size() == 2);
        REQUIRE(argparse::detail::_split_to_args("abc\\ xyz").size() == 1);
        REQUIRE(argparse::detail::_split_to_args("-f=abc xyz").size() == 2);
    }

    SECTION("1.2. with quotes") {
        REQUIRE(argparse::detail::_split_to_args("Homer's dog").size() == 2);
        REQUIRE(argparse::detail::_split_to_args("Homer's\\ dog").size() == 1);
        REQUIRE(argparse::detail::_split_to_args("'Homer's dog'").size() == 1);
        REQUIRE(argparse::detail::_split_to_args("-f='Homer's dog'").size() == 1);
    }
}

TEST_CASE("2. type name", "[detail]")
{
    SECTION("2.1. current type") {
        REQUIRE(argparse::detail::Type::name<int>() == "int");
        REQUIRE(argparse::detail::Type::name<char>() == "char");
        REQUIRE(argparse::detail::Type::name<float>() == "float");
        REQUIRE(argparse::detail::Type::name<double>() == "double");
        REQUIRE(argparse::detail::Type::name<std::string>() == "std::string");

#ifdef _ARGPARSE_CXX_11
        REQUIRE(argparse::detail::Type::name<std::array<int, 1> >() == "std::array<int, 1>");
        REQUIRE(argparse::detail::Type::name<std::forward_list<int> >() == "std::forward_list<int>");
        REQUIRE(argparse::detail::Type::name<std::tuple<int, int> >() == "std::tuple<int, int>");
        REQUIRE(argparse::detail::Type::name<std::unordered_map<int, int> >() == "std::unordered_map<int, int>");
        REQUIRE(argparse::detail::Type::name<std::unordered_multiset<int> >() == "std::unordered_multiset<int>");
        REQUIRE(argparse::detail::Type::name<std::unordered_set<int> >() == "std::unordered_set<int>");
#endif  // C++11+
        REQUIRE((argparse::detail::Type::name<std::pair<int, int> >() == "std::pair<int, int>"));
        REQUIRE((argparse::detail::Type::name<std::map<int, int> >() == "std::map<int, int>"));
        REQUIRE(argparse::detail::Type::name<std::deque<int> >() == "std::deque<int>");
        REQUIRE(argparse::detail::Type::name<std::list<int> >() == "std::list<int>");
        REQUIRE(argparse::detail::Type::name<std::multiset<int> >() == "std::multiset<int>");
        REQUIRE(argparse::detail::Type::name<std::priority_queue<int> >() == "std::priority_queue<int>");
        REQUIRE(argparse::detail::Type::name<std::set<int> >() == "std::set<int>");
        REQUIRE(argparse::detail::Type::name<std::vector<int> >() == "std::vector<int>");
        REQUIRE(argparse::detail::Type::name<std::stack<int> >() == "std::stack<int>");
        REQUIRE(argparse::detail::Type::name<std::queue<int> >() == "std::queue<int>");

#ifdef _ARGPARSE_CXX_11
        REQUIRE(argparse::detail::Type::name<std::array<std::string, 1> >() == "std::array<std::string, 1>");
        REQUIRE(argparse::detail::Type::name<std::forward_list<std::string> >() == "std::forward_list<std::string>");
        REQUIRE(argparse::detail::Type::name<std::tuple<std::string, std::string> >()
                                                                             == "std::tuple<std::string, std::string>");
        REQUIRE(argparse::detail::Type::name<std::unordered_map<std::string, std::string> >()
                                                                     == "std::unordered_map<std::string, std::string>");
        REQUIRE(argparse::detail::Type::name<std::unordered_multiset<std::string> >()
                                                                             == "std::unordered_multiset<std::string>");
        REQUIRE(argparse::detail::Type::name<std::unordered_set<std::string> >() == "std::unordered_set<std::string>");
#endif  // C++11+
        REQUIRE((argparse::detail::Type::name<std::pair<std::string, std::string> >()
                                                                             == "std::pair<std::string, std::string>"));
        REQUIRE((argparse::detail::Type::name<std::map<std::string, std::string> >()
                                                                              == "std::map<std::string, std::string>"));
        REQUIRE(argparse::detail::Type::name<std::deque<std::string> >() == "std::deque<std::string>");
        REQUIRE(argparse::detail::Type::name<std::list<std::string> >() == "std::list<std::string>");
        REQUIRE(argparse::detail::Type::name<std::multiset<std::string> >() == "std::multiset<std::string>");
        REQUIRE(argparse::detail::Type::name<std::priority_queue<std::string> >()
                                                                                 == "std::priority_queue<std::string>");
        REQUIRE(argparse::detail::Type::name<std::set<std::string> >() == "std::set<std::string>");
        REQUIRE(argparse::detail::Type::name<std::vector<std::string> >() == "std::vector<std::string>");
        REQUIRE(argparse::detail::Type::name<std::stack<std::string> >() == "std::stack<std::string>");
        REQUIRE(argparse::detail::Type::name<std::queue<std::string> >() == "std::queue<std::string>");

        REQUIRE((argparse::detail::Type::name<std::vector<std::pair<int, int> > >()
                                                                                == "std::vector<std::pair<int, int>>"));
        REQUIRE(argparse::detail::Type::name<std::vector<std::vector<int> > >() == "std::vector<std::vector<int>>");
    }

    SECTION("2.2. basic type") {
        REQUIRE(argparse::detail::Type::basic<int>() == "int");
        REQUIRE(argparse::detail::Type::basic<char>() == "char");
        REQUIRE(argparse::detail::Type::basic<float>() == "float");
        REQUIRE(argparse::detail::Type::basic<double>() == "double");
        REQUIRE(argparse::detail::Type::basic<std::string>() == "std::string");

#ifdef _ARGPARSE_CXX_11
        REQUIRE(argparse::detail::Type::basic<std::array<int, 1> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::forward_list<int> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::tuple<int, int> >() == "std::tuple<int, int>");
        REQUIRE(argparse::detail::Type::basic<std::unordered_map<int, int> >() == "std::pair<int, int>");
        REQUIRE(argparse::detail::Type::basic<std::unordered_multiset<int> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::unordered_set<int> >() == "int");
#endif  // C++11+
        REQUIRE((argparse::detail::Type::basic<std::pair<int, int> >() == "std::pair<int, int>"));
        REQUIRE((argparse::detail::Type::basic<std::map<int, int> >() == "std::pair<int, int>"));
        REQUIRE(argparse::detail::Type::basic<std::deque<int> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::list<int> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::multiset<int> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::priority_queue<int> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::set<int> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::vector<int> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::stack<int> >() == "int");
        REQUIRE(argparse::detail::Type::basic<std::queue<int> >() == "int");

#ifdef _ARGPARSE_CXX_11
        REQUIRE(argparse::detail::Type::basic<std::array<std::string, 1> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::forward_list<std::string> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::tuple<std::string, std::string> >()
                                                                             == "std::tuple<std::string, std::string>");
        REQUIRE(argparse::detail::Type::basic<std::unordered_map<std::string, std::string> >()
                                                                              == "std::pair<std::string, std::string>");
        REQUIRE(argparse::detail::Type::basic<std::unordered_multiset<std::string> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::unordered_set<std::string> >() == "std::string");
#endif  // C++11+
        REQUIRE((argparse::detail::Type::basic<std::pair<std::string, std::string> >()
                                                                             == "std::pair<std::string, std::string>"));
        REQUIRE((argparse::detail::Type::basic<std::map<std::string, std::string> >()
                                                                             == "std::pair<std::string, std::string>"));
        REQUIRE(argparse::detail::Type::basic<std::deque<std::string> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::list<std::string> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::multiset<std::string> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::priority_queue<std::string> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::set<std::string> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::vector<std::string> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::stack<std::string> >() == "std::string");
        REQUIRE(argparse::detail::Type::basic<std::queue<std::string> >() == "std::string");

        REQUIRE((argparse::detail::Type::basic<std::vector<std::pair<int, int> > >() == "std::pair<int, int>"));
        REQUIRE(argparse::detail::Type::basic<std::vector<std::vector<int> > >() == "int");
    }
}

TEST_CASE("3. utf8 to upper", "[detail]")
{
    SECTION("3.1. table symbols") {
        std::map<uint32_t, uint32_t> table_map;
        table_map[0x0061] = 0x0041;
        table_map[0x0062] = 0x0042;
        table_map[0x0063] = 0x0043;
        table_map[0x0064] = 0x0044;
        table_map[0x0065] = 0x0045;
        table_map[0x0066] = 0x0046;
        table_map[0x0067] = 0x0047;
        table_map[0x0068] = 0x0048;
        table_map[0x0069] = 0x0049;
        table_map[0x006A] = 0x004A;
        table_map[0x006B] = 0x004B;
        table_map[0x006C] = 0x004C;
        table_map[0x006D] = 0x004D;
        table_map[0x006E] = 0x004E;
        table_map[0x006F] = 0x004F;
        table_map[0x0070] = 0x0050;
        table_map[0x0071] = 0x0051;
        table_map[0x0072] = 0x0052;
        table_map[0x0073] = 0x0053;
        table_map[0x0074] = 0x0054;
        table_map[0x0075] = 0x0055;
        table_map[0x0076] = 0x0056;
        table_map[0x0077] = 0x0057;
        table_map[0x0078] = 0x0058;
        table_map[0x0079] = 0x0059;
        table_map[0x007A] = 0x005A;
        table_map[0x00E0] = 0x00C0;
        table_map[0x00E1] = 0x00C1;
        table_map[0x00E2] = 0x00C2;
        table_map[0x00E3] = 0x00C3;
        table_map[0x00E4] = 0x00C4;
        table_map[0x00E5] = 0x00C5;
        table_map[0x00E6] = 0x00C6;
        table_map[0x00E7] = 0x00C7;
        table_map[0x00E8] = 0x00C8;
        table_map[0x00E9] = 0x00C9;
        table_map[0x00EA] = 0x00CA;
        table_map[0x00EB] = 0x00CB;
        table_map[0x00EC] = 0x00CC;
        table_map[0x00ED] = 0x00CD;
        table_map[0x00EE] = 0x00CE;
        table_map[0x00EF] = 0x00CF;
        table_map[0x00F0] = 0x00D0;
        table_map[0x00F1] = 0x00D1;
        table_map[0x00F2] = 0x00D2;
        table_map[0x00F3] = 0x00D3;
        table_map[0x00F4] = 0x00D4;
        table_map[0x00F5] = 0x00D5;
        table_map[0x00F6] = 0x00D6;
        table_map[0x00F8] = 0x00D8;
        table_map[0x00F9] = 0x00D9;
        table_map[0x00FA] = 0x00DA;
        table_map[0x00FB] = 0x00DB;
        table_map[0x00FC] = 0x00DC;
        table_map[0x00FD] = 0x00DD;
        table_map[0x00FE] = 0x00DE;
        table_map[0x00FF] = 0x0178;
        table_map[0x0101] = 0x0100;
        table_map[0x0103] = 0x0102;
        table_map[0x0105] = 0x0104;
        table_map[0x0107] = 0x0106;
        table_map[0x0109] = 0x0108;
        table_map[0x010B] = 0x010A;
        table_map[0x010D] = 0x010C;
        table_map[0x010F] = 0x010E;
        table_map[0x0111] = 0x0110;
        table_map[0x0113] = 0x0112;
        table_map[0x0115] = 0x0114;
        table_map[0x0117] = 0x0116;
        table_map[0x0119] = 0x0118;
        table_map[0x011B] = 0x011A;
        table_map[0x011D] = 0x011C;
        table_map[0x011F] = 0x011E;
        table_map[0x0121] = 0x0120;
        table_map[0x0123] = 0x0122;
        table_map[0x0125] = 0x0124;
        table_map[0x0127] = 0x0126;
        table_map[0x0129] = 0x0128;
        table_map[0x012B] = 0x012A;
        table_map[0x012D] = 0x012C;
        table_map[0x012F] = 0x012E;
        table_map[0x0131] = 0x0049;
        table_map[0x0133] = 0x0132;
        table_map[0x0135] = 0x0134;
        table_map[0x0137] = 0x0136;
        table_map[0x013A] = 0x0139;
        table_map[0x013C] = 0x013B;
        table_map[0x013E] = 0x013D;
        table_map[0x0140] = 0x013F;
        table_map[0x0142] = 0x0141;
        table_map[0x0144] = 0x0143;
        table_map[0x0146] = 0x0145;
        table_map[0x0148] = 0x0147;
        table_map[0x014B] = 0x014A;
        table_map[0x014D] = 0x014C;
        table_map[0x014F] = 0x014E;
        table_map[0x0151] = 0x0150;
        table_map[0x0153] = 0x0152;
        table_map[0x0155] = 0x0154;
        table_map[0x0157] = 0x0156;

        table_map[0x0159] = 0x0158;
        table_map[0x015B] = 0x015A;
        table_map[0x015D] = 0x015C;
        table_map[0x015F] = 0x015E;
        table_map[0x0161] = 0x0160;
        table_map[0x0163] = 0x0162;
        table_map[0x0165] = 0x0164;
        table_map[0x0167] = 0x0166;
        table_map[0x0169] = 0x0168;
        table_map[0x016B] = 0x016A;
        table_map[0x016D] = 0x016C;
        table_map[0x016F] = 0x016E;
        table_map[0x0171] = 0x0170;
        table_map[0x0173] = 0x0172;
        table_map[0x0175] = 0x0174;
        table_map[0x0177] = 0x0176;
        table_map[0x017A] = 0x0179;
        table_map[0x017C] = 0x017B;
        table_map[0x017E] = 0x017D;
        table_map[0x0183] = 0x0182;
        table_map[0x0185] = 0x0184;
        table_map[0x0188] = 0x0187;
        table_map[0x018C] = 0x018B;
        table_map[0x0192] = 0x0191;
        table_map[0x0199] = 0x0198;
        table_map[0x01A1] = 0x01A0;
        table_map[0x01A3] = 0x01A2;
        table_map[0x01A5] = 0x01A4;
        table_map[0x01A8] = 0x01A7;
        table_map[0x01AD] = 0x01AC;
        table_map[0x01B0] = 0x01AF;
        table_map[0x01B4] = 0x01B3;
        table_map[0x01B6] = 0x01B5;
        table_map[0x01B9] = 0x01B8;
        table_map[0x01BD] = 0x01BC;
        table_map[0x01C6] = 0x01C4;
        table_map[0x01C9] = 0x01C7;
        table_map[0x01CC] = 0x01CA;
        table_map[0x01CE] = 0x01CD;
        table_map[0x01D0] = 0x01CF;
        table_map[0x01D2] = 0x01D1;
        table_map[0x01D4] = 0x01D3;
        table_map[0x01D6] = 0x01D5;
        table_map[0x01D8] = 0x01D7;
        table_map[0x01DA] = 0x01D9;
        table_map[0x01DC] = 0x01DB;
        table_map[0x01DF] = 0x01DE;
        table_map[0x01E1] = 0x01E0;
        table_map[0x01E3] = 0x01E2;
        table_map[0x01E5] = 0x01E4;
        table_map[0x01E7] = 0x01E6;
        table_map[0x01E9] = 0x01E8;
        table_map[0x01EB] = 0x01EA;
        table_map[0x01ED] = 0x01EC;
        table_map[0x01EF] = 0x01EE;
        table_map[0x01F3] = 0x01F1;
        table_map[0x01F5] = 0x01F4;
        table_map[0x01FB] = 0x01FA;
        table_map[0x01FD] = 0x01FC;
        table_map[0x01FF] = 0x01FE;
        table_map[0x0201] = 0x0200;
        table_map[0x0203] = 0x0202;
        table_map[0x0205] = 0x0204;
        table_map[0x0207] = 0x0206;
        table_map[0x0209] = 0x0208;
        table_map[0x020B] = 0x020A;
        table_map[0x020D] = 0x020C;
        table_map[0x020F] = 0x020E;
        table_map[0x0211] = 0x0210;
        table_map[0x0213] = 0x0212;
        table_map[0x0215] = 0x0214;
        table_map[0x0217] = 0x0216;
        table_map[0x0253] = 0x0181;
        table_map[0x0254] = 0x0186;
        table_map[0x0257] = 0x018A;
        table_map[0x0258] = 0x018E;
        table_map[0x0259] = 0x018F;
        table_map[0x025B] = 0x0190;
        table_map[0x0260] = 0x0193;
        table_map[0x0263] = 0x0194;
        table_map[0x0268] = 0x0197;
        table_map[0x0269] = 0x0196;
        table_map[0x026F] = 0x019C;
        table_map[0x0272] = 0x019D;
        table_map[0x0275] = 0x019F;
        table_map[0x0283] = 0x01A9;
        table_map[0x0288] = 0x01AE;
        table_map[0x028A] = 0x01B1;
        table_map[0x028B] = 0x01B2;
        table_map[0x0292] = 0x01B7;
        table_map[0x03AC] = 0x0386;
        table_map[0x03AD] = 0x0388;
        table_map[0x03AE] = 0x0389;
        table_map[0x03AF] = 0x038A;
        table_map[0x03B1] = 0x0391;
        table_map[0x03B2] = 0x0392;
        table_map[0x03B3] = 0x0393;
        table_map[0x03B4] = 0x0394;
        table_map[0x03B5] = 0x0395;
        table_map[0x03B6] = 0x0396;

        table_map[0x03B7] = 0x0397;
        table_map[0x03B8] = 0x0398;
        table_map[0x03B9] = 0x0399;
        table_map[0x03BA] = 0x039A;
        table_map[0x03BB] = 0x039B;
        table_map[0x03BC] = 0x039C;
        table_map[0x03BD] = 0x039D;
        table_map[0x03BE] = 0x039E;
        table_map[0x03BF] = 0x039F;
        table_map[0x03C0] = 0x03A0;
        table_map[0x03C1] = 0x03A1;
        table_map[0x03C3] = 0x03A3;
        table_map[0x03C4] = 0x03A4;
        table_map[0x03C5] = 0x03A5;
        table_map[0x03C6] = 0x03A6;
        table_map[0x03C7] = 0x03A7;
        table_map[0x03C8] = 0x03A8;
        table_map[0x03C9] = 0x03A9;
        table_map[0x03CA] = 0x03AA;
        table_map[0x03CB] = 0x03AB;
        table_map[0x03CC] = 0x038C;
        table_map[0x03CD] = 0x038E;
        table_map[0x03CE] = 0x038F;
        table_map[0x03E3] = 0x03E2;
        table_map[0x03E5] = 0x03E4;
        table_map[0x03E7] = 0x03E6;
        table_map[0x03E9] = 0x03E8;
        table_map[0x03EB] = 0x03EA;
        table_map[0x03ED] = 0x03EC;
        table_map[0x03EF] = 0x03EE;
        table_map[0x0430] = 0x0410;
        table_map[0x0431] = 0x0411;
        table_map[0x0432] = 0x0412;
        table_map[0x0433] = 0x0413;
        table_map[0x0434] = 0x0414;
        table_map[0x0435] = 0x0415;
        table_map[0x0436] = 0x0416;
        table_map[0x0437] = 0x0417;
        table_map[0x0438] = 0x0418;
        table_map[0x0439] = 0x0419;
        table_map[0x043A] = 0x041A;
        table_map[0x043B] = 0x041B;
        table_map[0x043C] = 0x041C;
        table_map[0x043D] = 0x041D;
        table_map[0x043E] = 0x041E;
        table_map[0x043F] = 0x041F;
        table_map[0x0440] = 0x0420;
        table_map[0x0441] = 0x0421;
        table_map[0x0442] = 0x0422;
        table_map[0x0443] = 0x0423;
        table_map[0x0444] = 0x0424;
        table_map[0x0445] = 0x0425;
        table_map[0x0446] = 0x0426;
        table_map[0x0447] = 0x0427;
        table_map[0x0448] = 0x0428;
        table_map[0x0449] = 0x0429;
        table_map[0x044A] = 0x042A;
        table_map[0x044B] = 0x042B;
        table_map[0x044C] = 0x042C;
        table_map[0x044D] = 0x042D;
        table_map[0x044E] = 0x042E;
        table_map[0x044F] = 0x042F;
        table_map[0x0451] = 0x0401;
        table_map[0x0452] = 0x0402;
        table_map[0x0453] = 0x0403;
        table_map[0x0454] = 0x0404;
        table_map[0x0455] = 0x0405;
        table_map[0x0456] = 0x0406;
        table_map[0x0457] = 0x0407;
        table_map[0x0458] = 0x0408;
        table_map[0x0459] = 0x0409;
        table_map[0x045A] = 0x040A;
        table_map[0x045B] = 0x040B;
        table_map[0x045C] = 0x040C;
        table_map[0x045D] = 0x040D; // !
        table_map[0x045E] = 0x040E;
        table_map[0x045F] = 0x040F;
        table_map[0x0461] = 0x0460;
        table_map[0x0463] = 0x0462;
        table_map[0x0465] = 0x0464;
        table_map[0x0467] = 0x0466;
        table_map[0x0469] = 0x0468;
        table_map[0x046B] = 0x046A;
        table_map[0x046D] = 0x046C;
        table_map[0x046F] = 0x046E;
        table_map[0x0471] = 0x0470;
        table_map[0x0473] = 0x0472;
        table_map[0x0475] = 0x0474;
        table_map[0x0477] = 0x0476;
        table_map[0x0479] = 0x0478;
        table_map[0x047B] = 0x047A;
        table_map[0x047D] = 0x047C;
        table_map[0x047F] = 0x047E;
        table_map[0x0481] = 0x0480;
        table_map[0x0491] = 0x0490;
        table_map[0x0493] = 0x0492;
        table_map[0x0495] = 0x0494;
        table_map[0x0497] = 0x0496;
        table_map[0x0499] = 0x0498;
        table_map[0x049B] = 0x049A;
        table_map[0x049D] = 0x049C;

        table_map[0x049F] = 0x049E;
        table_map[0x04A1] = 0x04A0;
        table_map[0x04A3] = 0x04A2;
        table_map[0x04A5] = 0x04A4;
        table_map[0x04A7] = 0x04A6;
        table_map[0x04A9] = 0x04A8;
        table_map[0x04AB] = 0x04AA;
        table_map[0x04AD] = 0x04AC;
        table_map[0x04AF] = 0x04AE;
        table_map[0x04B1] = 0x04B0;
        table_map[0x04B3] = 0x04B2;
        table_map[0x04B5] = 0x04B4;
        table_map[0x04B7] = 0x04B6;
        table_map[0x04B9] = 0x04B8;
        table_map[0x04BB] = 0x04BA;
        table_map[0x04BD] = 0x04BC;
        table_map[0x04BF] = 0x04BE;
        table_map[0x04C2] = 0x04C1;
        table_map[0x04C4] = 0x04C3;
        table_map[0x04C8] = 0x04C7;
        table_map[0x04CC] = 0x04CB;
        table_map[0x04D1] = 0x04D0;
        table_map[0x04D3] = 0x04D2;
        table_map[0x04D5] = 0x04D4;
        table_map[0x04D7] = 0x04D6;
        table_map[0x04D9] = 0x04D8;
        table_map[0x04DB] = 0x04DA;
        table_map[0x04DD] = 0x04DC;
        table_map[0x04DF] = 0x04DE;
        table_map[0x04E1] = 0x04E0;
        table_map[0x04E3] = 0x04E2;
        table_map[0x04E5] = 0x04E4;
        table_map[0x04E7] = 0x04E6;
        table_map[0x04E9] = 0x04E8;
        table_map[0x04EB] = 0x04EA;
        table_map[0x04EF] = 0x04EE;
        table_map[0x04F1] = 0x04F0;
        table_map[0x04F3] = 0x04F2;
        table_map[0x04F5] = 0x04F4;
        table_map[0x04F7] = 0x04F6;
        table_map[0x04F9] = 0x04F8;
        table_map[0x0561] = 0x0531;
        table_map[0x0562] = 0x0532;
        table_map[0x0563] = 0x0533;
        table_map[0x0564] = 0x0534;
        table_map[0x0565] = 0x0535;
        table_map[0x0566] = 0x0536;
        table_map[0x0567] = 0x0537;
        table_map[0x0568] = 0x0538;
        table_map[0x0569] = 0x0539;
        table_map[0x056A] = 0x053A;
        table_map[0x056B] = 0x053B;
        table_map[0x056C] = 0x053C;
        table_map[0x056D] = 0x053D;
        table_map[0x056E] = 0x053E;
        table_map[0x056F] = 0x053F;
        table_map[0x0570] = 0x0540;
        table_map[0x0571] = 0x0541;
        table_map[0x0572] = 0x0542;
        table_map[0x0573] = 0x0543;
        table_map[0x0574] = 0x0544;
        table_map[0x0575] = 0x0545;
        table_map[0x0576] = 0x0546;
        table_map[0x0577] = 0x0547;
        table_map[0x0578] = 0x0548;
        table_map[0x0579] = 0x0549;
        table_map[0x057A] = 0x054A;
        table_map[0x057B] = 0x054B;
        table_map[0x057C] = 0x054C;
        table_map[0x057D] = 0x054D;
        table_map[0x057E] = 0x054E;
        table_map[0x057F] = 0x054F;
        table_map[0x0580] = 0x0550;
        table_map[0x0581] = 0x0551;
        table_map[0x0582] = 0x0552;
        table_map[0x0583] = 0x0553;
        table_map[0x0584] = 0x0554;
        table_map[0x0585] = 0x0555;
        table_map[0x0586] = 0x0556;
        table_map[0x10D0] = 0x10A0;
        table_map[0x10D1] = 0x10A1;
        table_map[0x10D2] = 0x10A2;
        table_map[0x10D3] = 0x10A3;
        table_map[0x10D4] = 0x10A4;
        table_map[0x10D5] = 0x10A5;
        table_map[0x10D6] = 0x10A6;
        table_map[0x10D7] = 0x10A7;
        table_map[0x10D8] = 0x10A8;
        table_map[0x10D9] = 0x10A9;
        table_map[0x10DA] = 0x10AA;
        table_map[0x10DB] = 0x10AB;
        table_map[0x10DC] = 0x10AC;
        table_map[0x10DD] = 0x10AD;
        table_map[0x10DE] = 0x10AE;
        table_map[0x10DF] = 0x10AF;
        table_map[0x10E0] = 0x10B0;
        table_map[0x10E1] = 0x10B1;
        table_map[0x10E2] = 0x10B2;
        table_map[0x10E3] = 0x10B3;
        table_map[0x10E4] = 0x10B4;
        table_map[0x10E5] = 0x10B5;

        table_map[0x10E6] = 0x10B6;
        table_map[0x10E7] = 0x10B7;
        table_map[0x10E8] = 0x10B8;
        table_map[0x10E9] = 0x10B9;
        table_map[0x10EA] = 0x10BA;
        table_map[0x10EB] = 0x10BB;
        table_map[0x10EC] = 0x10BC;
        table_map[0x10ED] = 0x10BD;
        table_map[0x10EE] = 0x10BE;
        table_map[0x10EF] = 0x10BF;
        table_map[0x10F0] = 0x10C0;
        table_map[0x10F1] = 0x10C1;
        table_map[0x10F2] = 0x10C2;
        table_map[0x10F3] = 0x10C3;
        table_map[0x10F4] = 0x10C4;
        table_map[0x10F5] = 0x10C5;
        table_map[0x1E01] = 0x1E00;
        table_map[0x1E03] = 0x1E02;
        table_map[0x1E05] = 0x1E04;
        table_map[0x1E07] = 0x1E06;
        table_map[0x1E09] = 0x1E08;
        table_map[0x1E0B] = 0x1E0A;
        table_map[0x1E0D] = 0x1E0C;
        table_map[0x1E0F] = 0x1E0E;
        table_map[0x1E11] = 0x1E10;
        table_map[0x1E13] = 0x1E12;
        table_map[0x1E15] = 0x1E14;
        table_map[0x1E17] = 0x1E16;
        table_map[0x1E19] = 0x1E18;
        table_map[0x1E1B] = 0x1E1A;
        table_map[0x1E1D] = 0x1E1C;
        table_map[0x1E1F] = 0x1E1E;
        table_map[0x1E21] = 0x1E20;
        table_map[0x1E23] = 0x1E22;
        table_map[0x1E25] = 0x1E24;
        table_map[0x1E27] = 0x1E26;
        table_map[0x1E29] = 0x1E28;
        table_map[0x1E2B] = 0x1E2A;
        table_map[0x1E2D] = 0x1E2C;
        table_map[0x1E2F] = 0x1E2E;
        table_map[0x1E31] = 0x1E30;
        table_map[0x1E33] = 0x1E32;
        table_map[0x1E35] = 0x1E34;
        table_map[0x1E37] = 0x1E36;
        table_map[0x1E39] = 0x1E38;
        table_map[0x1E3B] = 0x1E3A;
        table_map[0x1E3D] = 0x1E3C;
        table_map[0x1E3F] = 0x1E3E;
        table_map[0x1E41] = 0x1E40;
        table_map[0x1E43] = 0x1E42;
        table_map[0x1E45] = 0x1E44;
        table_map[0x1E47] = 0x1E46;
        table_map[0x1E49] = 0x1E48;
        table_map[0x1E4B] = 0x1E4A;
        table_map[0x1E4D] = 0x1E4C;
        table_map[0x1E4F] = 0x1E4E;
        table_map[0x1E51] = 0x1E50;
        table_map[0x1E53] = 0x1E52;
        table_map[0x1E55] = 0x1E54;
        table_map[0x1E57] = 0x1E56;
        table_map[0x1E59] = 0x1E58;
        table_map[0x1E5B] = 0x1E5A;
        table_map[0x1E5D] = 0x1E5C;
        table_map[0x1E5F] = 0x1E5E;
        table_map[0x1E61] = 0x1E60;
        table_map[0x1E63] = 0x1E62;
        table_map[0x1E65] = 0x1E64;
        table_map[0x1E67] = 0x1E66;
        table_map[0x1E69] = 0x1E68;
        table_map[0x1E6B] = 0x1E6A;
        table_map[0x1E6D] = 0x1E6C;
        table_map[0x1E6F] = 0x1E6E;
        table_map[0x1E71] = 0x1E70;
        table_map[0x1E73] = 0x1E72;
        table_map[0x1E75] = 0x1E74;
        table_map[0x1E77] = 0x1E76;
        table_map[0x1E79] = 0x1E78;
        table_map[0x1E7B] = 0x1E7A;
        table_map[0x1E7D] = 0x1E7C;
        table_map[0x1E7F] = 0x1E7E;
        table_map[0x1E81] = 0x1E80;
        table_map[0x1E83] = 0x1E82;
        table_map[0x1E85] = 0x1E84;
        table_map[0x1E87] = 0x1E86;
        table_map[0x1E89] = 0x1E88;
        table_map[0x1E8B] = 0x1E8A;
        table_map[0x1E8D] = 0x1E8C;
        table_map[0x1E8F] = 0x1E8E;
        table_map[0x1E91] = 0x1E90;
        table_map[0x1E93] = 0x1E92;
        table_map[0x1E95] = 0x1E94;
        table_map[0x1EA1] = 0x1EA0;
        table_map[0x1EA3] = 0x1EA2;
        table_map[0x1EA5] = 0x1EA4;
        table_map[0x1EA7] = 0x1EA6;
        table_map[0x1EA9] = 0x1EA8;
        table_map[0x1EAB] = 0x1EAA;
        table_map[0x1EAD] = 0x1EAC;
        table_map[0x1EAF] = 0x1EAE;
        table_map[0x1EB1] = 0x1EB0;

        table_map[0x1EB3] = 0x1EB2;
        table_map[0x1EB5] = 0x1EB4;
        table_map[0x1EB7] = 0x1EB6;
        table_map[0x1EB9] = 0x1EB8;
        table_map[0x1EBB] = 0x1EBA;
        table_map[0x1EBD] = 0x1EBC;
        table_map[0x1EBF] = 0x1EBE;
        table_map[0x1EC1] = 0x1EC0;
        table_map[0x1EC3] = 0x1EC2;
        table_map[0x1EC5] = 0x1EC4;
        table_map[0x1EC7] = 0x1EC6;
        table_map[0x1EC9] = 0x1EC8;
        table_map[0x1ECB] = 0x1ECA;
        table_map[0x1ECD] = 0x1ECC;
        table_map[0x1ECF] = 0x1ECE;
        table_map[0x1ED1] = 0x1ED0;
        table_map[0x1ED3] = 0x1ED2;
        table_map[0x1ED5] = 0x1ED4;
        table_map[0x1ED7] = 0x1ED6;
        table_map[0x1ED9] = 0x1ED8;
        table_map[0x1EDB] = 0x1EDA;
        table_map[0x1EDD] = 0x1EDC;
        table_map[0x1EDF] = 0x1EDE;
        table_map[0x1EE1] = 0x1EE0;
        table_map[0x1EE3] = 0x1EE2;
        table_map[0x1EE5] = 0x1EE4;
        table_map[0x1EE7] = 0x1EE6;
        table_map[0x1EE9] = 0x1EE8;
        table_map[0x1EEB] = 0x1EEA;
        table_map[0x1EED] = 0x1EEC;
        table_map[0x1EEF] = 0x1EEE;
        table_map[0x1EF1] = 0x1EF0;
        table_map[0x1EF3] = 0x1EF2;
        table_map[0x1EF5] = 0x1EF4;
        table_map[0x1EF7] = 0x1EF6;
        table_map[0x1EF9] = 0x1EF8;
        table_map[0x1F00] = 0x1F08;
        table_map[0x1F01] = 0x1F09;
        table_map[0x1F02] = 0x1F0A;
        table_map[0x1F03] = 0x1F0B;
        table_map[0x1F04] = 0x1F0C;
        table_map[0x1F05] = 0x1F0D;
        table_map[0x1F06] = 0x1F0E;
        table_map[0x1F07] = 0x1F0F;
        table_map[0x1F10] = 0x1F18;
        table_map[0x1F11] = 0x1F19;
        table_map[0x1F12] = 0x1F1A;
        table_map[0x1F13] = 0x1F1B;
        table_map[0x1F14] = 0x1F1C;
        table_map[0x1F15] = 0x1F1D;
        table_map[0x1F20] = 0x1F28;
        table_map[0x1F21] = 0x1F29;
        table_map[0x1F22] = 0x1F2A;
        table_map[0x1F23] = 0x1F2B;
        table_map[0x1F24] = 0x1F2C;
        table_map[0x1F25] = 0x1F2D;
        table_map[0x1F26] = 0x1F2E;
        table_map[0x1F27] = 0x1F2F;
        table_map[0x1F30] = 0x1F38;
        table_map[0x1F31] = 0x1F39;
        table_map[0x1F32] = 0x1F3A;
        table_map[0x1F33] = 0x1F3B;
        table_map[0x1F34] = 0x1F3C;
        table_map[0x1F35] = 0x1F3D;
        table_map[0x1F36] = 0x1F3E;
        table_map[0x1F37] = 0x1F3F;
        table_map[0x1F40] = 0x1F48;
        table_map[0x1F41] = 0x1F49;
        table_map[0x1F42] = 0x1F4A;
        table_map[0x1F43] = 0x1F4B;
        table_map[0x1F44] = 0x1F4C;
        table_map[0x1F45] = 0x1F4D;
        table_map[0x1F51] = 0x1F59;
        table_map[0x1F53] = 0x1F5B;
        table_map[0x1F55] = 0x1F5D;
        table_map[0x1F57] = 0x1F5F;
        table_map[0x1F60] = 0x1F68;
        table_map[0x1F61] = 0x1F69;
        table_map[0x1F62] = 0x1F6A;
        table_map[0x1F63] = 0x1F6B;
        table_map[0x1F64] = 0x1F6C;
        table_map[0x1F65] = 0x1F6D;
        table_map[0x1F66] = 0x1F6E;
        table_map[0x1F67] = 0x1F6F;
        table_map[0x1F80] = 0x1F88;
        table_map[0x1F81] = 0x1F89;
        table_map[0x1F82] = 0x1F8A;
        table_map[0x1F83] = 0x1F8B;
        table_map[0x1F84] = 0x1F8C;
        table_map[0x1F85] = 0x1F8D;
        table_map[0x1F86] = 0x1F8E;
        table_map[0x1F87] = 0x1F8F;
        table_map[0x1F90] = 0x1F98;
        table_map[0x1F91] = 0x1F99;
        table_map[0x1F92] = 0x1F9A;
        table_map[0x1F93] = 0x1F9B;
        table_map[0x1F94] = 0x1F9C;
        table_map[0x1F95] = 0x1F9D;
        table_map[0x1F96] = 0x1F9E;
        table_map[0x1F97] = 0x1F9F;

        table_map[0x1FA0] = 0x1FA8;
        table_map[0x1FA1] = 0x1FA9;
        table_map[0x1FA2] = 0x1FAA;
        table_map[0x1FA3] = 0x1FAB;
        table_map[0x1FA4] = 0x1FAC;
        table_map[0x1FA5] = 0x1FAD;
        table_map[0x1FA6] = 0x1FAE;
        table_map[0x1FA7] = 0x1FAF;
        table_map[0x1FB0] = 0x1FB8;
        table_map[0x1FB1] = 0x1FB9;
        table_map[0x1FD0] = 0x1FD8;
        table_map[0x1FD1] = 0x1FD9;
        table_map[0x1FE0] = 0x1FE8;
        table_map[0x1FE1] = 0x1FE9;
        table_map[0x24D0] = 0x24B6;
        table_map[0x24D1] = 0x24B7;
        table_map[0x24D2] = 0x24B8;
        table_map[0x24D3] = 0x24B9;
        table_map[0x24D4] = 0x24BA;
        table_map[0x24D5] = 0x24BB;
        table_map[0x24D6] = 0x24BC;
        table_map[0x24D7] = 0x24BD;
        table_map[0x24D8] = 0x24BE;
        table_map[0x24D9] = 0x24BF;
        table_map[0x24DA] = 0x24C0;
        table_map[0x24DB] = 0x24C1;
        table_map[0x24DC] = 0x24C2;
        table_map[0x24DD] = 0x24C3;
        table_map[0x24DE] = 0x24C4;
        table_map[0x24DF] = 0x24C5;
        table_map[0x24E0] = 0x24C6;
        table_map[0x24E1] = 0x24C7;
        table_map[0x24E2] = 0x24C8;
        table_map[0x24E3] = 0x24C9;
        table_map[0x24E4] = 0x24CA;
        table_map[0x24E5] = 0x24CB;
        table_map[0x24E6] = 0x24CC;
        table_map[0x24E7] = 0x24CD;
        table_map[0x24E8] = 0x24CE;
        table_map[0x24E9] = 0x24CF;
        table_map[0xFF41] = 0xFF21;
        table_map[0xFF42] = 0xFF22;
        table_map[0xFF43] = 0xFF23;
        table_map[0xFF44] = 0xFF24;
        table_map[0xFF45] = 0xFF25;
        table_map[0xFF46] = 0xFF26;
        table_map[0xFF47] = 0xFF27;
        table_map[0xFF48] = 0xFF28;
        table_map[0xFF49] = 0xFF29;
        table_map[0xFF4A] = 0xFF2A;
        table_map[0xFF4B] = 0xFF2B;
        table_map[0xFF4C] = 0xFF2C;
        table_map[0xFF4D] = 0xFF2D;
        table_map[0xFF4E] = 0xFF2E;
        table_map[0xFF4F] = 0xFF2F;
        table_map[0xFF50] = 0xFF30;
        table_map[0xFF51] = 0xFF31;
        table_map[0xFF52] = 0xFF32;
        table_map[0xFF53] = 0xFF33;
        table_map[0xFF54] = 0xFF34;
        table_map[0xFF55] = 0xFF35;
        table_map[0xFF56] = 0xFF36;
        table_map[0xFF57] = 0xFF37;
        table_map[0xFF58] = 0xFF38;
        table_map[0xFF59] = 0xFF39;
        table_map[0xFF5A] = 0xFF3A;
        for (uint32_t i = 0; i < 0xffff; ++i) {
            if (table_map.count(i) == 0) {
                REQUIRE(argparse::detail::_to_upper_codepoint(i) == i);
            }
        }
        for (std::map<uint32_t, uint32_t>::const_iterator it = table_map.begin(); it != table_map.end(); ++it) {
            REQUIRE(argparse::detail::_to_upper_codepoint(it->first) == it->second);
        }
    }
}
