/*
 *  Copyright (c) 2012 Daisuke Okanohara
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *   1. Redistributions of source code must retain the above Copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above Copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   3. Neither the name of the authors nor the names of its contributors
 *      may be used to endorse or promote products derived from this
 *      software without specific prior written permission.
 */

#include <gtest/gtest.h>
#include <sstream>
#include "BitVec.hpp"

using namespace cpi00;
using namespace std;

TEST(BitVec, trivial){
  BitVec bv;
  ASSERT_EQ(0, bv.num());
  ASSERT_EQ(0, bv.one_num());
  ASSERT_EQ(0, bv.Rank1(0));
  ostringstream os;
  bv.Write(os);
  
  BitVec bv2;
  istringstream is(os.str());
  bv2.Read(is);
  ASSERT_EQ(0, bv2.num());
  ASSERT_EQ(0, bv2.one_num());
  ASSERT_EQ(0, bv2.Rank1(0));
}

TEST(BitVec, random){
  BitVec bv;
  const uint64_t N = 10000;
  vector<uint64_t> bits;
  vector<uint64_t> ranks;
  uint64_t one_num = 0;
  for (uint64_t i = 0; i < N; ++i){
    uint64_t b = rand() % 2;
    bv.PushBack(b);
    ranks.push_back(one_num);
    bits.push_back(b);
    if (b == 1){
      ++one_num;
    }
  }
  ASSERT_EQ(N, bv.num());
  ASSERT_EQ(one_num, bv.one_num());
  ASSERT_EQ(one_num, bv.Rank1(N));

  for (uint64_t i = 0; i < N; ++i){
    ASSERT_EQ(bits[i], bv.GetBit(i));
    ASSERT_EQ(ranks[i], bv.Rank1(i));
  }

  ostringstream os;
  bv.Write(os);
  bv.Clear();
  ASSERT_EQ(0, bv.num());
  ASSERT_EQ(0, bv.one_num());
  
  BitVec bv2;
  istringstream is(os.str());
  bv2.Read(is);
  ASSERT_EQ(N, bv2.num());
  ASSERT_EQ(one_num, bv2.one_num());
  ASSERT_EQ(one_num, bv2.Rank1(N));

  for (uint64_t i = 0; i < N; ++i){
    ASSERT_EQ(bits[i], bv2.GetBit(i));
    ASSERT_EQ(ranks[i], bv2.Rank1(i));
  }
}


