/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

public class CosmoClassLoader
extends ClassLoader {
    boolean debug = false;
    Hashtable cache = new Hashtable();
    URL url;
    Class clazz;
    private long javaLangObj;

    public CosmoClassLoader() {
        if (this.debug) {
            System.out.println("Cosmo Class Loader constructor-1");
        }
    }

    public synchronized void setUrl(String string) throws MalformedURLException {
        block4: {
            if (this.debug) {
                System.out.println("Cosmo Class Loader setUrl : " + string);
            }
            try {
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (!this.debug) break block4;
                System.out.println("Cosmo Class Loader setUrl: new URL threw an exception");
            }
        }
        if (this.debug) {
            System.out.println("Cosmo Class Loader returning");
        }
    }

    public CosmoClassLoader(URL uRL) {
        if (this.debug) {
            System.out.println("Cosmo Class Loader constructor-2");
        }
        this.url = uRL;
    }

    public CosmoClassLoader(String string) throws MalformedURLException {
        if (this.debug) {
            System.out.println("Cosmo Class Loader constructor-3");
        }
        this.url = new URL(string);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.debug) {
            System.out.println("Load class called for -" + string + "-");
        }
        Class<?> clazz = (Class<?>)this.cache.get(string);
        if (this.debug) {
            System.out.println("Load class trying in the cache.");
        }
        if (clazz == null) {
            block17: {
                try {
                    clazz = this.findSystemClass(string);
                }
                catch (Throwable throwable) {
                    if (!this.debug) break block17;
                    System.out.println("Loading : " + string + " find system class threw exception.");
                }
            }
            if (clazz == null) {
                try {
                    if (this.debug) {
                        System.out.println("Loading : " + string + " cache was null.");
                    }
                    byte[] byArray = this.readClassBytes(string);
                    if (this.debug) {
                        System.out.println("Loading : " + string + " read class bytes.");
                    }
                    clazz = this.defineClass(null, byArray, 0, byArray.length);
                    if (this.debug) {
                        System.out.println("Loading : " + string + " defined class.");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (this.debug) {
                        System.out.println("Looking for class -" + string + "- in the CLASSPATH");
                    }
                    try {
                        clazz = this.findSystemClass(string);
                    }
                    catch (Throwable throwable) {
                        if (this.debug) {
                            System.out.println("Loading : " + string + " find system class threw exception.");
                        }
                        return null;
                    }
                }
            }
            this.cache.put(string, clazz);
        }
        if (bl) {
            if (this.debug) {
                System.out.println("Loading : " + string + " resolving class.");
            }
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private byte[] readClassBytes(String string) throws ClassNotFoundException {
        int n = 0;
        n = string.indexOf(46);
        if (n != -1) {
            string = string.replace('.', '/');
        }
        if (this.debug) {
            System.out.println("Cosmo Class Loader readClassBytes ENTRY: " + string);
        }
        try {
            int n2;
            if (this.debug) {
                System.out.println("Cosmo Class Loader readClassBytes : " + string);
            }
            URL uRL = new URL(this.url, String.valueOf(string) + ".class");
            if (this.debug) {
                System.out.println("reading class : " + string + "created URL.");
            }
            URLConnection uRLConnection = uRL.openConnection();
            if (this.debug) {
                System.out.println("reading class : " + string + "opened connection.");
            }
            uRLConnection.connect();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[2048];
            while ((n2 = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassNotFoundException("Bad class name: " + string);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Couldn't read class " + string);
        }
    }

    static {
        try {
            System.loadLibrary("cp21_msjava");
        }
        catch (Throwable throwable) {}
    }
}

