#!/bin/bash
# -*- compile-command: "mv -f compare.v{,~} && ./gen_compare.sh" -*-
set -e

exec > compare.v

cat <<EOF
(* DO NOT EDIT THIS FILE: automatically generated by ./gen_compare.sh *)
Require Import ZArith Floats.
Local Open Scope float_scope.

Definition min_denorm := Eval compute in ldexp one (-1074)%Z.

Definition min_norm := Eval compute in ldexp one (-1024)%Z.

EOF

genTest() {
    if [ $# -ne 10 ]; then
        echo >&2 "genTest expects 10 arguments"
    fi
    TACTICS=(":" "<:" "<<:")
    OPS=("=?" "<?" "<=?" "?=")
    x="$1"
    y="$2"
    OPS1=("$3" "$4" "$5" "$6")  # for x y
    OPS2=("$7" "$8" "$9" "${10}") # for y x
    for tac in "${TACTICS[@]}"; do
        for i in {0..3}; do
            op="${OPS[$i]}"
            op1="${OPS1[$i]}"
            op2="${OPS2[$i]}"
            echo "Check (eq_refl $op1 $tac $x $op $y = $op1)."
            echo "Check (eq_refl $op2 $tac $y $op $x = $op2)."
        done
        echo
    done
}

genTest nan nan \
        false false false FNotComparable \
        false false false FNotComparable
genTest nan "- nan" \
        false false false FNotComparable \
        false false false FNotComparable

EQ=(true false true FEq \
    true false true FEq)

genTest one one "${EQ[@]}"
genTest zero zero "${EQ[@]}"
genTest zero "- zero" "${EQ[@]}"
genTest "- zero" "- zero" "${EQ[@]}"
genTest infinity infinity "${EQ[@]}"
genTest "- infinity" "- infinity" "${EQ[@]}"

LT=(false true true FLt \
    false false false FGt)

genTest min_denorm min_norm "${LT[@]}"
genTest min_denorm one "${LT[@]}"
genTest min_norm one "${LT[@]}"
genTest one infinity "${LT[@]}"
genTest "- infinity" infinity "${LT[@]}"
genTest "- infinity" one "${LT[@]}"
