'\" t
.\"     cook - file construction tool
.\"     Copyright (C) 1997-1999, 2004, 2007-2010 Peter Miller
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 3 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program. If not, see
.\"     <http://www.gnu.org/licenses/>.
.\"
.if n .ftr CB B
.if n .ftr CI I
.if n .ftr CW R
.if n .ftr C  R
.so lib/en/man1/z_name.so
.TH Release "\*(N)" "\*(N)" "Release Notes"
.ad l
.hy 0
.so etc/version.so
.de e(
.RS
.ft CW
.nf
.sp
..
.de e)
.sp
.fi
.ft R
.RE
..
.SH NAME
How to release a version of \*(N)
.SH CHECKLIST
This document describes the steps involved in issuing a new release of \*(N).
The level of detail is too much in some places, and too little in others.
.SS Verify Current Baseline
Take the \f(CWarchive/\*(n)-\*(v).tar.gz\fP file from the current
baseline.
Unpack it an verify that it configures and builds on each of the
HP/UX, SunOs, Solaris, OSF/1 and AIX flavors.
There are usually small niggling problems
(some of them are such bad UNIX implementations).
Fix the problems and try again.
.SS Cut A New Version
The releases are \fIpost-numbered\fP so that you must end the current
branch and start a new branch with the desired release number.  This
allows you to cut bug-fix sub-branches with sensible numbers when you
want to release a bug fix.
.IP \(bu 2n
Set the project to one level up, and do a develop end
on the current branch.
.IP \(bu 2n
Review it (hopefully without finding anything wrong),
.IP \(bu 2n
and the integrate it you normally would.
.IP \(bu 2n
Create a new branch for the release, and a new change on that branch.
.IP \(bu 2n
Create the change file for the last release (etc/CHANGES.\*(v)),
and the release notes file for next release (lib/en/readme/new.\*(v).so).
.IP \(bu 2n
When you integrate, use the -MINIMum option so that the version number
in the documentation is correct.  Do a full regression test.
.IP \(bu 2n
Set your default project to the new branch.
.PP
Resume these instructions once the new branch has been updated by this
change.  Then these instructions will have the new version number in
them, and you will be able to cut-and-paste from the text file straight
into the xterm session.
.br
.ne 2i
.SH UPLOAD TO THE ARCHIVES
There are two archives to upload to.
.SS Update Primary Archive
Transfer a copy to \f[CW]http://miller.emu.id.au/pmiller/\fP by rsync.
.SH NOTIFICATIONS
A couple of mailing lists and newsgroups need to be notified.
.SS Notify Mailing Lists
Send a notification to the \f[I]cook-users@lists.auug.org.au\fP and
\f[I]aegis-users@lists.auug.org.au\fP
lists.  It should look like this:
.e(
.fi
To:
'in +8n
aegis-users@lists.auug.org.au,
cook-users@lists.auug.org.au
.in -8n
.so lib/en/release/body.so
.e)
.PP
Only send this notification \f[I]after\fP the files are actually available
at the archive site.
.br
.ne 2i
.SS Update FreshMeat
Go to \f[CW]http://www.freshmeat.net/\fP and update the info for Cook.
.br
.ne 2i
.so lib/en/man1/copyright.so
