/*
 *  Copyright 2007-2012 Adrian Thurston <thurston@complang.org>
 */

#ifndef _PDACODEGEN_H
#define _PDACODEGEN_H

struct Compiler;

struct PdaCodeGen
{
	PdaCodeGen( ostream &out )
	:
		out(out)
	{}

	/*
	 * Code Generation.
	 */
	void startCodeGen();
	void endCodeGen( int endLine );

	void writeReference( Production *prod, char *data );
	void writeUndoReference( Production *prod, char *data );
	void writeFinalReference( Production *prod, char *data );
	void writeFirstLocate( Production *prod );
	void writeRhsLocate( Production *prod );

	void defineRuntime();
	void writeRuntimeData( RuntimeData *runtimeData, PdaTables *pdaTables );
	void writeParserData( long id, PdaTables *tables );

	String PARSER() { return "parser_"; }

	String startState() { return PARSER() + "startState"; }
	String indicies() { return PARSER() + "indicies"; }
	String owners() { return PARSER() + "owners"; }
	String keys() { return PARSER() + "keys"; }
	String offsets() { return PARSER() + "offsets"; }
	String targs() { return PARSER() + "targs"; }
	String actInds() { return PARSER() + "actInds"; }
	String actions() { return PARSER() + "actions"; }
	String commitLen() { return PARSER() + "commitLen"; }
	String fssProdIdIndex() { return PARSER() + "fssProdIdIndex"; }
	String prodLengths() { return PARSER() + "prodLengths"; }
	String prodLhsIds() { return PARSER() + "prodLhsIds"; }
	String prodNames() { return PARSER() + "prodNames"; }
	String lelInfo() { return PARSER() + "lelInfo"; }
	String prodInfo() { return PARSER() + "prodInfo"; }
	String tokenRegionInds() { return PARSER() + "tokenRegionInds"; }
	String tokenRegions() { return PARSER() + "tokenRegions"; }
	String tokenPreRegions() { return PARSER() + "tokenPreRegions"; }
	String prodCodeBlocks() { return PARSER() + "prodCodeBlocks"; }
	String prodCodeBlockLens() { return PARSER() + "prodCodeBlockLens"; }
	String rootCode() { return PARSER() + "rootCode"; }
	String frameInfo() { return PARSER() + "frameInfo"; }
	String functionInfo() { return PARSER() + "functionInfo"; }
	String objFieldInfo() { return PARSER() + "objFieldInfo"; }
	String patReplInfo() { return PARSER() + "patReplInfo"; }
	String patReplNodes() { return PARSER() + "patReplNodes"; }
	String regionInfo() { return PARSER() + "regionInfo"; }
	String genericInfo() { return PARSER() + "genericInfo"; }
	String litdata() { return PARSER() + "litdata"; }
	String litlen() { return PARSER() + "litlen"; }
	String literals() { return PARSER() + "literals"; }
	String fsmTables() { return PARSER() + "fsmTables"; }

	/* 
	 * Graphviz Generation
	 */
	void writeTransList( PdaState *state );
	void writeDotFile( PdaGraph *graph );
	void writeDotFile( );

	ostream &out;
};

extern "C"
{
	void internalFsmExecute( FsmRun *fsmRun, StreamImpl *inputStream );
	void internalSendNamedLangEl( Program *prg, Tree **sp, PdaRun *pdaRun,
		FsmRun *fsmRun, StreamImpl *is );
	void internalInitBindings( PdaRun *pdaRun );
	void internalPopBinding( PdaRun *pdaRun, ParseTree *parseTree );
}

#endif
