/*
  GNOME Configurator
  Copyright (C) 2002-2004 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <glib.h>
#include <gnome.h>
#include <glade/glade.h>
#include "setup-themecolors.h"
#include "gconf-convenience.h"
#include "gtkrc-util.h"

extern GString *GLADE_FILE;
extern GladeXML *main_window_xml;

void color_set_callback(GtkWidget* w, gpointer user_data)
{
  GdkColor color;
  GtkWidget *cw;
  char hex[7];
  GString *glade_name;

  glade_name = g_string_append(g_string_new("bg[NORMAL]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *bg_normal = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("bg[ACTIVE]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *bg_active = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("bg[PRELIGHT]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *bg_prelight = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("bg[SELECTED]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *bg_selected = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("bg[INSENSITIVE]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *bg_insensitive = g_string_prepend(g_string_new(hex), "#");
  

  glade_name = g_string_append(g_string_new("fg[NORMAL]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *fg_normal = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("fg[ACTIVE]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *fg_active = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("fg[PRELIGHT]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *fg_prelight = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("fg[SELECTED]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *fg_selected = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("fg[INSENSITIVE]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *fg_insensitive = g_string_prepend(g_string_new(hex), "#");
  

  glade_name = g_string_append(g_string_new("base[NORMAL]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *base_normal = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("base[ACTIVE]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *base_active = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("base[PRELIGHT]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *base_prelight = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("base[SELECTED]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *base_selected = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("base[INSENSITIVE]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *base_insensitive = g_string_prepend(g_string_new(hex), "#");
  

  glade_name = g_string_append(g_string_new("text[NORMAL]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *text_normal = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("text[ACTIVE]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *text_active = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("text[PRELIGHT]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *text_prelight = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("text[SELECTED]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *text_selected = g_string_prepend(g_string_new(hex), "#");
  
  glade_name = g_string_append(g_string_new("text[INSENSITIVE]"), "_colorbutton");
  cw = glade_xml_get_widget (main_window_xml, glade_name->str);
  gtk_color_button_get_color(GTK_COLOR_BUTTON(cw), &color);
  sprintf(hex, "%02x%02x%02x", color.red/256, color.green/256, color.blue/256);
  GString *text_insensitive = g_string_prepend(g_string_new(hex), "#");

  
  GString *homedir = g_string_new(getenv("HOME"));
  GString *gtkrc20widget = g_string_new(g_string_append(homedir, "/.gtkrc-2.0-widget_cog")->str);

  write_widget_gtkrc(gtkrc20widget->str,
		     fg_normal->str, fg_active->str, fg_prelight->str, fg_selected->str, fg_insensitive->str,
		     bg_normal->str, bg_active->str, bg_prelight->str, bg_selected->str, bg_insensitive->str,
		     base_normal->str, base_active->str, base_prelight->str, base_selected->str, base_insensitive->str,
		     text_normal->str, text_active->str, text_prelight->str, text_selected->str, text_insensitive->str);

  GtkWidget *w1 = glade_xml_get_widget (main_window_xml, "enable_themecolors_checkbutton");
  gboolean b1 = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(w1));
  if (b1)
    {
      gtkrc_apply_changes();
    }
}

void themecolor_settings_changed_callback(GtkWidget* w, gpointer user_data)
{
  GtkWidget *w1 = glade_xml_get_widget (main_window_xml, "enable_themecolors_checkbutton");
  gboolean b1 = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(w1));

  GString *homedir = g_string_new(getenv("HOME"));
  GString *gtkrc20 = g_string_new(g_string_append(homedir, "/.gtkrc-2.0")->str);

  modify_gtkrc(gtkrc20->str, b1);

  gtkrc_apply_changes();
}

void setup_colorbutton (char *name)
{
  GtkWidget *w;
  GString *glade_name = g_string_append(g_string_new(name), "_colorbutton");
  w = glade_xml_get_widget (main_window_xml, glade_name->str);

  g_signal_connect (G_OBJECT (w), "color-set",
  		    G_CALLBACK (color_set_callback),
  		    name);
  /* Set correct initial value of widget */
  GdkColor color;

  GString *homedir = g_string_new(getenv("HOME"));
  GString *gtkrc20widget = g_string_new(g_string_append(homedir, "/.gtkrc-2.0-widget_cog")->str);

  char *parse_str = get_widget_color(gtkrc20widget->str, name);
  gdk_color_parse(parse_str, &color);
  gtk_color_button_set_color (GTK_COLOR_BUTTON(w), &color);
}

void setup_themecolors ()
{
  GtkWidget *w;

  GString *homedir = g_string_new(getenv("HOME"));
  GString *gtkrc20 = g_string_new(g_string_append(homedir, "/.gtkrc-2.0")->str);

  /* Set correct initial value of widgets */
  w = glade_xml_get_widget (main_window_xml, "enable_themecolors_checkbutton");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), get_enable_colors(gtkrc20->str));
  g_signal_connect (G_OBJECT (w), "toggled",
  		    G_CALLBACK (themecolor_settings_changed_callback),
  		    NULL);

  setup_colorbutton("fg[NORMAL]");
  setup_colorbutton("fg[ACTIVE]");
  setup_colorbutton("fg[PRELIGHT]");
  setup_colorbutton("fg[SELECTED]");
  setup_colorbutton("fg[INSENSITIVE]");

  setup_colorbutton("bg[NORMAL]");
  setup_colorbutton("bg[ACTIVE]");
  setup_colorbutton("bg[PRELIGHT]");
  setup_colorbutton("bg[SELECTED]");
  setup_colorbutton("bg[INSENSITIVE]");

  setup_colorbutton("base[NORMAL]");
  setup_colorbutton("base[ACTIVE]");
  setup_colorbutton("base[PRELIGHT]");
  setup_colorbutton("base[SELECTED]");
  setup_colorbutton("base[INSENSITIVE]");

  setup_colorbutton("text[NORMAL]");
  setup_colorbutton("text[ACTIVE]");
  setup_colorbutton("text[PRELIGHT]");
  setup_colorbutton("text[SELECTED]");
  setup_colorbutton("text[INSENSITIVE]");
}
