/*
  COnfigurator for Gnome
  Copyright (C) 2002 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <glib.h>
#include <gnome.h>
#include <glade/glade.h>
#include "setup-panel.h"
#include "gconf-convenience.h"
#include "debug.h"

/* copied from gnome-panel/menu.h */
enum {
        MAIN_MENU_SYSTEM = 1<<2,
        MAIN_MENU_SYSTEM_SUB = 1<<3,
        MAIN_MENU_DISTRIBUTION = 1<<4,
        MAIN_MENU_DISTRIBUTION_SUB = 1<<5,
        MAIN_MENU_KDE = 1<<6,
        MAIN_MENU_KDE_SUB = 1<<7,
        MAIN_MENU_PANEL_SUB = 1<<13,
        MAIN_MENU_DESKTOP = 1<<14,
        MAIN_MENU_DESKTOP_SUB = 1<<15
};

extern GString *GLADE_FILE;
extern GladeXML *main_window_xml;

void int_hscale_config_notify (GConfClient *client,
			       guint        cnxn_id,
			       GConfEntry  *entry,
			       gpointer     user_data)
{
  GtkWidget *w = user_data;
 
  gtk_range_set_value (GTK_RANGE(w), gconf_value_get_int (gconf_entry_get_value (entry)));
}

void entry_hscale_value_changed_callback (GtkWidget* w, gpointer user_data)
{
  GConfClient *client;
  gint i;

  client = GCONF_CLIENT(g_object_get_data (G_OBJECT (w), "client"));
  i = gtk_range_get_value (GTK_RANGE(w));

  gconf_client_set_int (client, (gchar *) user_data, i, NULL);
}




void int_main_menu_generic_config_notify (GConfClient *client,
					 guint        cnxn_id,
					 GConfEntry  *entry,
					 gpointer     user_data,
					 gint         BIT)
{
  GtkWidget *w = user_data;
  gint i;
  gboolean b;

  i = gconf_value_get_int (gconf_entry_get_value (entry));
  b = i & BIT;

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), b);
}

void entry_bool_toggled_main_menu_generic_callback (GtkWidget* w, gpointer user_data, gint BIT)
{
  GConfClient *client;
  gboolean b;
  gint i;

  client = GCONF_CLIENT(g_object_get_data (G_OBJECT (w), "client"));
  b = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(w));
  i = gconf_client_get_int (client, (gchar *) user_data, NULL);

  if (b) {
    i |= BIT;
  }
  else {
    i &= ~BIT;
  }

  gconf_client_set_int (client, (gchar *) user_data, i, NULL);
}


void int_main_menu_system_config_notify (GConfClient *client,
					 guint        cnxn_id,
					 GConfEntry  *entry,
					 gpointer     user_data)
{
  int_main_menu_generic_config_notify (client, cnxn_id, entry, user_data, MAIN_MENU_SYSTEM);
}

void entry_bool_toggled_main_menu_system_callback (GtkWidget* w, gpointer user_data)
{
  entry_bool_toggled_main_menu_generic_callback (w, user_data, MAIN_MENU_SYSTEM);
}

void int_main_menu_system_sub_config_notify (GConfClient *client,
					     guint        cnxn_id,
					     GConfEntry  *entry,
					     gpointer     user_data)
{
  int_main_menu_generic_config_notify (client, cnxn_id, entry, user_data, MAIN_MENU_SYSTEM_SUB);
}

void entry_bool_toggled_main_menu_system_sub_callback (GtkWidget* w, gpointer user_data)
{
  entry_bool_toggled_main_menu_generic_callback (w, user_data, MAIN_MENU_SYSTEM_SUB);
}

void int_main_menu_distribution_config_notify (GConfClient *client,
					       guint        cnxn_id,
					       GConfEntry  *entry,
					       gpointer     user_data)
{
  int_main_menu_generic_config_notify (client, cnxn_id, entry, user_data, MAIN_MENU_DISTRIBUTION);
}

void entry_bool_toggled_main_menu_distribution_callback (GtkWidget* w, gpointer user_data)
{
  entry_bool_toggled_main_menu_generic_callback (w, user_data, MAIN_MENU_DISTRIBUTION);
}

void int_main_menu_distribution_sub_config_notify (GConfClient *client,
						   guint        cnxn_id,
						   GConfEntry  *entry,
						   gpointer     user_data)
{
  int_main_menu_generic_config_notify (client, cnxn_id, entry, user_data, MAIN_MENU_DISTRIBUTION_SUB);
}

void entry_bool_toggled_main_menu_distribution_sub_callback (GtkWidget* w, gpointer user_data)
{
  entry_bool_toggled_main_menu_generic_callback (w, user_data, MAIN_MENU_DISTRIBUTION_SUB);
}

void int_main_menu_kde_config_notify (GConfClient *client,
				      guint        cnxn_id,
				      GConfEntry  *entry,
				      gpointer     user_data)
{
  int_main_menu_generic_config_notify (client, cnxn_id, entry, user_data, MAIN_MENU_KDE);
}

void entry_bool_toggled_main_menu_kde_callback (GtkWidget* w, gpointer user_data)
{
  entry_bool_toggled_main_menu_generic_callback (w, user_data, MAIN_MENU_KDE);
}

void int_main_menu_kde_sub_config_notify (GConfClient *client,
					  guint        cnxn_id,
					  GConfEntry  *entry,
					  gpointer     user_data)
{
  int_main_menu_generic_config_notify (client, cnxn_id, entry, user_data, MAIN_MENU_KDE_SUB);
}

void entry_bool_toggled_main_menu_kde_sub_callback (GtkWidget* w, gpointer user_data)
{
  entry_bool_toggled_main_menu_generic_callback (w, user_data, MAIN_MENU_KDE_SUB);
}

void int_main_menu_panel_sub_config_notify (GConfClient *client,
					    guint        cnxn_id,
					    GConfEntry  *entry,
					    gpointer     user_data)
{
  int_main_menu_generic_config_notify (client, cnxn_id, entry, user_data, MAIN_MENU_PANEL_SUB);
}

void entry_bool_toggled_main_menu_panel_sub_callback (GtkWidget* w, gpointer user_data)
{
  entry_bool_toggled_main_menu_generic_callback (w, user_data, MAIN_MENU_PANEL_SUB);
}

void int_main_menu_desktop_config_notify (GConfClient *client,
					  guint        cnxn_id,
					  GConfEntry  *entry,
					  gpointer     user_data)
{
  int_main_menu_generic_config_notify (client, cnxn_id, entry, user_data, MAIN_MENU_DESKTOP);
}

void entry_bool_toggled_main_menu_desktop_callback (GtkWidget* w, gpointer user_data)
{
  entry_bool_toggled_main_menu_generic_callback (w, user_data, MAIN_MENU_DESKTOP);
}

void int_main_menu_desktop_sub_config_notify (GConfClient *client,
					      guint        cnxn_id,
					      GConfEntry  *entry,
					      gpointer     user_data)
{
  int_main_menu_generic_config_notify (client, cnxn_id, entry, user_data, MAIN_MENU_DESKTOP_SUB);
}

void entry_bool_toggled_main_menu_desktop_sub_callback (GtkWidget* w, gpointer user_data)
{
  entry_bool_toggled_main_menu_generic_callback (w, user_data, MAIN_MENU_DESKTOP_SUB);
}



gchar *get_main_menu_flags_gconf_key (gchar *root, gchar *profile)
{
  GConfClient *client;

  gchar *objects_root = NULL;
  GSList *l = NULL;

  gboolean b;
  gchar *gconf_key = NULL;
  gchar *return_val = NULL;

  /* Get the default client */
  client = gconf_client_get_default ();
  objects_root = g_strconcat (root, "/", profile, "/objects", NULL);
  l = gconf_client_all_dirs (client, objects_root, NULL);

  while (l != NULL)
    {
      /* find all objects with main-menu == true */
      gconf_key = g_strconcat (l->data, "/main-menu", NULL);
      b = gconf_client_get_bool (client, gconf_key, NULL);
      if (b) {
	return_val = g_strconcat(l->data, "/main-menu-flags", NULL);
      }
      l = g_list_next (l);
    }

  return return_val;
}


void setup_panel ()
{
  GtkWidget *w;
  gchar *gconf_key;

  /* FIXME - make this work for other profiles */ 
  gchar *current_panel_profile = "default";
  gchar *main_menu_flags_gconf_key = NULL;

  main_menu_flags_gconf_key = get_main_menu_flags_gconf_key ("/apps/panel/profiles", current_panel_profile);

  gconf_key = "/apps/panel/global/highlight_launchers_on_mouseover";
  w = glade_xml_get_widget (main_window_xml, "highlight_launchers_checkbutton");

  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }

  gconf_key = "/apps/panel/global/tooltips_enabled";
  w = glade_xml_get_widget (main_window_xml, "tooltip_checkbutton");

  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }

  gconf_key = "/apps/panel/global/confirm_panel_remove";
  w = glade_xml_get_widget (main_window_xml, "confirm_remove_checkbutton");

  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }

  gconf_key = "/apps/panel/global/panel_hide_delay";
  w = glade_xml_get_widget (main_window_xml, "hide_delay_hscale");

  if (!gconf_key_is_int (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, int_hscale_config_notify);
      g_signal_connect (G_OBJECT (w), "value_changed",
			G_CALLBACK (entry_hscale_value_changed_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_range_set_value (GTK_RANGE(w), gconf_key_get_int (gconf_key));
    }

  gconf_key = "/apps/panel/global/panel_show_delay";
  w = glade_xml_get_widget (main_window_xml, "show_delay_hscale");

  if (!gconf_key_is_int (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, int_hscale_config_notify);
      g_signal_connect (G_OBJECT (w), "value_changed",
			G_CALLBACK (entry_hscale_value_changed_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_range_set_value (GTK_RANGE(w), gconf_key_get_int (gconf_key));
    }

  gconf_key = "/apps/panel/global/panel_minimized_size";
  w = glade_xml_get_widget (main_window_xml, "minimized_panel_size_spinbutton");

  if (!gconf_key_is_int (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, int_spin_button_config_notify);
      g_signal_connect (G_OBJECT (w), "value_changed",
			G_CALLBACK (entry_spin_button_value_changed_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_spin_button_set_value (GTK_SPIN_BUTTON(w), gconf_key_get_int (gconf_key));
    }


  
/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_system_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_system_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_system_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_SYSTEM)); */
/*     } */

/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_system_sub_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_system_sub_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_system_sub_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_SYSTEM_SUB)); */
/*     } */

/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_distribution_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_distribution_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_distribution_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_DISTRIBUTION)); */
/*     } */

/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_distribution_sub_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_distribution_sub_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_distribution_sub_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_DISTRIBUTION_SUB)); */
/*     } */

/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_desktop_sub_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_desktop_sub_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_desktop_sub_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_DESKTOP_SUB)); */
/*     } */

/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_kde_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_kde_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_kde_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_KDE)); */
/*     } */

/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_kde_sub_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_kde_sub_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_kde_sub_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_KDE_SUB)); */
/*     } */

/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_panel_sub_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_panel_sub_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_panel_sub_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_PANEL_SUB)); */
/*     } */

/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_desktop_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_desktop_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_desktop_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_DESKTOP)); */
/*     } */

/*   gconf_key = main_menu_flags_gconf_key; */
/*   w = glade_xml_get_widget (main_window_xml, "main_menu_desktop_sub_checkbutton"); */

/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_main_menu_desktop_sub_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_main_menu_desktop_sub_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), (gboolean)(gconf_key_get_int (gconf_key) & MAIN_MENU_DESKTOP_SUB)); */
/*     } */

}
