/*
  GNOME Configurator
  Copyright (C) 2002-2004 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <glib.h>
#include <gnome.h>
#include <glade/glade.h>
#include "setup-gnomeui.h"
#include "gconf-convenience.h"
#include "gtkrc-util.h"

extern GString *GLADE_FILE;
extern GladeXML *main_window_xml;

gboolean scrollbar_settings_changed_callback(GtkWidget* w, gpointer user_data)
{
  GtkWidget *w1 = glade_xml_get_widget (main_window_xml, "scrollbar_has_backward_stepper_checkbutton");
  gboolean b1 = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(w1));
  GtkWidget *w2 = glade_xml_get_widget (main_window_xml, "scrollbar_has_secondary_backward_stepper_checkbutton");
  gboolean b2 = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(w2));
  GtkWidget *w3 = glade_xml_get_widget (main_window_xml, "min_slider_length_spinbutton");
  int i3 = gtk_spin_button_get_value (GTK_SPIN_BUTTON(w3));

  GString *homedir = g_string_new(getenv("HOME"));
  GString *gtkrc20scrollbar = g_string_new(g_string_append(homedir, "/.gtkrc-2.0-scrollbar_cog")->str);
  write_scrollbar_gtkrc(gtkrc20scrollbar->str, i3, b1, b2);

  gtkrc_apply_changes();

  return FALSE;
}

void setup_gnomeui ()
{
  GtkWidget *w;
  gchar *gconf_key;

  gconf_key = "/desktop/gnome/interface/menubar_detachable";
  w = glade_xml_get_widget (main_window_xml, "menubars_detach_checkbutton");

  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }

  gconf_key = "/desktop/gnome/interface/menus_have_tearoff";
  w = glade_xml_get_widget (main_window_xml, "submenus_torn_checkbutton");

  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }



  gconf_key = "/desktop/gnome/interface/can_change_accels";
  w = glade_xml_get_widget (main_window_xml, "can_change_accels_checkbutton");

  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }

  gconf_key = "/apps/panel/profiles/default/general/enable_program_list";
  w = glade_xml_get_widget (main_window_xml, "run_applications_show_apps_checkbutton");

  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }


  GString *homedir = g_string_new(getenv("HOME"));
  GString *gtkrc20 = g_string_new(g_string_append(homedir, "/.gtkrc-2.0")->str);
  homedir = g_string_new(getenv("HOME"));
  GString *gtkrc20scrollbar = g_string_new(g_string_append(homedir, "/.gtkrc-2.0-scrollbar_cog")->str);

  modify_gtkrc(gtkrc20->str, get_enable_colors(gtkrc20->str));

  /* Set correct initial value of widgets */
  w = glade_xml_get_widget (main_window_xml, "scrollbar_has_backward_stepper_checkbutton");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), get_scrollbar_has_backward_stepper(gtkrc20scrollbar->str));
  w = glade_xml_get_widget (main_window_xml, "scrollbar_has_secondary_backward_stepper_checkbutton");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), get_scrollbar_has_secondary_backward_stepper(gtkrc20scrollbar->str));
  w = glade_xml_get_widget (main_window_xml, "min_slider_length_spinbutton");
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(w), get_scrollbar_slider_length(gtkrc20scrollbar->str));

  /* hookup signals */
  w = glade_xml_get_widget (main_window_xml, "scrollbar_has_backward_stepper_checkbutton");
  g_signal_connect (G_OBJECT (w), "toggled",
  		    G_CALLBACK (scrollbar_settings_changed_callback),
  		    NULL);


  w = glade_xml_get_widget (main_window_xml, "scrollbar_has_secondary_backward_stepper_checkbutton");
  g_signal_connect (G_OBJECT (w), "toggled",
  		    G_CALLBACK (scrollbar_settings_changed_callback),
  		    NULL);


  w = glade_xml_get_widget (main_window_xml, "min_slider_length_spinbutton");
  g_signal_connect (G_OBJECT (w), "changed",
  		    G_CALLBACK (scrollbar_settings_changed_callback),
  		    NULL);
  //g_signal_connect (G_OBJECT (w), "focus_out_event",
  //		    G_CALLBACK (scrollbar_settings_changed_callback),
  //		    NULL);
}
