/*
  COnfigurator for Gnome
  Copyright (C) 2002 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <glib.h>
#include <gnome.h>
#include <glade/glade.h>
#include "setup-galeon-general.h"
#include "gconf-convenience.h"

extern GString *GLADE_FILE;
extern GladeXML *main_window_xml;


#define GALEON_UA      = "Galeon";
#define MOZILLA_50_UA  = "Mozilla/5.0 (Linux i586; U)";
#define MOZIlLA_478_UA = "Mozilla/4.78 (Linux i586; U)";
#define MOZILLA_30_UA  = "Mozilla/3.0 (Linux i586; U)";
#define OPERA_603_UA   = "Opera/6.03 (Linux i586; U)";
#define MSIE_50_UA     = "Mozilla/4.0 (compatible; MSIE 5.0; Linux i586)";


gchar *i2ua (gint i)
{
  gchar *return_val;

  switch (i)
    {
    case 0:
      return_val = "Galeon";
      break;
    case 1:
      return_val = "Mozilla/5.0 (Linux i586; U)";
      break;
    case 2:
      return_val = "Mozilla/4.78 (Linux i586; U)";
      break;
    case 3: 
      return_val = "Mozilla/3.0 (Linux i586; U)";
      break;
    case 4: 
      return_val = "Opera/6.03 (Linux i586; U)";
      break;
    case 5:
      return_val = "Mozilla/4.0 (compatible; MSIE 5.0; Linux i586)";
      break;
    default:
      return_val = "Galeon";
      break;
    }
    
  return return_val;
}

gint ua2i (gchar *ua)
{
  gint return_val;

  if (strcmp (ua, "Galeon") == 0)
    return_val = 0;
  else if (strcmp (ua, "Mozilla/5.0 (Linux i586; U)") == 0)
    return_val = 1;
  else if (strcmp (ua, "Mozilla/4.78 (Linux i586; U)") == 0)
    return_val = 2;
  else if (strcmp (ua, "Mozilla/3.0 (Linux i586; U)") == 0)
    return_val = 3;
  else if (strcmp (ua, "Opera/6.03 (Linux i586; U)") == 0)
    return_val = 4;
  else if (strcmp (ua, "Mozilla/4.0 (compatible; MSIE 5.0; Linux i586)") == 0)
    return_val = 5;
  else
    return_val = 0;

  return return_val;
}

void user_agent_combo_box_config_notify (GConfClient *client,
					 guint        cnxn_id,
					 GConfEntry  *entry,
					 gpointer     user_data)
{
  GtkWidget *w = user_data;
  gchar *s = NULL;

  s = gconf_value_get_string (gconf_entry_get_value (entry));
 
  gtk_combo_box_set_active (GTK_COMBO_BOX(w), ua2i (s));
}

void entry_user_agent_combo_box_changed_callback (GtkWidget* w, gpointer user_data)
{
  GConfClient *client;
  gint i;
  gchar *ua = NULL;

  client = GCONF_CLIENT(g_object_get_data (G_OBJECT (w), "client"));
  i = gtk_combo_box_get_active (GTK_COMBO_BOX(w));

  gconf_client_set_string (client, (gchar *) user_data, i2ua (i), NULL);
}

/*
void favicon_option_menu_config_notify (GConfClient *client,
					guint        cnxn_id,
					GConfEntry  *entry,
					gpointer     user_data)
{
  GtkWidget *w = user_data;
  gint i;

  i = gconf_value_get_int (gconf_entry_get_value (entry));
 
  gtk_option_menu_set_history (GTK_OPTION_MENU(w), i);
}

void entry_favicon_option_menu_changed_callback (GtkWidget* w, gpointer user_data)
{
  GConfClient *client;
  gint i;

  client = GCONF_CLIENT(g_object_get_data (G_OBJECT (w), "client"));
  i = gtk_option_menu_get_history (GTK_OPTION_MENU(w));

  gconf_client_set_int (client, (gchar *) user_data, i, NULL);
}
*/

void string_entry_config_notify (GConfClient *client,
				 guint        cnxn_id,
				 GConfEntry  *entry,
				 gpointer     user_data)
{
  GtkWidget *w = user_data;
 
  gtk_entry_set_text (GTK_ENTRY(w), gconf_value_get_string (gconf_entry_get_value (entry)));
}

void entry_entry_value_changed_callback (GtkWidget* w, gpointer user_data)
{
  GConfClient *client;
  gchar *s;

  client = GCONF_CLIENT(g_object_get_data (G_OBJECT (w), "client"));
  s = gtk_entry_get_text (GTK_ENTRY(w));

  gconf_client_set_string (client, (gchar *) user_data, s, NULL);
}


void setup_galeon_general ()
{
  GtkWidget *w;
  gchar *gconf_key;

  gconf_key = "/apps/galeon/Advanced/Network/user_agent";
  w = glade_xml_get_widget (main_window_xml, "user_agent_combobox");
  if (!gconf_key_is_string (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, user_agent_combo_box_config_notify);
      g_signal_connect (G_OBJECT (w), "changed",
			G_CALLBACK (entry_user_agent_combo_box_changed_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_combo_box_set_active (GTK_COMBO_BOX(w), ua2i (gconf_key_get_string (gconf_key)));
    }

  gconf_key = "/apps/galeon/UI/Windows/windows_title";
  w = glade_xml_get_widget (main_window_xml, "window_title_entry");
  if (!gconf_key_is_string (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, string_entry_config_notify);
      g_signal_connect (G_OBJECT (w), "changed",
			G_CALLBACK (entry_entry_value_changed_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_entry_set_text (GTK_ENTRY(w), gconf_key_get_string (gconf_key));
    }

/*   gconf_key = "/apps/galeon/Browsing/Bookmarks/autobookmarks_shorten"; */
/*   w = glade_xml_get_widget (main_window_xml, "max_length_title_autobookmarks_spinbutton"); */
/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_spin_button_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "changed", */
/* 			G_CALLBACK (entry_spin_button_value_changed_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_spin_button_set_value (GTK_SPIN_BUTTON(w), gconf_key_get_int (gconf_key)); */
/*     } */

/*   gconf_key = "/apps/galeon/Browsing/Bookmarks/autobookmarks_count"; */
/*   w = glade_xml_get_widget (main_window_xml, "max_number_autobookmarks_spinbutton"); */
/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_spin_button_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "changed", */
/* 			G_CALLBACK (entry_spin_button_value_changed_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_spin_button_set_value (GTK_SPIN_BUTTON(w), gconf_key_get_int (gconf_key)); */
/*     } */

  gconf_key = "/apps/galeon/Browsing/Bookmarks/smart_bm_entry_width";
  w = glade_xml_get_widget (main_window_xml, "smart_bookmarks_width_spinbutton");
  if (!gconf_key_is_int (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, int_spin_button_config_notify);
      g_signal_connect (G_OBJECT (w), "changed",
			G_CALLBACK (entry_spin_button_value_changed_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_spin_button_set_value (GTK_SPIN_BUTTON(w), gconf_key_get_int (gconf_key));
    }

  gconf_key = "/apps/galeon/Browsing/Bookmarks/smartbookmarks_hide_arrows";
  w = glade_xml_get_widget (main_window_xml, "arrows_smart_bookmarks_checkbutton");
  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }


/*   gconf_key = "/apps/galeon/UI/Tabs/favicons_in_tabs"; */
/*   w = glade_xml_get_widget (main_window_xml, "favicon_optionmenu"); */
/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, favicon_option_menu_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "changed", */
/* 			G_CALLBACK (entry_favicon_option_menu_changed_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_option_menu_set_history (GTK_OPTION_MENU(w), gconf_key_get_int (gconf_key)); */
/*     } */

/*   gconf_key = "/apps/galeon/Browsing/General/host_favicons"; */
/*   w = glade_xml_get_widget (main_window_xml, "auto_download_favivon_checkbutton"); */
/*   if (!gconf_key_is_bool (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, bool_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key)); */
/*     } */



  gconf_key = "/apps/galeon/Browsing/History/completion_show_titles";
  w = glade_xml_get_widget (main_window_xml, "show_titles_auto_complete_checkbutton");
  if (!gconf_key_is_bool (gconf_key))
    {
      gtk_widget_set_sensitive (w, FALSE);
    }
  else
    {
      setup_setting_widget (w, gconf_key, bool_config_notify);
      g_signal_connect (G_OBJECT (w), "toggled",
			G_CALLBACK (entry_bool_toggled_callback),
			gconf_key);
      /* Set correct initial value of widget */
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key));
    }

/*   gconf_key = "/apps/galeon/Browsing/History/completion_huge"; */
/*   w = glade_xml_get_widget (main_window_xml, "auto_complete_huge_checkbutton"); */
/*   if ((!gconf_key_is_bool (gconf_key))) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, bool_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "toggled", */
/* 			G_CALLBACK (entry_bool_toggled_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(w), gconf_key_get_bool (gconf_key)); */
/*     } */

/*   gconf_key = "/apps/galeon/Browsing/History/completion_max_short"; */
/*   w = glade_xml_get_widget (main_window_xml, "items_autocomplete_spinbutton"); */
/*   if (!gconf_key_is_int (gconf_key)) */
/*     { */
/*       gtk_widget_set_sensitive (w, FALSE); */
/*     } */
/*   else */
/*     { */
/*       setup_setting_widget (w, gconf_key, int_spin_button_config_notify); */
/*       g_signal_connect (G_OBJECT (w), "changed", */
/* 			G_CALLBACK (entry_spin_button_value_changed_callback), */
/* 			gconf_key); */
/*       /\* Set correct initial value of widget *\/ */
/*       gtk_spin_button_set_value (GTK_SPIN_BUTTON(w), gconf_key_get_int (gconf_key)); */
/*     } */

}
