/*
  GNOME Configurator
  Copyright (C) 2002-2004 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ctype.h>
#include <stdlib.h>
#include <glib.h>
#include <stdio.h>
#include <gdk/gdk.h>

gboolean file_exists (char *f)
{
  gboolean returnme;

  FILE *fp;

  fp = fopen (f, "r");
  if (fp!=NULL)
    {
      returnme = TRUE;
      fclose (fp);
    }
  else 
    returnme = FALSE;

  return returnme;
}

void modify_gtkrc (char *gtkrc_fname, gboolean apply_widget_colors)
{
  FILE *fp = NULL;
  GList *lines = NULL;

  if (file_exists(gtkrc_fname))
    {
      // iterate through all the lines, and put them in a glist
      // write back lines not coming from GNOME Configurator
      // append the GNOME Configurator lines
      GString * temp_string;
      temp_string = g_string_new(NULL);

      fp = fopen (gtkrc_fname, "r");
      if (fp == NULL)
	{
	  return;
	}
      else
	{
	  gchar c;
	  c = getc(fp);
	  while(c!=EOF)
	    {
	      while(c!=EOF && c!='\n')
		{
		  temp_string = g_string_append_c(temp_string, c);
		  c = getc(fp);
		}
	      temp_string = g_string_new(g_strstrip(temp_string->str));

	      if (!g_pattern_match_simple("# -- Appended by GNOME Configurator*", temp_string->str) &&
		  !g_pattern_match_simple("include \".gtkrc-2.0-widget_cog\"*", temp_string->str) &&
		  !g_pattern_match_simple("include \".gtkrc-2.0-scrollbar_cog\"", temp_string->str))
		{
		  //fprintf(stdout, "%s\n", temp_string->str);
		  //fflush(stdout);
		  lines = g_list_append(lines, temp_string);
		}
	  
	      temp_string = g_string_new(NULL);
	      c = getc(fp);
	    }
	  fclose(fp);
	}
    }
  // simply write the file from scratch
  fp = fopen (gtkrc_fname, "w");
  if (fp == NULL)
    {
      return;
    }
  else
    {
      //FIXME: use g_list_foreach instead
      int i;
      int j = g_list_length(lines);
      for (i=0;i<j;i++)
	{
	  GString *temp = (g_list_nth(lines,i))->data;
	  fputs(g_string_append(temp, "\n")->str, fp);
	}

      fputs ("# -- Appended by GNOME Configurator\n", fp);
      if (apply_widget_colors) 
      	{
      	  fputs ("include \".gtkrc-2.0-widget_cog\"\n", fp);
      	}
      fputs ("include \".gtkrc-2.0-scrollbar_cog\"\n", fp);
      fclose (fp);
    }
}

void gtkrc_apply_changes ()
{
  GdkEventClient event;
  event.type = GDK_CLIENT_EVENT;
  event.send_event = TRUE;
  event.window = NULL;
  event.message_type = gdk_atom_intern("_GTK_READ_RCFILES", FALSE);
  event.data_format = 8;
  gdk_event_send_clientmessage_toall((GdkEvent *)&event);
}

int get_scrollbar_slider_length (char *scrollbar_fname)
{
  GString * temp_string;
  temp_string = g_string_new(NULL);
  int retval = 15;

  FILE *fp = fopen (scrollbar_fname, "r");
  if (fp == NULL)
    {
      return retval;
    }
  else
    {
      gchar c;
      c = getc(fp);
      while(c!=EOF)
	{
	  while(c!=EOF && c!='\n')
	    {
	      temp_string = g_string_append_c(temp_string, c);
	      c = getc(fp);
	    }
	  temp_string = g_string_new(g_strstrip(temp_string->str));

	  if (g_pattern_match_simple("GtkScrollbar::min_slider_length = *", temp_string->str))
	  {
	    int slider_length;
	    sscanf(temp_string->str, "GtkScrollbar::min_slider_length = %i", &slider_length);
	    retval = slider_length;
	  }
	  
	  temp_string = g_string_new(NULL);
	  c = getc(fp);
	}
      fclose(fp);
    }

  return retval;
}

gboolean get_scrollbar_has_backward_stepper (char *scrollbar_fname){
  GString * temp_string;
  temp_string = g_string_new(NULL);
  gboolean retval = TRUE;

  FILE *fp = fopen (scrollbar_fname, "r");
  if (fp == NULL)
    {
      return retval;
    }
  else
    {
      gchar c;
      c = getc(fp);
      while(c!=EOF)
	{
	  while(c!=EOF && c!='\n')
	    {
	      temp_string = g_string_append_c(temp_string, c);
	      c = getc(fp);
	    }
	  temp_string = g_string_new(g_strstrip(temp_string->str));

	  if (g_pattern_match_simple("GtkScrollbar::has_backward_stepper = *", temp_string->str))
	  {
	    int enable_int;
	    sscanf(temp_string->str, "GtkScrollbar::has_backward_stepper = %i", &enable_int);

	    if (enable_int != 0)
	      {
		retval = TRUE;
	      }
	  }
	  
	  temp_string = g_string_new(NULL);
	  c = getc(fp);
	}
      fclose(fp);
    }

  return retval ;
}

gboolean get_scrollbar_has_secondary_backward_stepper (char *scrollbar_fname)
{
  GString * temp_string;
  temp_string = g_string_new(NULL);
  gboolean retval = FALSE;

  FILE *fp = fopen (scrollbar_fname, "r");
  if (fp == NULL)
    {
      return retval;
    }
  else
    {
      gchar c;
      c = getc(fp);
      while(c!=EOF)
	{
	  while(c!=EOF && c!='\n')
	    {
	      temp_string = g_string_append_c(temp_string, c);
	      c = getc(fp);
	    }
	  temp_string = g_string_new(g_strstrip(temp_string->str));

	  if (g_pattern_match_simple("GtkScrollbar::has_secondary_backward_stepper = *", temp_string->str))
	  {
	    int enable_int;
	    sscanf(temp_string->str, "GtkScrollbar::has_secondary_backward_stepper = %i", &enable_int);

	    if (enable_int != 0) 
	      {
		retval = TRUE;
	      }
	  }
	  
	  temp_string = g_string_new(NULL);
	  c = getc(fp);
	}
      fclose(fp);
    }

  return retval;
}

void write_scrollbar_gtkrc (char *scrollbar_fname, int slider_length, gboolean has_backward_stepper, gboolean has_secondary_backward_stepper)
{
  FILE *fp = fopen (scrollbar_fname, "w");
  if (fp == NULL)
    {
      return;
    }
  else
    {
      GString *backward;
      GString *secondary_backward;
      GString *min_slider;

      backward = g_string_new(NULL);
      secondary_backward = g_string_new(NULL);
      min_slider = g_string_new(NULL);
      
      if (has_backward_stepper)
	{
	  g_string_sprintf(backward, "  GtkScrollbar::has_backward_stepper = %u\n", 1);
	}
      else
	{
	  g_string_sprintf(backward, "  GtkScrollbar::has_backward_stepper = %u\n", 0);
	}
      if (has_secondary_backward_stepper)
	{
	  g_string_sprintf(secondary_backward, "  GtkScrollbar::has_secondary_backward_stepper = %u\n", 1);
	}
      else
	{
	  g_string_sprintf(secondary_backward, "  GtkScrollbar::has_secondary_backward_stepper = %u\n", 0);
	}
      g_string_sprintf(min_slider, "  GtkScrollbar::min_slider_length = %u\n", slider_length);
      
      fputs ("style \"scrollbar_cog\" {\n", fp);
      fputs (backward->str, fp);
      fputs (secondary_backward->str, fp);
      fputs (min_slider->str, fp);
      fputs ("}\n", fp);
      fputs ("\n", fp);
      fputs ("class \"GtkScrollbar\" style \"scrollbar_cog\"\n", fp);
      fclose (fp);
    }
}

gboolean get_enable_colors (char *gtkrc_fname)
{
  GString * temp_string;
  temp_string = g_string_new(NULL);
  gboolean retval = FALSE;

  FILE *fp = fopen (gtkrc_fname, "r");
  if (fp == NULL)
    {
      return FALSE;
    }
  else
    {
      gchar c;
      c = getc(fp);
      while(c!=EOF)
	{
	  while(c!=EOF && c!='\n')
	    {
	      temp_string = g_string_append_c(temp_string, c);
	      c = getc(fp);
	    }
	  temp_string = g_string_new(g_strstrip(temp_string->str));

	  //fprintf(stdout, "%s\n", temp_string->str);
	  //fflush(stdout);

	  if (g_pattern_match_simple("include \".gtkrc-2.0-widget_cog\"", temp_string->str))
	  {
	    retval = TRUE;
	  }
	  
	  temp_string = g_string_new(NULL);
	  c = getc(fp);
	}
      fclose(fp);
    }

  return(retval);
}

char *get_widget_color (char *widget_fname, char *color_name)
{
  GString * temp_string;
  temp_string = g_string_new(NULL);
  char retval[7] = "#ffffff";

  FILE *fp = fopen (widget_fname, "r");
  if (fp == NULL)
    {
      return g_string_new(retval)->str;
    }
  else
    {
      gchar c;
      c = getc(fp);
      while(c!=EOF)
	{
	  while(c!=EOF && c!='\n')
	    {
	      temp_string = g_string_append_c(temp_string, c);
	      c = getc(fp);
	    }
	  temp_string = g_string_new(g_strstrip(temp_string->str));
	  GString *match_string = g_string_new(color_name);
	  match_string = g_string_append(match_string, " = *");

	  if (g_pattern_match_simple(match_string->str, temp_string->str))
	  {
	    //fprintf(stdout, "%s\n", temp_string->str);
	    //fflush(stdout);

	    GString *scan_string = g_string_new(color_name);
	    scan_string = g_string_append(scan_string, " = \"%7s");
	    sscanf(temp_string->str, scan_string->str, retval);
	    
	    //fprintf(stdout, "%s\n", retval);
	    //fflush(stdout);
	  }
	  
	  temp_string = g_string_new(NULL);
	  c = getc(fp);
	}
      fclose(fp);
    }

  return g_string_new(retval)->str;
}

void write_widget_gtkrc (char *widget_fname,
			 char *fgNORMAL, char *fgACTIVE, char *fgPRELIGHT, char *fgSELECTED, char* fgINSENSITIVE,
			 char *bgNORMAL, char *bgACTIVE, char *bgPRELIGHT, char *bgSELECTED, char* bgINSENSITIVE,
			 char *baseNORMAL, char *baseACTIVE, char *basePRELIGHT, char *baseSELECTED, char* baseINSENSITIVE,
			 char *textNORMAL, char *textACTIVE, char *textPRELIGHT, char *textSELECTED, char* textINSENSITIVE)
{
  FILE *fp = fopen (widget_fname, "w");
  if (fp == NULL)
    {
      return;
    }
  else
    {
      fputs ("style \"widget_cog\"\n", fp);
      fputs ("{\n", fp);

      fputs ("  fg[NORMAL] = ", fp);
      fputs ("\"", fp);
      fputs (fgNORMAL, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  fg[ACTIVE] = ", fp);
      fputs ("\"", fp);
      fputs (fgACTIVE, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  fg[PRELIGHT] = ", fp);
      fputs ("\"", fp);
      fputs (fgPRELIGHT, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  fg[SELECTED] = ", fp);
      fputs ("\"", fp);
      fputs (fgSELECTED, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  fg[INSENSITIVE] = ", fp);
      fputs ("\"", fp);
      fputs (fgINSENSITIVE, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  bg[NORMAL] = ", fp);
      fputs ("\"", fp);
      fputs (bgNORMAL, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  bg[ACTIVE] = ", fp);
      fputs ("\"", fp);
      fputs (bgACTIVE, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  bg[PRELIGHT] = ", fp);
      fputs ("\"", fp);
      fputs (bgPRELIGHT, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  bg[SELECTED] = ", fp);
      fputs ("\"", fp);
      fputs (bgSELECTED, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  bg[INSENSITIVE] = ", fp);
      fputs ("\"", fp);
      fputs (bgINSENSITIVE, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  base[NORMAL] = ", fp);
      fputs ("\"", fp);
      fputs (baseNORMAL, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  base[ACTIVE] = ", fp);
      fputs ("\"", fp);
      fputs (baseACTIVE, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  base[PRELIGHT] = ", fp);
      fputs ("\"", fp);
      fputs (basePRELIGHT, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  base[SELECTED] = ", fp);
      fputs ("\"", fp);
      fputs (baseSELECTED, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  base[INSENSITIVE] = ", fp);
      fputs ("\"", fp);
      fputs (baseINSENSITIVE, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  text[NORMAL] = ", fp);
      fputs ("\"", fp);
      fputs (textNORMAL, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  text[ACTIVE] = ", fp);
      fputs ("\"", fp);
      fputs (textACTIVE, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  text[PRELIGHT] = ", fp);
      fputs ("\"", fp);
      fputs (textPRELIGHT, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  text[SELECTED] = ", fp);
      fputs ("\"", fp);
      fputs (textSELECTED, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("  text[INSENSITIVE] = ", fp);
      fputs ("\"", fp);
      fputs (textINSENSITIVE, fp);
      fputs ("\"", fp);
      fputs ("\n", fp);

      fputs ("}\n", fp);
      fputs ("\n", fp);
      fputs ("widget_class \"*\" style \"widget_cog\"\n", fp);
      
      fclose(fp);
    }
}
