/*
  GNOME Comics Organizer
  Copyright (C) 1999-2000 Mads Villadsen <maxximum@krakoa.dk>
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdarg.h>

void debug_printf(const char *format, ...)
{
#if DEBUG
  va_list ap;
  int d;
  unsigned int i, u;
  char c, *s;

  fprintf(stderr, "*** debug : ");
  
  va_start(ap, format);
  while (*format){

    if (*format=='%'){
      format++;
      switch(*format++){
      case 's':           // string
	s = va_arg(ap, char *);
	fprintf(stderr, "%s", s);
	break;
      case 'x':
	i = va_arg(ap, unsigned int);
	fprintf(stderr, "%x", i);
	break;
      case 'i':
	i = va_arg(ap, unsigned int);
	fprintf(stderr, "%i", i);
	break;
      case 'u':
	u = va_arg(ap, unsigned int);
	fprintf(stderr, "%u", u);
	break;
      case 'd':           // int
	d = va_arg(ap, int);
	fprintf(stderr, "%d", d);
	break;
      case 'c': // char
	// need a cast here since va_arg only
	// takes fully promoted types
	c = (char) va_arg(ap, int);
	fprintf(stderr, "%c", c);
	break;
      }
    }
    else{
      putc(*format++, stderr);
    }
  }
  va_end(ap);

  fflush(stderr);

#endif
}
