/*
  COnfigurator for Gnome
  Copyright (C) 2002 Mads Villadsen
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <gnome.h>
#include <glade/glade.h>
#include "callbacks.h"

extern GString *GLADE_FILE;

void
on_close_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_main_quit ();
}

void
on_about_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *about_dialog;
  GladeXML *temp_xml;

  temp_xml = glade_xml_new (GLADE_FILE->str, "about_dialog", NULL);
  about_dialog = glade_xml_get_widget (temp_xml, "about_dialog");
  g_object_set(about_dialog, "name", "GNOME Configurator", NULL);
  g_object_set(about_dialog, "version", VERSION, NULL);
}

void
on_main_window_delete_event            (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_main_quit ();
}
