(* Copyright 1996-2000, Critical Mass, Inc.  All rights reserved. *)
(* See file COPYRIGHT-CMASS for details. *)

(* A "TextLiteral.T" is a text generated by the compiler.  They contain
   either 8-bit "CHAR" characters or 16-bit "WIDECHAR" characters, but
   not both.  These values do not reside in the heap.
   In spite of the declaration, the "contents" array is only large enough
   to hold the literal and its null termination. *)

UNSAFE INTERFACE TextLiteral;

IMPORT RTHooks, TextClass;

CONST
  MaxBytes = LAST (INTEGER) DIV BITSIZE (Byte) - 32;

TYPE
  T = RTHooks.TextLiteral;
REVEAL
  T = TEXT BRANDED "TextLiteral.T" OBJECT
    cnt : INTEGER;
    buf : ARRAY [0..MaxBytes - 1] OF Byte;
  OVERRIDES
    get_info       := RTHooks.TextLitInfo;
    get_char       := RTHooks.TextLitGetChar;
    get_wide_char  := RTHooks.TextLitGetWideChar;
    get_chars      := RTHooks.TextLitGetChars;
    get_wide_chars := RTHooks.TextLitGetWideChars;
  END;
  (* The array contains the characters of the text followed by a null
     character.  If "cnt" is negative each pair of bytes in "buf"
     is a "WIDECHAR".  Otherwise, each byte of "buf" is a "CHAR". *)

TYPE
  Byte = [0..255];

END TextLiteral.

